package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * 表达式Service
 *
 * @author zhsy
 * @date 2021-09-14
 */
public class FormulaServiceCmd extends DesignerServiceCmd {

    public static final String CMD = "FormulaServiceCmd";

    /***表单formKey*/
//    private String formKey;

    /***type:getFormList和getForm*/
    private String type;
    
    /***表达式表单formulaFormKey*/
    private String formulaFormKey;
    /***查询的表单Key*/
    private String searchKey;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
//        formKey = arguments.get("formKey") != null ? TypeConvertor.toString(arguments.get("formKey")) : "";
        type = TypeConvertor.toString(arguments.get("type"));
        formulaFormKey = arguments.get("formulaFormKey") != null ? TypeConvertor.toString(arguments.get("formulaFormKey")) : "";
        searchKey = arguments.get("searchKey") != null ? TypeConvertor.toString(arguments.get("searchKey")) : "";
    }

    @Override
    public Object innerDoCmd(DefaultContext context) {
        try {
            IMetaFactory metaFactory = context.getVE().getMetaFactory();
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            if ("getFormList".equals(type)) {
                JSONArray array = new JSONArray();
                metaFormList.forEach(q -> {
                    JSONObject obj = new JSONObject();
                    obj.put(ConstantUtil.FORM_KEY, q.getKey());
                    obj.put("FormCaption", q.getCaption());
                    array.add(obj);
                });
                return array.toJSONString();
            } else if ("getForm".equals(type)) {
                JSONArray array = new JSONArray();
                metaFormList.forEach(q -> {
                    if (formulaFormKey.equals(q.getKey())) {
                        IDLookup idLookup = IDLookup.getIDLookup(q.getForm());
                        Collection<String> keys = idLookup.getFieldKeys();
                        if (null != keys && !keys.isEmpty()) {
                            List<String> list = new ArrayList<>(keys);
                            Collections.sort(list);
                            String caption = "";
                            for (String key : list) {
                                if (StringUtils.isNotEmpty(key)) {
                                    if (StringUtils.isNotEmpty(key)) {
                                        caption = idLookup.getFieldCaption(key);
                                        if (StringUtils.isEmpty(caption)) {
                                            // grid
                                            if (null != idLookup.getGridCellByKey(key)) {
                                                caption = idLookup.getGridCellByKey(key).getCaption();
                                            }
                                            // listView
                                            if (StringUtils.isEmpty(caption)) {
                                                if (null != idLookup.getListViewColumnByKey(key)) {
                                                    caption = idLookup.getListViewColumnByKey(key).getCaption();
                                                }
                                            }
                                        }

                                        JSONObject obj = new JSONObject();
                                        obj.put(ConstantUtil.KEY, key);
                                        obj.put(ConstantUtil.CAPTION, caption);
                                        array.add(obj);
                                    }
                                }
                            }
                        }
                    }
                });
                return array.toJSONString();
            } else if ("searchFormCaptionByKey".equals(type)) {
                JSONArray array = new JSONArray();
                for (MetaFormProfile metaFormProfile : metaFormList) {
                    if (metaFormProfile.getForm().getKey().equals(searchKey)) {
                        JSONObject obj = new JSONObject();
                        obj.put(ConstantUtil.FORM_KEY, metaFormProfile.getForm().getKey());
                        obj.put("FormCaption", metaFormProfile.getForm().getCaption());
                        array.add(obj);
                        break;
                    }
                }
                return array.toJSONString();
            }
        } catch (Throwable e) {
            ExceptionUtils.getStackTrace(e);
        }
        return null;
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new FormulaServiceCmd();
    }

}
