package com.bokesoft.yes.design.cmd;


import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.tool.FillMacro4Designer;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class FillMacroCmd extends DesignerServiceCmd {
	public static final String CMD = "fillMacro";
	/**
	 * 表单名和公式名
	 */
	private String formula;
	private String key;

	@Override
	public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> arguments) throws Throwable {
		formula = (String) arguments.get("formula");
		key = (String) arguments.get("key");
	}

	@Override
	public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
		IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
		if("CommonDef".equalsIgnoreCase(key)){
			return null;
		}
		MetaForm metaForm;
		try {
			metaForm = globalInstance.getMetaForm(key);

		}catch (Exception e){
			return  null;

		}
		if (StringUtils.isNotEmpty(formula)){
			String macroTreeContent = FillMacro4Designer.parseFormula(globalInstance, metaForm, formula+"()");
			JSONObject json = new JSONObject();
			if (macroTreeContent.equalsIgnoreCase(formula+"()\n")){
				return null;
			}
			json.put("macroTreeContent", macroTreeContent);
			return json;
		}else {
			return  null;
		}
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new FillMacroCmd();
	}

	@Override
	public String getCmd() {
		return CMD;
	}
}
