package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSON;
import com.bokesoft.erp.all.initiator.InitializingDesigner;
import com.bokesoft.erp.desigerfunction.datasource.GenerateFunctionsJsonFile;
import com.bokesoft.erp.redis.RedisUtils;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.codemirror.GenerateFrontFunsFromXml;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.vo.Exp;
import com.bokesoft.yes.design.vo.Para;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;
import org.springframework.scheduling.annotation.Async;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 表达式自动完成类
 *
 * @author zhsy
 * @date 2020-06-18
 */
public class ExpAutoCompleteCmd extends DesignerServiceCmd {

    private static final Logger logger = Logger.getLogger(ExpAutoCompleteCmd.class.getName());

    public static final String CMD = "ExpAutoComplete";
    /*** 前端函数json文件 */
    public static final String FRONT_JSON_FILE = "/json/frontFuns.json";


    /*** 常量 */
    public static final String SPACE = " ";

    public static final String DESIGNER = "designer";

    /*** projectKey：获取对应工程key */
    public static String formulaKeys = "designer";
    /*** 参数dataType:前后端函数、宏公式、表单 */
    public String dataType;
    /*** 参数currentFormKey：当前表单key */
    public String currentFormKey;

    /*** 前后端函数列表 */
    private List<String> funcList;
    /*** 前后端函数描述 */
    private List<String> funcDescList;
    /*** 组件id列表 */
    private List<String> componentIdList;
    /*** 组件caption列表 */
    private List<String> componentDescList;
    /*** 宏公式id列表 */
    private List<String> macroIdList;
    /*** 宏公式caption列表 */
    private List<String> macroDescList;
    /*** 参数描述列表 */
    private List<String> paramDescList;
    /*** 返回值描述列表 */
    private List<String> returnValueDescList;
    /*** 关键字 */
    private final StringBuffer keyWords = new StringBuffer();
    /*** 读取json文件json对象 */
    private static JSONObject funsDetailDtl;
    /*** 函数map */
    private static Map<String, String> map;
    /*** cache */
    private static ICache<Object> cache;
    
    public final static String cacheKey = RedisUtils.RedisKey_Prefix + "FormulaDataSource";

    public static void generateFunctionCache() {
        cache = CacheFactory.getInstance().createCache(cacheKey);
        // 初始化时清空map
        map = null;
        try {
            if (InitializingDesigner.isEnable()) {
                formulaKeys = DESIGNER + "," + StringUtils.join(InitializingDesigner.getFormulaKeys(), ",");
            }else {
                formulaKeys = StringUtils.join(InitializingDesigner.getFormulaKeys(), ",");
            }
            // 初始化向cache中存储所有公式
            funsDetailDtl = readFunsFromJsonFile(formulaKeys);
        } catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
    }

    public ExpAutoCompleteCmd() {
    }

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        dataType = (String) arguments.get("dataType");
        currentFormKey = (String) arguments.get("currentFormKey");
        String fk = (String) arguments.get("formulaKeys");
        formulaKeys = StringUtils.isNotEmpty(fk) ? fk : DESIGNER;
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        JSONObject jsonObject = new JSONObject();
        try {
            if (StringUtils.isEmpty(dataType)) {
                return jsonObject.toString();
            }
            // 一步放所有表单到缓存中
            asyncSetFormList(context);
            if (dataType.equals("initKeyWords")) {
                StringBuffer keyWordsBuffer = new StringBuffer(((HashMap<String, List<String>>) cache.get("designer")).get("keyWords").get(0));
                jsonObject.append("keyWords", keyWordsBuffer.toString());
                return jsonObject.toString();
            }
            switch (dataType) {
                case "function": {
                    // 尝试获取funs
                    funsDetailDtl = readFunsFromJsonFile(formulaKeys);
                    this.setFunctionList(jsonObject);
                    break;
                }
                case "macro": {
                    // 放页面宏公式到完成列表中
                    this.putMacrosIntoList(context);
                    //刷新表单宏公式
                    if (StringUtils.isNotEmpty(currentFormKey)) {
                        this.putFormMacrosIntoList(currentFormKey);
                    }
                    // 设置宏公式到jsonObject中
                    this.setMacrosList(jsonObject);
                    break;
                }
                case "form": {
                    if (StringUtils.isNotEmpty(currentFormKey)) {
                        // 放页面字段到自动完成列表中
                        this.putPageFieldsToList(context, currentFormKey);
                        // 设置页面组件列表到jsonObject中
                        this.setComponentList(jsonObject);
                        break;
                    }
                }
            }

            // 设置关键字
            this.setKeyWords(jsonObject);
        } catch (Throwable throwable) {
            logger.warning(ExceptionUtils.getStackTrace(throwable));
            throw new Throwable(throwable.getMessage());
        }
        return jsonObject.toString();
    }

    @Async
    void asyncSetFormList(DefaultContext context) throws Throwable {
        List<String> formKeyList = new ArrayList<>();
        List<String> formCaptionList = new ArrayList<>();
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        metaFormList.forEach(q -> {
            String FormKey = q.getKey();
            String FormCaption = q.getCaption();
            formKeyList.add(FormKey);
            formCaptionList.add(FormCaption);
        });
        cache.put("FormKeyList", formKeyList);
        cache.put("formCaptionList", formCaptionList);
    }


    /**
     * 设置函数列表，函数描述列表 函数参数描述列表 函数返回值描述列表
     *
     * @param jsonObject
     */
    private void setFunctionList(JSONObject jsonObject) {
        List<String> funcList;
        List<String> funcDescList;
        List<String> paramDescList;
        List<String> returnValueDescList;
        if (!funsDetailDtl.isEmpty()) {
            HashMap<String, Object> formulas = JSON.parseObject(funsDetailDtl.get("formulas").toString(), HashMap.class);
            for (Map.Entry<String, Object> entry : formulas.entrySet()) {
                HashMap<String, Object> m = JSON.parseObject(entry.getValue().toString(), HashMap.class);
                funcList = JSON.parseArray(JSON.parseArray(m.get("funcList").toString(), String.class).get(0), String.class);
                funcDescList = JSON.parseArray(JSON.parseArray(m.get("funcDescList").toString(), String.class).get(0), String.class);
                paramDescList = JSON.parseArray(JSON.parseArray(m.get("paramDescList").toString(), String.class).get(0), String.class);
                returnValueDescList = JSON.parseArray(JSON.parseArray(m.get("returnValueDescList").toString(), String.class).get(0), String.class);

                if (DESIGNER.equals(entry.getKey())) { // designer公式放在第一级 避免修改以前请求的结构
                    jsonObject.append("funcList", StringUtils.join(funcList.toArray(), "@~@"));
                    jsonObject.append("funcDescList", StringUtils.join(funcDescList.toArray(), "@~@"));
                    jsonObject.append("paramDescList", StringUtils.join(paramDescList.toArray(), "@~@"));
                    jsonObject.append("returnValueDescList", StringUtils.join(returnValueDescList.toArray(), "@~@"));
                } else {
                    JSONObject jsonObject1 = new JSONObject();
                    jsonObject.put(entry.getKey(), jsonObject1);
                    jsonObject1.append("funcList", StringUtils.join(funcList.toArray(), "@~@"));
                    jsonObject1.append("funcDescList", StringUtils.join(funcDescList.toArray(), "@~@"));
                    jsonObject1.append("paramDescList", StringUtils.join(paramDescList.toArray(), "@~@"));
                    jsonObject1.append("returnValueDescList", StringUtils.join(returnValueDescList.toArray(), "@~@"));
                }
            }
        }
    }

//    /***
//     * 设置函数列表
//     *
//     * @param jsonObject 放置前端显示的对象
//     */
//    private void setFuncList(JSONObject jsonObject) {
//        // 函数名列表
//        this.funcList = new ArrayList<>();
//        // 全部函数列表
//        if (!funsDetailDtl.isEmpty()) {
//            this.funcList.addAll(JSON.parseArray(
//                    JSON.parseArray(funsDetailDtl.get("funcList").toString(), String.class).get(0), String.class));
//            jsonObject.append("funcList", StringUtils.join(funcList.toArray(), "@~@"));
//        }
//    }

//    /***
//     * 设置函数描述列表
//     *
//     * @param jsonObject 放置前端显示的对象
//     */
//    private void setFuncDescList(JSONObject jsonObject) {
//        // 函数描述列表
//        this.funcDescList = new ArrayList<>();
//        // 全部函数列表
//        if (!funsDetailDtl.isEmpty()) {
//            this.funcDescList.addAll(JSON.parseArray(
//                    JSON.parseArray(funsDetailDtl.get("funcDescList").toString(), String.class).get(0), String.class));
//            jsonObject.append("funcDescList", StringUtils.join(funcDescList.toArray(), "@~@"));
//        }
//
//    }
//
//    /***
//     * 设置函数参数描述列表
//     *
//     * @param jsonObject 放置前端显示的对象
//     */
//    private void setParamDescList(JSONObject jsonObject) {
//        // 函数参数描述列表
//        this.paramDescList = new ArrayList<>();
//        // 全部函数参数列表
//        if (!funsDetailDtl.isEmpty()) {
//            this.paramDescList.addAll(JSON.parseArray(
//                    JSON.parseArray(funsDetailDtl.get("paramDescList").toString(), String.class).get(0), String.class));
//            jsonObject.append("paramDescList", StringUtils.join(this.paramDescList.toArray(), "@~@"));
//        }
//    }
//
//    /***
//     * 设置函数返回值描述列表
//     *
//     * @param jsonObject 放置前端显示的对象
//     */
//    private void setReturnValueDescList(JSONObject jsonObject) {
//        // 函数返回值描述列表
//        this.returnValueDescList = new ArrayList<>();
//        // 全部函数返回值列表
//        if (!funsDetailDtl.isEmpty()) {
//            this.returnValueDescList.addAll(JSON.parseArray(
//                    JSON.parseArray(funsDetailDtl.get("returnValueDescList").toString(), String.class).get(0),
//                    String.class));
//            jsonObject.append("returnValueDescList", StringUtils.join(this.returnValueDescList.toArray(), "@~@"));
//        }
//    }

    /***
     * 设置宏公式列表
     *
     * @param jsonObject 放置前端显示的对象
     */
    private void setMacrosList(JSONObject jsonObject) {
        jsonObject.append("macroIdList", StringUtils.join(this.macroIdList.toArray(), "@~@"));
        jsonObject.append("macroDescList", StringUtils.join(this.macroDescList.toArray(), "@~@"));
        cache.put("macroIdList", this.macroIdList);
        cache.put("macroDescList", this.macroDescList);
    }

    /***
     * 设置页面组件列表
     *
     * @param jsonObject 放置前端显示的对象
     */
    private void setComponentList(JSONObject jsonObject) {
        jsonObject.append("componentIdList", StringUtils.join(this.componentIdList.toArray(), "@~@"));
        jsonObject.append("componentDescList", StringUtils.join(this.componentDescList.toArray(), "@~@"));
        cache.put("componentIdList", this.componentIdList);
        cache.put("componentDescList", this.componentDescList);
    }

    /***
     * 设置关键字
     *
     * @param jsonObject 放置前端显示的对象
     */
    private void setKeyWords(JSONObject jsonObject) {
        // 所有关键字
        if (!funsDetailDtl.isEmpty()) {
            HashMap<String, Object> formulas = JSON.parseObject(funsDetailDtl.get("formulas").toString(), HashMap.class);
            for (Map.Entry<String, Object> entry : formulas.entrySet()) {
                HashMap<String, Object> m = JSON.parseObject(entry.getValue().toString(), HashMap.class);
                String[] keyWordsArray = JSON.parseArray(m.get("keyWords").toString(), String.class).toArray(new String[0]);
                StringBuilder keyWords = new StringBuilder();
                keyWords.append(StringUtils.join(keyWordsArray, " "));
                if (DESIGNER.equals(entry.getKey()) || "form".equals(dataType) || "macro".equals(dataType)) {
                    jsonObject.append("keyWords", keyWords.toString());
                } else {
                    JSONObject o = (JSONObject) jsonObject.get(entry.getKey());
                    o.append("keyWords", keyWords.toString());
                }
            }
        }
    }

    /***
     * 放页面宏公式到完成列表中
     *
     * @param context
     */
    private void putMacrosIntoList(DefaultContext context) {
        // 页面上的宏公式也添加到列表中
        macroIdList = new ArrayList<>();
        macroDescList = new ArrayList<>();

        // 添加宏公式到自动完成列表中
        Map<String, String> macroMap = this.getCommonDefMacro(context);
        if (null != macroMap && !macroMap.isEmpty()) {
            // 按map的key排序
            Map<String, String> resultMap = macroMap.entrySet().stream().sorted(Map.Entry.comparingByKey())
                    .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue,
                            LinkedHashMap::new));
            for (Map.Entry<String, String> entry : resultMap.entrySet()) {
                if (macroIdList.contains(entry.getKey())) {
                    continue;
                }
                macroIdList.add(entry.getKey());
                if (keyWords.indexOf(entry.getKey()) != -1) {
                    keyWords.append(entry.getKey()).append(" ");
                }
                macroDescList.add(entry.getValue());
            }
        }
    }

    /***
     * 放当前表单页面宏公式到完成列表中
     *
     * @param formKey
     */
    private void putFormMacrosIntoList(String formKey) throws Throwable {


        Map<String, String> macroMap = new HashMap<>();

        // 所有metaForm下的组件及宏公式
        IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
        MetaFormList metaFormList = iMetaFactory.getMetaFormList();
        if (metaFormList != null && !metaFormList.isEmpty()) {
            MetaFormProfile metaFormProfile = metaFormList.get(formKey);
            MetaProject metaProject = (MetaProject) metaFormProfile.getForm().getProject();
            MetaCommonDef metaCommonDef = iMetaFactory.getCommonDef(metaProject.getKey());
            // commonDef
            if (null != metaCommonDef) {
                setMacroMap(macroMap, metaCommonDef.getMacroCollection());
            }
            // 宏表达式
            MetaMacroCollection metaMacroCollection = metaFormProfile.getForm().getMacroCollection();
            setMacroMap(macroMap, metaMacroCollection);

        }

        if (null != macroMap && !macroMap.isEmpty()) {
            // 按map的key排序
            Map<String, String> resultMap = macroMap.entrySet().stream().sorted(Map.Entry.comparingByKey())
                    .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue,
                            LinkedHashMap::new));
            for (Map.Entry<String, String> entry : resultMap.entrySet()) {
                macroIdList.add(entry.getKey());
                if (keyWords.indexOf(entry.getKey()) != -1) {
                    keyWords.append(entry.getKey()).append(" ");
                }
                macroDescList.add(entry.getValue());
            }
        }
    }

    /***
     * 将当前表单的key和caption放到自动完成列表中
     *
     * @param context
     * @param currentFormKeys 当前表单
     */
    private void putPageFieldsToList(DefaultContext context, String currentFormKeys) {
        try {
            componentIdList = new ArrayList<>();
            componentDescList = new ArrayList<>();
            for (String currentFormKey : currentFormKeys.split(",")) {
                IMetaFactory metaFactory = context.getVE().getMetaFactory();
                MetaForm metaForm = metaFactory.getMetaForm(currentFormKey);
                if (metaForm != null) {
                    componentIdList.add(metaForm.getKey());
                    componentDescList.add(metaForm.getCaption());
                    if (keyWords.indexOf(metaForm.getKey()) != -1) {
                        keyWords.append(metaForm.getKey()).append(" ");
                    }
                    // 将当前表单下的所有组件的key和caption写入列表
                    IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                    Collection<String> keys = idLookup.getFieldKeys();
                    if (null != keys && !keys.isEmpty()) {
                        List<String> list = new ArrayList<>(keys);
                        Collections.sort(list);
                        String caption = "";
                        for (String key : list) {
                            if (StringUtils.isNotEmpty(key)) {
                                if (StringUtils.isNotEmpty(key)) {
                                    if (componentIdList.contains(key)) {
                                        continue;
                                    }
                                    componentIdList.add(key);
                                    if (keyWords.indexOf(key) != -1) {
                                        keyWords.append(key).append(" ");
                                    }
                                    caption = idLookup.getFieldCaption(key);
                                    if (StringUtils.isEmpty(caption)) {
                                        // grid
                                        if (null != idLookup.getGridCellByKey(key)) {
                                            caption = idLookup.getGridCellByKey(key).getCaption();
                                        }
                                        // listView
                                        if (StringUtils.isEmpty(caption)) {
                                            if (null != idLookup.getListViewColumnByKey(key)) {
                                                caption = idLookup.getListViewColumnByKey(key).getCaption();
                                            }
                                        }
                                    }
                                    componentDescList.add(caption);
                                }
                            }
                        }
                    }
                }
            }
        } catch (Throwable e) {
            logger.warning("将当前表单的key和caption放到自动完成列表中失败,异常为：" + ExceptionUtils.getStackTrace(e));
        }
    }

    /***
     * 获取宏表达式列表
     *
     * @param context 上下文
     * @return 宏表达式列表
     */
    private Map<String, String> getCommonDefMacro(DefaultContext context) {
        Map<String, String> macroMap = new HashMap<>(10000);
        try {
            IMetaFactory metaFactory = context.getVE().getMetaFactory();
            ExecutorService executorService = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            CountDownLatch countDownLatch = new CountDownLatch(2);
            // 公共宏公式
            Future<Map<String, String>> commonMacro = executorService.submit(() -> {
                Map<String, String> map = new HashMap<>();
                try {
                    // 公共的commonDef
                    MetaCommonDef metaCommonDef = metaFactory.getCommonDef("");
                    if (null != metaCommonDef) {
                        setMacroMap(map, metaCommonDef.getMacroCollection());
                    }
                } catch (Throwable throwable) {
                    logger.warning(ExceptionUtils.getStackTrace(throwable));
                } finally {
                    countDownLatch.countDown();
                }
                return map;
            });

            // 所有表单下的宏公式
            Future<Map<String, String>> formsMacro = executorService.submit(() -> {
                Map<String, String> map = new HashMap<>();
                try {
                    // 所有metaForm下的组件及宏公式
                    IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
                    MetaFormList metaFormList = globalInstance.getMetaFormList();
                    if (metaFormList != null && !metaFormList.isEmpty()) {
                        for (MetaFormProfile metaFormProfile : metaFormList) {
                            MetaForm form = globalInstance.getMetaForm(metaFormProfile.getKey());;
                            MetaProject metaProject = (MetaProject) form.getProject();
                            MetaCommonDef metaCommonDef = metaFactory.getCommonDef(metaProject.getKey());
                            // commonDef
                            if (null != metaCommonDef) {
                                setMacroMap(map, metaCommonDef.getMacroCollection());
                            }

                            // 宏表达式
                            MetaMacroCollection metaMacroCollection = form.getMacroCollection();
                            setMacroMap(map, metaMacroCollection);
                        }
                    }
                } catch (Throwable throwable) {
                    logger.warning(ExceptionUtils.getStackTrace(throwable));
                } finally {
                    countDownLatch.countDown();
                }
                return map;
            });
            countDownLatch.await();
            macroMap.putAll(commonMacro.get());
            macroMap.putAll(formsMacro.get());
        } catch (Throwable e) {
            logger.warning("获取宏表达式列表失败,异常为：" + ExceptionUtils.getStackTrace(e));
        }
        return macroMap;
    }

    /***
     * 设置宏表达式
     *
     * @param macroMap        宏表达式map
     * @param macroCollection 宏表达式集合
     */
    private void setMacroMap(Map<String, String> macroMap, MetaMacroCollection macroCollection) {
        if (null != macroCollection && !macroCollection.isEmpty()) {
            String args = "";
            String key = "";
            String value = "";
            for (MetaMacro metaMacro : macroCollection) {
                args = metaMacro.getArgs();
                if (StringUtils.isNotEmpty(args)) {
                    key = metaMacro.getKey() + "(" + args + ")";
                } else {
                    key = metaMacro.getKey() + "()";
                }
                value = metaMacro.getContent();
                macroMap.put(key, value);
            }
        }
    }

    /***
     * 从json文件中读取函数名、对应描述及关键字列表
     *
     * @return 列表
     */
    @SuppressWarnings("unchecked")
    private static JSONObject readFunsFromJsonFile(String formulaKeys) throws Throwable {
        JSONObject jsonObject = new JSONObject();
        JSONObject objects = new JSONObject();
        jsonObject.put("formulas", objects);
        InputStream inputStream = null;
        Reader reader = null;
        BufferedReader bufferedReader = null;
        Set<String> formulaKeyCollect = Arrays.stream(formulaKeys.split(",")).collect(Collectors.toSet());
        try {
            for (String s : formulaKeyCollect) {
                if ("macro".equalsIgnoreCase(s) || "form".equalsIgnoreCase(s)) {
                    continue;
                }
                // 函数列表
                List<String> funcList = new ArrayList<>();
                // 函数描述列表
                List<String> funcDescList = new ArrayList<>();
                // 函数参数描述列表
                List<String> paramDescList = new ArrayList<>();
                // 函数返回值描述列表
                List<String> returnValueDescList = new ArrayList<>();
                // 关键字
                StringBuilder keyWords = new StringBuilder();
                // json文件内容
                StringBuffer jsonFileContent;
                Map<String, String> tempMap = Collections.emptyMap();
                Object o = cache.get(s);
                HashMap<String, List<String>> dataSource;
                if (o != null) {
                    // cache中存储了直接赋值给jsonobject 此举会导致修改了文件 需要重启项目
                    dataSource = (HashMap<String, List<String>>) o;
                } else {
                    dataSource = new HashMap<>();
                    if (!DESIGNER.equals(s)) {
                        jsonFileContent = new StringBuffer(GenerateFrontFunsFromXml.generateFrontFunsJson(s));
                        tempMap = (Map<String, String>) JSON.parse((jsonFileContent.toString()).trim());
                    } else if (InitializingDesigner.isEnable()){
                        jsonFileContent = new StringBuffer();
                        inputStream = ExpAutoCompleteCmd.class.getResourceAsStream(FRONT_JSON_FILE);
                        reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                        bufferedReader = new BufferedReader(reader);
                        String read = "";
                        while ((read = bufferedReader.readLine()) != null) {
                            jsonFileContent.append(read + "\n");
                        }
                        tempMap = (Map<String, String>) JSON.parse((jsonFileContent.toString()).trim());
                        Map<String, String> parse = (Map<String, String>) JSON.parse((GenerateFunctionsJsonFile.getFunctionsJson()).trim());
                        tempMap.putAll(parse);
                    }
                    if (null == tempMap || tempMap.isEmpty()) {

                    }

                    map = tempMap;
                    // 获取关键字
                    keyWords.append(tempMap.get("keyWords"));

                    // 从map中获取自动完成的下拉列表数据
                    getAutoCompletedListFromMap(funcList, funcDescList, paramDescList, returnValueDescList);
                    dataSource.put("funcList", funcList);
                    dataSource.put("funcDescList", funcDescList);
                    dataSource.put("paramDescList", paramDescList);
                    dataSource.put("returnValueDescList", returnValueDescList);
                    ArrayList<String> keyWordArr = new ArrayList<>();
                    keyWordArr.add(keyWords.toString());
                    dataSource.put("keyWords", keyWordArr);
                    cache.put(s, dataSource);
                    //			cache.put("funcList", funcList);
                    //			cache.put("funcDescList", funcDescList);
                    //			cache.put("paramDescList", paramDescList);
                    //			cache.put("returnValueDescList", returnValueDescList);
                    //			cache.put("keyWords", keyWords);
                    //			cache.put("formulaKeys", formulaKeys);
                }
                JSONObject jsonObject1 = new JSONObject();
                jsonObject1.append("funcList", dataSource.get("funcList"));
                jsonObject1.append("funcDescList", dataSource.get("funcDescList"));
                jsonObject1.append("paramDescList", dataSource.get("paramDescList"));
                jsonObject1.append("returnValueDescList", dataSource.get("returnValueDescList"));
                jsonObject1.append("keyWords", dataSource.get("keyWords").get(0));
                objects.put(s, jsonObject1);
            }
        } catch (Throwable e) {
            throw new Throwable(e.getMessage());
        } finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                } catch (IOException e) {
                    logger.warning("close bufferedReader exception:" + ExceptionUtils.getStackTrace(e));
                }
            }
            if (null != reader) {
                try {
                    reader.close();
                } catch (IOException e) {
                    logger.warning("close reader exception:" + ExceptionUtils.getStackTrace(e));
                }
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    logger.warning("close inputStream exception:" + ExceptionUtils.getStackTrace(e));
                }
            }
        }
        return jsonObject;
    }

    /***
     * 从map中获取自动完成列表数据
     *
     * @param funcList            函数列表
     * @param funcDescList        函数描述列表
     * @param paramDescList       函数参数描述列表
     * @param returnValueDescList 函数返回值描述列表
     */
    private static Pattern INCLUCHINESE_PATTERN = Pattern.compile("[\u4e00-\u9fa5]");
    private static void getAutoCompletedListFromMap(List<String> funcList, List<String> funcDescList,
                                                    List<String> paramDescList, List<String> returnValueDescList) {
        if (null != map) {
            // 按map的key排序
            Map<String, String> resultMap = map.entrySet().stream().sorted(Map.Entry.comparingByKey())
                    .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue,
                            LinkedHashMap::new));
            Exp exp;
            List<Para> paraList;
            // 函数参数说明
            StringBuffer paraHintDesc = new StringBuffer();
            for (String key : resultMap.keySet()) {
                if ("keyWords".equals(key)) {
                    continue;
                }

                // 过滤含有中文的Key
                Matcher matcher = INCLUCHINESE_PATTERN.matcher(key);
                if (matcher.find()) {
                    continue;
                }
                funcList.add(key);

                exp = JSON.parseObject(JSON.toJSONString(resultMap.get(key)), Exp.class);
                String detail = exp.getDescDetail();
                if (StringUtils.isNotEmpty(detail)) {
                    detail = detail.replaceAll("aaaaaaaaaa", "{").replaceAll("bbbbbbbbbb", "}").replaceAll("null", "");
                } else {
                    detail = "";
                }
                funcDescList.add(StringUtils.isNotEmpty(exp.getDesc()) ? exp.getDesc() + " " + detail : detail);

                paraList = exp.getParas();
                paraHintDesc.setLength(0);
                if (null != paraList && !paraList.isEmpty()) {
                    for (int i = 0; i < paraList.size(); i++) {
                        if (i != paraList.size() - 1) {
                            paraHintDesc.append("参数" + (i + 1) + " " + paraList.get(i).getKey() + ",");
                            paraHintDesc.append("参数类型 " + paraList.get(i).getType() + "<br/>");
                        } else {
                            paraHintDesc.append("参数" + (i + 1) + " " + paraList.get(i).getKey() + ",");
                            paraHintDesc.append("参数类型 " + paraList.get(i).getType());
                        }
                    }
                }
                // 参数描述列表
                paramDescList.add(paraHintDesc.toString());

                // 返回值描述列表
                StringBuilder returnValueStringBuilder = new StringBuilder();
                returnValueStringBuilder.append(exp.getReturnValueType());
                returnValueStringBuilder.append(StringUtils.isNotEmpty(exp.getReturnValueType()) ? " " : "");
                returnValueStringBuilder
                        .append(StringUtils.isNotEmpty(exp.getReturnValueDesc()) ? exp.getReturnValueDesc() : "");
                returnValueDescList.add(returnValueStringBuilder.toString());
            }
        }
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new ExpAutoCompleteCmd();
    }
}
