package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.design.vo.RecycleForm;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaProcess;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateProfile;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateSubList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.report.MetaReportList;
import com.bokesoft.yigo.meta.report.MetaReportProfile;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

import static com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil.getOutputFormat;

/**
 * 删除XML文件
 */
public class DeleteXmlFileCmd extends DesignerServiceCmd {

    public static final String CMD = "DeleteXmlFile";

    public static String objectType = "";
    private StringHashMap<Object> arguments;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.arguments = new StringHashMap<>();
        this.arguments.putAll(arguments);
    }

    // TODO 为什么要深度复制？
    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        RecycleForm recycleForm = this.getRecycleForm();
        if(recycleForm == null) {
            List<UICommand> result = new ArrayList<>();
            result.add(UICommand.showTip("提示: 该表单未保存或不存在，无法删除！"));
            return UICommand.toJson(result);
        }
        objectType = recycleForm.getType();

        if (StringUtils.equals(objectType, MetaForm.TAG_NAME)) {
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            MetaFormProfile metaFormProfile = metaFormList.get(recycleForm.getKey());
            if(metaFormProfile == null) metaFormProfile = metaFactory.getExtFormList().get(recycleForm.getKey());
            for (MetaFormProfile metaForm : metaFormList) {
                if (StringUtils.equalsIgnoreCase(metaForm.getExtend(), recycleForm.getKey())) {
                    List<UICommand> result = new ArrayList<>();
                    result.add(UICommand.showTip("提示:该表单存在马甲不允许删除!!!"));
                    return UICommand.toJson(result);
                }
            }

            MetaFormProfile metaForm = MetaObjectHelper.deptClone(metaFormProfile);
            metaForm.setProject(metaFormProfile.getProject());
            metaForm.getForm().setProject(metaFormProfile.getProject());
            recycleForm.setForm(metaForm);
            metaFormList.remove(recycleForm.getKey());
            metaFactory.getExtFormList().remove(recycleForm.getKey());

            if (metaFormProfile.getForm().getDataSource() != null && StringUtils.isEmpty(metaFormProfile.getForm().getDataSource().getRefObjectKey())) {
                MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
                if(dataObjectList != null)dataObjectList.remove(recycleForm.getKey());
            }
            //删除菜单节点
            boolean isDelete = deleteForm(metaFactory, recycleForm.getKey());

            String extend = metaFormProfile.getExtend();
            final Boolean mergeToSource = metaFormProfile.getMergeToSource();
            if (StringUtils.isNotEmpty(extend) && Objects.equals(mergeToSource, Boolean.TRUE)) {//马甲的删除后处理
                DesignReloadMetaObject.reloadMetaFormRollbackError(extend);
            }

            this.recycleXmlFile(recycleForm);

            final List<UICommand> result = this.buildUICommandList(recycleForm);
            if (isDelete) {
                result.add(UICommand.reloadMenuTree());
            }
            DesignReloadMetaObject.oldFormHashMap.remove(recycleForm.getKey());
            return UICommand.toJson(result);
        }
        if (StringUtils.equalsIgnoreCase(objectType, MetaDataObject.TAG_NAME)) {
            String xmlFileKey = recycleForm.getKey();
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
            MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(xmlFileKey);
            final String extend = metaDataObjectProfile.getExtend();

            final MetaDataObject dataObject = metaDataObjectProfile.getDataObject();
            if (StringUtils.isNotBlank(dataObject.getMergeToSourceMapKey()) && StringUtils.isBlank(dataObject.getExtend())) {
                List<UICommand> result = new ArrayList<>();
                result.add(UICommand.showTip("提示:该数据对象存在马甲不允许删除!!!"));
                return UICommand.toJson(result);
            }

            MetaFormList metaFormList = metaFactory.getMetaFormList();
            for (MetaFormProfile metaFormProfile : metaFormList) {
                MetaForm metaForm = metaFormProfile.getForm();
                if (Objects.nonNull(metaForm) && Objects.nonNull(metaForm.getDataSource())) {
                    String refObjectKey = metaForm.getDataSource().getRefObjectKey();
                    if (StringUtils.isBlank(refObjectKey)) {
                        continue;
                    }
                    if (StringUtils.equals(refObjectKey, xmlFileKey)) {
                        List<UICommand> result = new ArrayList<>();
                        result.add(UICommand.showTip("warning: 该数据对象已在表单：" + metaForm.getKey() + "使用，不允许删除!!!"));
                        return UICommand.toJson(result);
                    }
                }
            }

            dataObjectList.remove(xmlFileKey);
            if (StringUtils.isNotBlank(extend)) {
                String resource = LoadFileTree.getPathByDataObject(extend);
                DataObjectHelper.reload(null,extend, resource, null);
            }

            recycleForm.setForm(MetaObjectHelper.deptClone(metaDataObjectProfile));

            this.recycleXmlFile(recycleForm);

            final List<UICommand> result = this.buildUICommandList(recycleForm);
            return UICommand.toJson(result);
        }
        if (StringUtils.equalsIgnoreCase(objectType, MetaMap.TAG_NAME)) {
            String xmlFileKey = recycleForm.getKey();
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            ERPMetaMap metaCustomObject = metaFactory.getMetaCustomObject(ERPMetaMap.class, xmlFileKey);
            List<KeyPairMetaObject> customList = metaFactory.getCustomList();
            customList.remove(metaCustomObject);
            recycleForm.setForm(MetaObjectHelper.clone(metaCustomObject));

            this.recycleXmlFile(recycleForm);

            final List<UICommand> result = this.buildUICommandList(recycleForm);
            return UICommand.toJson(result);
        }
        if (StringUtils.equalsIgnoreCase(objectType, MetaDataMigration.TAG_NAME)) {
            String xmlFileKey = recycleForm.getKey();

            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaDataMigrationList dataMigrationList = metaFactory.getDataMigrationList();
            MetaDataMigrationProfile metaDataMigrationProfile = dataMigrationList.get(xmlFileKey);
            AbstractMetaObject metaObject = MetaObjectHelper.deptClone(metaDataMigrationProfile);
            dataMigrationList.remove(xmlFileKey);
            recycleForm.setForm(metaObject);

            this.recycleXmlFile(recycleForm);

            final List<UICommand> result = this.buildUICommandList(recycleForm);
            return UICommand.toJson(result);
        }
        if (StringUtils.equalsIgnoreCase(objectType, MetaProcess.TAG_NAME)) {
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaBPM metaBPM = metaFactory.getMetaBPM();
            recycleForm.setForm(metaBPM);

            this.recycleXmlFile(recycleForm);
            metaFactory.reloadMetaBPM();

            final List<UICommand> result = this.buildUICommandList(recycleForm);
            return UICommand.toJson(result);
        }
        if (StringUtils.equalsIgnoreCase(objectType, MetaReport.TAG_NAME)) {
            final String formKey = recycleForm.getSubKey();
            String xmlFileKey = recycleForm.getKey();
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaReportList metaReportList = metaFactory.getMetaReportList();

            MetaReportSubList metaReportSubList = metaReportList.get(formKey);
            if (Objects.nonNull(metaReportSubList)) {
                final MetaReportProfile metaReportProfile = metaReportSubList.get(xmlFileKey);
                if (Objects.nonNull(metaReportProfile)) {
                    metaReportSubList.remove(xmlFileKey);
                    recycleForm.setForm(MetaObjectHelper.deptClone(metaReportProfile));
                }
            }

            this.recycleXmlFile(recycleForm);

            final List<UICommand> result = this.buildUICommandList(recycleForm);
            return UICommand.toJson(result);
        }
        if (StringUtils.equalsIgnoreCase(objectType, MetaExcelWorkbook.TAG_NAME)) {
            String xmlFileKey = recycleForm.getKey();
            final String projectKey = recycleForm.getProjectKey();
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            final MetaExcelTemplateList metaExcelTemplateList = metaFactory.getMetaExcelTemplateList();
            MetaExcelTemplateSubList metaExcelTemplateSubList = metaExcelTemplateList.get(projectKey);
            if (Objects.nonNull(metaExcelTemplateSubList)) {
                final MetaExcelTemplateProfile metaExcelTemplateProfile = metaExcelTemplateSubList.get(xmlFileKey);
                if (Objects.nonNull(metaExcelTemplateProfile)) {
                    metaExcelTemplateSubList.remove(xmlFileKey);
                    recycleForm.setForm(MetaObjectHelper.deptClone(metaExcelTemplateProfile));
                }
            }

            this.recycleXmlFile(recycleForm);

            final List<UICommand> result = this.buildUICommandList(recycleForm);
            return UICommand.toJson(result);
        }

        List<UICommand> result = new ArrayList<>();
        result.add(UICommand.showTip("提示:此文件不能删除!!!"));
        return UICommand.toJson(result);
    }

    /**
     * 删除菜单节点
     *
     * @param iMetaFactory
     * @param key
     * @throws Throwable
     */
    private boolean deleteForm(IMetaFactory iMetaFactory, String key) throws Throwable {
        LinkedHashMap<String, String> allItems = getAllItems();
        AtomicBoolean isRemove = new AtomicBoolean(false);
        // 创建SAX读取器
        SAXReader reader = new SAXReader();
        OutputFormat format = getOutputFormat();
        
        for (Map.Entry<String, String> entry : allItems.entrySet()) {
        	String keya = entry.getKey();
        	String formKey = entry.getValue();
        	
        	if (formKey.equals(key) || formKey.startsWith("FormKey=" + key)) {
        		int fistIndex = keya.indexOf("/");
            	String projectKey = keya.substring(0, fistIndex);
            	
            	String entryPath = iMetaFactory.getProjectResolver(projectKey).getPath("") + "Entry.xml";
            	Document document = reader.read(new File(entryPath));
            	FileOutputStream fileOutputStream = new FileOutputStream(entryPath);
                XMLWriter writer = new XMLWriter(fileOutputStream, format);
                
                keya = keya.substring(fistIndex);
            	
                String substring = keya.substring(1);
                int endIndex = substring.lastIndexOf("/");
                             
                Element nodes = (Element) document.getRootElement().selectSingleNode(substring.substring(0, endIndex));
                Element node = (Element) document.getRootElement().selectSingleNode(substring);
                if (Objects.isNull(nodes)) {
                    nodes = document.getRootElement();
                }
                if (nodes != null) {
                    isRemove.set(nodes.remove(node));
                }
                
                writer.write(document);
                
                EntryProcessor.instance.reloadEntry(projectKey);
        	}	
        }
            
        
        return isRemove.get();
    }

    /**
     * /**
     * 取所有目录节点
     */
    public LinkedHashMap<String, String> getAllItems() throws Throwable {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<>();
        // MetaEntry metaEntry = MetaFactory.getGlobalInstance().getMetaEntry("config");
        
        MetaEntry metaEntry = MetaFactory.getGlobalInstance().getEntryList("");

        for (int i = 0; i < metaEntry.size(); i++) {
            AbstractCompositeObject abstractCompositeObject = metaEntry.get(i);
            if (abstractCompositeObject instanceof MetaEntry) {
            	MetaEntry entry = (MetaEntry) abstractCompositeObject;
                findItems(linkedHashMap, entry, entry.getProject());
            } else {
                MetaEntryItem entryItem = (MetaEntryItem) metaEntry.get(i);
                
                String pEntryKeys = entryItem.getProject() + "/EntryItem[@FormKey='" + entryItem.getFormKey() + "']";
                String value = entryItem.getFormKey();
                if (StringUtils.isNotEmpty(entryItem.getParameters())) {//"字典"
                    value = entryItem.getParameters();
                    pEntryKeys = entryItem.getProject() + "/EntryItem[@FormKey='" + entryItem.getFormKey() + "']" + "[@Key='" + entryItem.getKey() + "']";
                }
                linkedHashMap.put(pEntryKeys, value);
            }
        }
        return linkedHashMap;
    }

    private void findItems(LinkedHashMap<String, String> linkedHashMap, MetaEntry metaEntry,
                           String pEntryKey) throws Throwable {
        String pEntryKeys = pEntryKey + "/Entry[@Key='" + metaEntry.getKey() + "']";
        if (metaEntry.size() != 0) {
            for (int j = 0; j < metaEntry.size(); j++) {
                if (metaEntry.get(j) instanceof MetaEntry) {
                    linkedHashMap.put(pEntryKeys, metaEntry.getKey());
                    findItems(linkedHashMap, (MetaEntry) metaEntry.get(j), pEntryKeys);
                } else {
                    MetaEntryItem entryItem = (MetaEntryItem) metaEntry.get(j);
                    String pEntryKeys1 = pEntryKeys + "/EntryItem[@FormKey='" + entryItem.getFormKey() + "']";
                    String value = entryItem.getFormKey();
                    if (StringUtils.isNotEmpty(entryItem.getParameters())) {//"字典"
                        pEntryKeys1 =
                                pEntryKeys + "/EntryItem[@FormKey='" + entryItem.getFormKey() + "']" + "[@Key='" + entryItem.getKey() + "']";
                        value = entryItem.getParameters();
                    }
                    linkedHashMap.put(pEntryKeys1, value);
                }
            }
        }
    }

    private RecycleForm getRecycleForm() throws Throwable {
        String filePath = FilePathHelper.toBackFilePath((String) arguments.get("filePath"));
        File file = new File(filePath);
        if(!file.exists()) return null;
        String content = FileUtils.readFileToString(new File(filePath), StandardCharsets.UTF_8);
        String secondLine = DesignIOMetaUtil.getSecondLine(content);

        String key = DesignIOMetaUtil.getSubString(secondLine, " Key=\"([A-Za-z_]\\w*)\"");
        String caption = DesignIOMetaUtil.getSubString(secondLine, "Caption=\"([\u4e00-\u9fa5_a-zA-Z0-9]*)\"");
        String objectType = DesignIOMetaUtil.getSubString(secondLine, "<([A-Za-z_]\\w*)\\s");

        String tmpFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", key + ".xml").toString();
        String projectKey = LoadFileTree.getProjectKey(filePath);

        RecycleForm recycleForm = new RecycleForm();
        recycleForm.setKey(key);
        recycleForm.setCaption(caption);
        recycleForm.setType(objectType);
        recycleForm.setFilePath(filePath);
        recycleForm.setTmpFilePath(tmpFilePath);
        // recycleForm.setForm(metaObject);
        recycleForm.setContent(content);
        recycleForm.setProjectKey(projectKey);

        try {
            String subKey = DesignIOMetaUtil.getSubString(secondLine, "FormKey=\"([A-Za-z_]\\w*)\"");
            recycleForm.setSubKey(subKey);
        } catch (Exception e) {

        }

        return recycleForm;
    }

    private void recycleXmlFile(RecycleForm recycleForm) throws Throwable {
        String xmlFileKey = recycleForm.getKey();
        String xmlFilePath = recycleForm.getFilePath();
        String xmlFileContent = recycleForm.getContent();
        String tmpFilePath = recycleForm.getTmpFilePath();

        FileUtils.writeStringToFile(new File(tmpFilePath), xmlFileContent, "UTF-8");
        XmlFileProcessor.instance.clearTmpFile(xmlFilePath);
        LoadFileTree.removeFilePath(xmlFilePath, recycleForm);
        XmlFileProcessor.instance.saveTempRecycleFile(objectType + "@" + xmlFileKey, recycleForm);
        FileUtils.forceDelete(new File(xmlFilePath));
    }

    private List<UICommand> buildUICommandList(RecycleForm recycleForm) {
        String xmlFileKey = recycleForm.getKey();
        String xmlFilePath = recycleForm.getFilePath();

        List<UICommand> result = new ArrayList<>();
        result.add(UICommand.reloadFileTree(xmlFilePath));
        result.add(UICommand.closeFormKey(xmlFileKey));
        result.add(UICommand.closeFilePath(xmlFilePath));
        return result;
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new DeleteXmlFileCmd();
    }
}
