package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.XmlFormat;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.util.FileUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.bar.MetaToolBar;
import com.bokesoft.yigo.meta.form.component.chart.MetaChart;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.*;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.panel.*;
import com.bokesoft.yigo.meta.form.component.panel.flexgridpanel.MetaFlexGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

public class CheckKeyLengthCmd extends DesignerServiceCmd {
    public static final String CMD = "CheckKeyLength";
    /**
     * 是否源代码界面点的保存
     */
    private boolean isSourceActive;

    /**
     * 文件内容
     */
    private String content;

    /**
     * 当前界面的FormKey
     */
    private String uiFormKey;

    /**
     * 入口参数中的FormKey
     */
    private String entryParas;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.isSourceActive = Boolean.parseBoolean((String) arguments.get("isSourceActive"));
        if (this.isSourceActive){
            this.content = (String) arguments.get("content");
        }else {
            this.uiFormKey = (String) arguments.get("uiFormKey");
            this.entryParas = (String) arguments.get("entryParas");
        }
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        List<UICommand> result = new ArrayList<>();
        String failedInfo;
        if (this.isSourceActive){
            failedInfo = this.CheckLengthByContent(content);
            if (StringUtils.isNotEmpty(failedInfo)){
                result.add(UICommand.showError("当前源代码文件存在Key长度校验不通过: " + failedInfo));
            }
        }else {
            List<String[]> filePaths = LoadFileTree.loadFilePathsByFormKey(context, uiFormKey, entryParas, null);
            String filePath;
            String tmpFilePath;
            String tmpContent;
            String tmpSecondLine;
            String key;
            for (String[] tmp : filePaths) {
                filePath = tmp[0];
                tmpFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
                if (StringUtils.isEmpty(tmpFilePath)) {
                    continue;
                }
                tmpContent = FileUtil.File2String(tmpFilePath, "UTF-8");
                tmpSecondLine = DesignIOMetaUtil.getSecondLine(tmpContent);
                key = DesignIOMetaUtil.getSubString(tmpSecondLine, "Key=\"([A-Za-z_]\\w*)\"");
                failedInfo = this.CheckLengthByContent(tmpContent);
                if (StringUtils.isNotEmpty(failedInfo)){
                    failedInfo = "当前表单中存在Key长度校验不通过,位于" + key + ".xml中: " + failedInfo;
                    result.add(UICommand.showError(failedInfo));
                    break;
                }
            }
        }
        return UICommand.toJson(result);
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new CheckKeyLengthCmd();
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    private String CheckLengthByContent(String content) throws Throwable{
        String failedInfo = "";
        XmlTree xmlTree;
        try {
            String xmlFile = XmlFormat.formatXML_str(content);
            xmlTree = XmlParser.parse(xmlFile);
        } catch (Exception e) {
            return "xml结构错误!";
        }
        HashMap<String, AbstractNode> mapNodes = xmlTree.getMapNodes();

        TagNode tag;
        String tagName;
        String tagKey;
        int tagKeyLength;
        boolean isPersist;
        Map<String, String> tagAttributes;
        for (Map.Entry<String, AbstractNode> node : mapNodes.entrySet()) {
            tag = (TagNode) node.getValue();
            tagName = tag.getTagName();
            tagAttributes = tag.getAttributes();
            tagKey = tagAttributes.getOrDefault("Key","");
            tagKeyLength = tagKey.length();
            if (StringUtils.isEmpty(tagKey)){
                continue;
            }
            if (MetaForm.TAG_NAME.equals(tagName) && tagKeyLength > 50){
                failedInfo ="表单Key长度不能超过50,当前表单Key: " + tagKey + " 长度: " + tagKeyLength;
                break;
            }else if (isPanel(tagName) && tagKeyLength > 100){
                failedInfo ="面板与表格Key长度不能超过100,当前Key: " + tagKey + " 长度: " + tagKeyLength;
                break;
            }else if (isControl(tagName) && tagKeyLength > 50){
                failedInfo ="控件Key长度不能超过50,当前控件Key: " + tagKey + " 长度: " + tagKeyLength;
                break;
            }else if (MetaTable.TAG_NAME.equals(tagName)){
                isPersist = Boolean.parseBoolean(tagAttributes.getOrDefault("Persist","true"));
                if (isPersist && tagKeyLength > 30){
                    failedInfo ="持久化表Key长度不能超过30,当前表Key: " + tagKey + " 长度: " + tagKeyLength;
                    break;
                }else if (!isPersist && tagKeyLength > 50){
                    failedInfo ="非持久化表Key长度不能超过50,当前表Key: " + tagKey + " 长度: " + tagKeyLength;
                    break;
                }
            }else if (MetaColumn.TAG_NAME.equals(tagName) && tagKeyLength > 30){
                String persistParent = tag.getParent().getAttributes().get("Persist");
                String persist = tag.getAttributes().get("Persist");
                boolean equalsParent = "false".equals(persistParent);
                boolean equals = "false".equals(persist);
                if (!equals && !equalsParent){
                    failedInfo ="ColumnKey长度不能超过50,当前ColumnKey: " + tagKey + " 长度: " + tagKeyLength;

                }
                break;
            }else if (StringUtils.isEmpty(tagAttributes.get("RefObjectKey")) && MetaDataObject.TAG_NAME.equals(tagName) && tagKeyLength > 50){
                failedInfo ="数据对象Key长度不能超过50,当前数据对象Key: " + tagKey + " 长度: " + tagKeyLength;
                break;
            }

        }
        return failedInfo;
    }

    private boolean isControl(String tagName){
        List<String> controls = Arrays.asList(MetaDict.TAG_NAME, MetaNumberEditor.TAG_NAME, MetaTextEditor.TAG_NAME,
                MetaTextEditor.TAG_NAME, MetaComboBox.TAG_NAME, MetaDatePicker.TAG_NAME, MetaUTCDatePicker.TAG_NAME,
                MetaCheckBox.TAG_NAME, MetaTextArea.TAG_NAME, MetaTextButton.TAG_NAME, MetaLabel.TAG_NAME, MetaCheckListBox.TAG_NAME,
                MetaDynamicDict.TAG_NAME, MetaRichEditor.TAG_NAME, MetaTimePicker.TAG_NAME, MetaMonthPicker.TAG_NAME,
                MetaPasswordEditor.TAG_NAME, MetaSeparator.TAG_NAME, MetaImage.TAG_NAME, MetaHyperLink.TAG_NAME,
                MetaDropdownButton.TAG_NAME, MetaEmbed.TAG_NAME, MetaToolBar.TAG_NAME, MetaChart.TAG_NAME);
        return controls.contains(tagName);
    }

    private boolean isPanel(String tagName){
        List<String> panels = Arrays.asList(MetaFlexFlowLayoutPanel.TAG_NAME, MetaSplitPanel.TAG_NAME, MetaTabPanel.TAG_NAME,
                MetaGridLayoutPanel.TAG_NAME, MetaFlowLayoutPanel.TAG_NAME, MetaColumnLayoutPanel.TAG_NAME,
                MetaFlexGridLayoutPanel.TAG_NAME, MetaGrid.TAG_NAME, MetaSubDetail.TAG_NAME);
        return panels.contains(tagName);
    }
}
