package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckKeyAndFileNameCmd extends DesignerServiceCmd {
    public static final String CMD = "CheckKeyAndFileName";
    public static final CheckKeyAndFileNameCmd instance = new CheckKeyAndFileNameCmd();

    private String filePath;
    private String content;

    @Override
    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> arguments) throws Throwable {
        filePath = FilePathHelper.toBackFilePath((String) arguments.get("filePath"));
        content = (String) arguments.get("content");
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        final Pair<String, String> pair = this.getFormKeyAndFileName();
        // 1. 表单标识与文件名一致
        if (StringUtils.equals(pair.getLeft(), pair.getRight())) {
            return UICommand.toJson(Collections.emptyList());
        }
        // 2. 表单标识与文件名不一致
        final List<UICommand> resultList = Collections.singletonList(UICommand.showError("表单标识与文件名必须一致"));
        return UICommand.toJson(resultList);
    }

    private Pair<String, String> getFormKeyAndFileName() {
        String secondLine = DesignIOMetaUtil.getSecondLine(content);
        String formKey = getSubString(secondLine, "Key=\"([A-Za-z_]\\w*)\"");
        if (StringUtils.isBlank(formKey)) {
            // CommonDef 没有 formKey
            return Pair.of("", "");
        }
        String tagName = DesignIOMetaUtil.getSubString(secondLine, "<([A-Za-z_]\\w*)");
        if (StringUtils.equals(tagName, MetaEntry.TAG_NAME)) {
            return Pair.of("", "");
        }
        File file = new File(filePath);
        String fileName = file.getName().split(".xml")[0];
        return Pair.of(formKey, fileName);
    }

    /**
     * 根据正则表达式取字符串中的值
     *
     * @param s       <OperationCollection>
     * @param pattern <([A-Za-z_]\w*)\s
     * @return
     */
    public static String getSubString(String s, String pattern) {
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new CheckKeyAndFileNameCmd();
    }

    @Override
    public String getCmd() {
        return CMD;
    }
}