package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.auth.cache.SessionInfo;
import com.bokesoft.yes.mid.auth.cache.simple.MobileSessionInfoProvider;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.ISessionInfoMap;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;

public class AppDesignLoginCmd extends DefaultServiceCmd {
    public static final String CMD = "AppDesignLogin";

    @Override
    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> stringHashMap) throws Throwable {
    }

    @Override
    public Object doCmd(DefaultContext defaultContext) throws Throwable {
        String curClientID = defaultContext.getEnv().getClientID();
        ISessionInfoProvider pcProvider = SessionInfoProviderHolder.getProvider(1);
        ISessionInfo pcSessionInfo = pcProvider.getSessionInfoMap().get(curClientID);
        ISessionInfoProvider provider = SessionInfoProviderHolder.getProvider(2);
        if (provider == null) {
            provider = new MobileSessionInfoProvider();
            SessionInfoProviderHolder.setMobileInstance(provider);
        }
        ISessionInfoMap sessionInfoMap = provider.getSessionInfoMap();
        SessionInfo mobileSessionInfo = (SessionInfo)pcSessionInfo.clone();
        mobileSessionInfo.setMode(2);
        sessionInfoMap.put(curClientID, pcSessionInfo);
        return true;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new AppDesignLoginCmd();
    }

    @Override
    public String getCmd() {
        return CMD;
    }
}
