package com.bokesoft.yes.design.bpm.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.vo.JsonQuestVo;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yigo.common.def.DataObjectSecondaryType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.bpm.total.ProcessMapType;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.apache.commons.collections.CollectionUtils;

import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

/***
 * 获取数据工具类
 * @date 2020-09-25
 * @author zhsy
 */
public class GetDataUtil {
	private static final Logger logger = Logger.getLogger(GetDataUtil.class.getName());
	//判断撤销操作是不是第一次，因为staock里面保存的是实时数据，
	// 第一次应该取倒数第二条，所以通过此标识做一个删除操作
	private boolean isFrist = true;
	public static final GetDataUtil instance = new GetDataUtil();

	/***
	 * 获取当前文件的所有节点元素
	 * @param jsonQuestVo 前端传过来的数据对象
	 * @return 结果对象
	 */
	public ResponseResult<JSONArray> getAllNodes(JsonQuestVo jsonQuestVo) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		try {
			// 根据路径获取根元素
			Element root = getRootElementByFilePath(jsonQuestVo.getFilePath());

			List<Element> elements = root.elements();
			if (CollectionUtils.isEmpty(elements)) {
				result.setCode(1);
				result.setMsg("当前工作流文件中没有节点");
				return result;
			}

			JSONObject nodeJsonObj;
			JSONArray nodesJsonArray = new JSONArray();
			for (Element ele : elements) {
				if (null != ele.attributeValue(ConstantUtil.KEY)) {
					nodeJsonObj = new JSONObject();
					nodeJsonObj.put("name", ele.attributeValue(ConstantUtil.CAPTION));
					nodeJsonObj.put("value", ele.attributeValue(ConstantUtil.KEY));
					nodesJsonArray.add(nodeJsonObj);
				}
			}

			result.setCode(0);
			result.setMsg("获取当前文件的所有节点元素成功");
			result.setData(nodesJsonArray);
		} catch (Exception e) {
			logger.warning("获取当前文件的所有节点元素异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取当前文件的所有节点元素失败，失败消息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return result;
	}

	/***
	 * 获取所有的流程标识
	 * @return 流程标识结果
	 */
	public ResponseResult<JSONArray> getInline() {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		try {
			// 根据路径获取根元素
			MetaBPM metaBPM = MetaFactory.getGlobalInstance().getMetaBPM();
			HashMap<String, ProcessDefinitionProfile> profileMap = metaBPM.getProfileMap();

			JSONObject nodeJsonObj;
			JSONArray nodesJsonArray = new JSONArray();
			for (Map.Entry<String, ProcessDefinitionProfile> ele : profileMap.entrySet()) {
				if (null != ele.getKey()) {
					nodeJsonObj = new JSONObject();
					nodeJsonObj.put("name", ele.getValue().getCaption());
					nodeJsonObj.put("value", ele.getValue().getKey());
					nodesJsonArray.add(nodeJsonObj);
				}
			}
			result.setCode(0);
			result.setMsg("获取所有的流程标识成功");
			result.setData(nodesJsonArray);
		} catch (Throwable e) {
			logger.warning("获取所有的流程标识异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取所有的流程标识失败，失败消息为:" + e.getMessage());
		}
		return result;
	}

	/***
	 * 获取状态集合
	 * @param jsonQuestVo 条件对象
	 * @return 状态集合结果
	 */
	public ResponseResult<JSONArray> getStatusList(JsonQuestVo jsonQuestVo) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		try {
			// 根据路径获取根元素
			String filePath = jsonQuestVo.getFilePath();
			String[] split;
			String os = System.getProperty("os.name");
			if (os.toLowerCase().startsWith("win")) {
				split = filePath.split("\\\\");
			} else {
				split = filePath.split("/");
			}
			MetaStatusCollection statusCollection;
			MetaSolution solution = MetaFactory.getGlobalInstance().getSolution();
			MetaProjectCollection projectCollection = solution.getProjectCollection();
			MetaCommonDef basisconfig = Optional.ofNullable(projectCollection.get(split[split.length-3])).map(project -> project.getProject().getCommonDef()).orElse(null);
			statusCollection = basisconfig != null ? basisconfig.getStatusCollection() : null;
			//当前工程下状态集合为null时，使用总工程下的状态集合
			if (null == statusCollection || statusCollection.size() == 0) {
				statusCollection = MetaFactory.getGlobalInstance().getCommonDef("").getStatusCollection();
			}
			JSONObject nodeJsonObj;
			JSONArray nodesJsonArray = new JSONArray();
			for (int i = 0; i < statusCollection.size(); i++) {
				if (null != statusCollection.get(i).getKey()) {
					nodeJsonObj = new JSONObject();
					nodeJsonObj.put("name", statusCollection.get(i).getKey()
							+ "," + statusCollection.get(i).getCaption());
					nodeJsonObj.put("value", statusCollection.get(i).getKey());
					nodesJsonArray.add(nodeJsonObj);
				}
			}
			result.setCode(0);
			result.setMsg("获取状态集合成功");
			result.setData(nodesJsonArray);
		} catch (Throwable e) {
			logger.warning("获取状态集合异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取状态集合失败，失败消息为:" + e.getMessage());
		}
		return result;
	}

	/***
	 * 获取绑定标识列表数据
	 * @param jsonQuestVo 前端传过来的数据对象
	 * @return 结果对象
	 */
	public ResponseResult<JSONObject> getBpmBindingKeyList(JsonQuestVo jsonQuestVo) {
		ResponseResult<JSONObject> result = new ResponseResult<>();
		try {
			// 项目标识
			String projectKey = getProjectKeyByFilePath(jsonQuestVo.getFilePath());
			JSONObject nodeJsonObj;
			// 表单数组
			JSONArray formJsonArray = new JSONArray();
			// 数据对象数组
			JSONArray dataObjectJsonArray = new JSONArray();
			IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
			// 表单列表
			MetaFormList metaFormList = metaFactory.getMetaFormList();
			if (null != metaFormList && !metaFormList.isEmpty()) {
				for (int i = 0; i < metaFormList.size(); i++) {
					nodeJsonObj = new JSONObject();
					MetaFormProfile metaFormProfile = metaFormList.get(i);
					if (null == metaFormProfile) {
						continue;
					}
					// 不是当前项目就跳过
					/*if (null == metaFormProfile.getProject() ||
							!projectKey.equals(metaFormProfile.getProject().getKey())) {
						continue;
					}*/
					String formKey = metaFormProfile.getKey();
					String formCaption = metaFormProfile.getCaption();
					// 有主表就放入列表，否则跳过
					if (hasMainTable(formKey, ProcessMapType.Form)) {
						nodeJsonObj.put("name", formKey + " " + formCaption);
						nodeJsonObj.put("value", formKey);
						formJsonArray.add(nodeJsonObj);
					}
				}
				// 升序排列
				formJsonArray.sort(Comparator.comparing(obj -> {
					String key = ((JSONObject) obj).getString("value");
					return key;
				}));
			}

			// 数据对象列表
			MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
			if (null != dataObjectList && !dataObjectList.isEmpty()) {
				for (int i = 0; i < dataObjectList.size(); i++) {
					nodeJsonObj = new JSONObject();
					MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(i);
					if (null == metaDataObjectProfile) {
						continue;
					}
					// 不是当前项目就跳过
					if (null == metaDataObjectProfile.getProject() ||
							!projectKey.equals(metaDataObjectProfile.getProject().getKey())) {
						continue;
					}
					String dataObjeectKey = metaDataObjectProfile.getKey();
					String dataObjeectCaption = metaDataObjectProfile.getCaption();
					int secondType = metaDataObjectProfile.getSecondaryType();
					// 有主表就放入列表，否则跳过
					if (hasMainTable(dataObjeectKey, ProcessMapType.DataObject)
							&& secondType == DataObjectSecondaryType.NORMAL) {
						nodeJsonObj.put("name", dataObjeectKey + " " + dataObjeectCaption);
						nodeJsonObj.put("value", dataObjeectKey);
						dataObjectJsonArray.add(nodeJsonObj);
					}
				}
				// 升序排列
				dataObjectJsonArray.sort(Comparator.comparing(obj -> {
					String key = ((JSONObject) obj).getString("value");
					return key;
				}));
			}

			result.setCode(0);
			result.setMsg("获取绑定标识列表成功");
			JSONObject data = new JSONObject();
			data.put("formKeyList", formJsonArray);
			data.put("dataObjectKeyList", dataObjectJsonArray);
			result.setData(data);
		} catch (Throwable e) {
			logger.warning("获取流程标识列表异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取流程标识列表失败，失败消息为:" + e.getMessage());
		}
		return result;
	}

	/***
	 * 获取流所有表单列表
	 * @return 结果对象
	 */
	public ResponseResult<JSONArray> getAllFormKeyList() {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		try {
			JSONObject nodeJsonObj;
			// 表单数组
			JSONArray formJsonArray = new JSONArray();
			nodeJsonObj = new JSONObject();
			nodeJsonObj.put("name", "无");
			nodeJsonObj.put("value", "");
			formJsonArray.add(nodeJsonObj);
			IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
			// 表单列表
			MetaFormList metaFormList = metaFactory.getMetaFormList();
			if (null != metaFormList && !metaFormList.isEmpty()) {
				for (int i = 0; i < metaFormList.size(); i++) {
					nodeJsonObj = new JSONObject();
					MetaFormProfile metaFormProfile = metaFormList.get(i);
					if (null == metaFormProfile) {
						continue;
					}
					String formKey = metaFormProfile.getKey();
					String formCaption = metaFormProfile.getCaption();
					nodeJsonObj.put("name", formKey + " " + formCaption);
					nodeJsonObj.put("value", formKey);
					formJsonArray.add(nodeJsonObj);
				}
			}
			// 数据对象列表
			MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
			if (null != dataObjectList && !dataObjectList.isEmpty()) {
				for (int i = 0; i < dataObjectList.size(); i++) {
					nodeJsonObj = new JSONObject();
					MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(i);
					if (null == metaDataObjectProfile) {
						continue;
					}
					String formKey = metaDataObjectProfile.getKey();
					String formCaption = metaDataObjectProfile.getCaption();
					nodeJsonObj.put("name", formKey + " " + formCaption);
					nodeJsonObj.put("value", formKey);
					formJsonArray.add(nodeJsonObj);
				}
			}

			JSONArray newJsonArray = new JSONArray();
			if (!CollectionUtils.isEmpty(formJsonArray)) {
				// 去重
				Set<Object> sets = formJsonArray.stream().collect(Collectors.toSet());
				sets.forEach(q -> newJsonArray.add(q));
				// 升序排列
				newJsonArray.sort(Comparator.comparing(obj -> {
					String key = ((JSONObject) obj).getString("value");
					return key;
				}));
			}

			result.setCode(0);
			result.setMsg("获取流所有表单列表成功");
			result.setData(newJsonArray);
		} catch (Throwable e) {
			logger.warning("获取流所有表单列表异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取流所有表单列表失败，失败消息为:" + e.getMessage());
		}
		return result;
	}

	/***
	 * 获取流程标识列表数据
	 * @param jsonQuestVo 前端传过来的数据对象
	 * @return 结果对象
	 */
	public ResponseResult<JSONArray> getProcessKeyList(JsonQuestVo jsonQuestVo) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		try {
			//流程标识不创建临时文件
           /* //获取临时文件路径
            String tempPath = XmlFileProcessor.instance.getTmpFile(jsonQuestVo.getFilePath());
            //当temppath为空时就去创建一个
            tempPath = DataMapOperXmlUtil.getTempPath(tempPath, jsonQuestVo.getFilePath());
            // 根据临时文件路径获取根元素*/
			Element root = getRootElementByFilePath(jsonQuestVo.getFilePath(), true);

			List<Element> elements = root.elements();
			if (CollectionUtils.isEmpty(elements) || null == root.element("DeployInfoCollection")
					|| null == root.element("DeployInfoCollection").elements("DeployInfo")) {
				result.setCode(1);
				result.setMsg("当前文件中没有发布的流程");
				return result;
			}

			List<Element> deployInfoList = root.element("DeployInfoCollection").elements("DeployInfo");
			JSONObject nodeJsonObj;
			JSONArray nodesJsonArray = new JSONArray();
			for (Element ele : deployInfoList) {
				if (null != ele.attributeValue(ConstantUtil.KEY)) {
					nodeJsonObj = new JSONObject();
					nodeJsonObj.put("name", ele.attributeValue(ConstantUtil.KEY));
					nodeJsonObj.put("value", ele.attributeValue(ConstantUtil.KEY));
					nodesJsonArray.add(nodeJsonObj);
				}
			}

			result.setCode(0);
			result.setMsg("获取流程标识列表成功");
			result.setData(nodesJsonArray);
		} catch (Exception e) {
			logger.warning("获取流程标识列表异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取流程标识列表失败，失败消息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return result;
	}

	/***
	 * 根据Key获取权限列表
	 * @param key 标识
	 * @return 权限数据，数据结构为:
	 * {operPermArray:[{Key:'',Caption:'',OptSelect:false}],
	 *  compPermArray:[{Key:'',Caption:'',VisibleSelect:true,EnableSelect:false}],
	 *  gridPermArray:[{GridName:'',GridDataArray:[{Key:'',Caption:'',EnableSelect:false}]}]
	 * }
	 */
	public ResponseResult<JSONObject> getPermListByKey(String key) {
		ResponseResult<JSONObject> result = new ResponseResult<>();
		JSONObject data = new JSONObject();
		try {
			MetaFormProfile metaFormProfile = MetaFactory.getGlobalInstance().getMetaFormList().get(key);
			if (null == metaFormProfile) {
				result.setCode(1);
				result.setMsg("该key" + key + "对应的文件不存在");
				return result;
			}
			// 操作权限数据源设置
			setOperPermDataSource(data, metaFormProfile);
			// 组件及表格数据源设置
			setCompAndGridPermDataSource(data, metaFormProfile);

			result.setCode(0);
			result.setMsg("获取Key获取权限列表成功");
			result.setData(data);
		} catch (Throwable e) {
			logger.warning("根据Key获取权限列表异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("根据Key获取权限列表失败，失败消息为:" + e.getMessage());
		}
		return result;
	}

	/***
	 * 判断表里的数据源和数据对象中是否有主表
	 * @param mapKey 表单key或数据对象key
	 * @param mapType 类型：表单或数据对象
	 * @return 是否有主表，true：有；false：没有
	 * @throws Throwable 抛出异常到调用方
	 */
	public boolean hasMainTable(String mapKey, int mapType) throws Throwable {
		boolean hasMainTable = false;
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		MetaDataObject metaDataObject = null;
		if (mapType == ProcessMapType.Form) {
			MetaFormList metaFormList = metaFactory.getMetaFormList();
			MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
			MetaFormProfile metaFormProfile = metaFormList.get(mapKey);
			MetaForm form = metaFormProfile.getForm();
			if (form.getFormType() != FormType.Dict) {
				MetaDataSource dataSource = Optional.ofNullable(form).map(MetaForm::getDataSource)
						.orElse(Optional.ofNullable(metaFactory.getMetaForm(mapKey)).map(MetaForm::getDataSource).orElse(null));
				if (null != dataSource) {
					String refObjectKey = dataSource.getRefObjectKey();
					if (StringUtils.isNotEmpty(refObjectKey)) {
						metaDataObject = dataObjectList.get(refObjectKey).getDataObject();
					} else {
						metaDataObject = dataSource.getDataObject();
					}
				}
			}
		} else if (mapType == ProcessMapType.DataObject) {
			MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
			metaDataObject = dataObjectList.get(mapKey).getDataObject();
		}
		String primaryTableKey = null != metaDataObject ? metaDataObject.getMainTableKey() : null;
		if (StringUtils.isNotEmpty(primaryTableKey)) {
			hasMainTable = true;
		}
		return hasMainTable;
	}

	/***
	 * 操作权限数据源设置
	 * @param data 设置后的数据对象
	 * @param metaFormProfile 表单对象
	 */
	private void setOperPermDataSource(JSONObject data, MetaFormProfile metaFormProfile) {
		MetaOperationCollection operationCollection = metaFormProfile.getForm().getOperationCollection();
		if (null != operationCollection && operationCollection.size() > 0) {
			JSONObject iteam = null;
			JSONArray operPermArray = new JSONArray();
			Iterator<KeyPairCompositeObject> iterator = operationCollection.iterator();
			while (iterator.hasNext()) {
				KeyPairCompositeObject next = iterator.next();
				if (null != next && StringUtils.isNotEmpty(next.getKey())) {
					iteam = new JSONObject();
					iteam.put(ConstantUtil.KEY, next.getKey());
					if (next instanceof MetaOperationCollection) {
						iteam.put(ConstantUtil.CAPTION, ((MetaOperationCollection) next).getCaption());
					} else if (next instanceof MetaOperation) {
						iteam.put(ConstantUtil.CAPTION, ((MetaOperation) next).getCaption());
					}
					iteam.put("OptSelect", false);
					operPermArray.add(iteam);
				}
			}
			if (!CollectionUtils.isEmpty(operPermArray)) {
				// 升序排列
				operPermArray.sort((o1, o2) -> ((JSONObject) o1).getString(ConstantUtil.KEY)
						.compareToIgnoreCase(((JSONObject) o2).getString(ConstantUtil.KEY)));
			}
			data.put("operPermArray", operPermArray);
		}
	}

	/***
	 * 设置组件及表格权限的数据源
	 * @param data 设置后的数据对象
	 * @param metaFormProfile 表单对象
	 */
	private void setCompAndGridPermDataSource(JSONObject data, MetaFormProfile metaFormProfile) {
		List<MetaComponent> allComponents = metaFormProfile.getForm().getAllComponents();
		if (!CollectionUtils.isEmpty(allComponents)) {
			JSONObject iteam = null;
			JSONArray compPermArray = new JSONArray();
			JSONArray gridPermArray = new JSONArray();
			for (MetaComponent comp : allComponents) {
				iteam = new JSONObject();
				if (StringUtils.isNotEmpty(comp.getKey())) {
					iteam.put(ConstantUtil.KEY, comp.getKey());
					iteam.put(ConstantUtil.CAPTION, comp.getCaption());
					iteam.put("VisibleSelect", true);
					iteam.put("EnableSelect", false);
					compPermArray.add(iteam);
				}
				// 表格权限
				if (comp instanceof MetaGrid) {
					JSONObject iteamGrid = null;
					iteamGrid = new JSONObject();
					iteamGrid.put("GridName", comp.getKey());
					MetaGridColumnCollection columnCollection = ((MetaGrid) comp).getColumnCollection();
					JSONObject columnItem = null;
					JSONArray columnArray = new JSONArray();
					for (MetaGridColumn column : columnCollection) {
						columnItem = new JSONObject();
						columnItem.put(ConstantUtil.KEY, column.getKey());
						columnItem.put(ConstantUtil.CAPTION, column.getCaption());
						columnItem.put("EnableSelect", false);
						columnArray.add(columnItem);
					}
					iteamGrid.put("GridDataArray", columnArray);
					gridPermArray.add(iteamGrid);
				}
			}

			if (!CollectionUtils.isEmpty(compPermArray)) {
				// 升序排列
				compPermArray.sort((o1, o2) -> ((JSONObject) o1).getString(ConstantUtil.KEY)
						.compareToIgnoreCase(((JSONObject) o2).getString(ConstantUtil.KEY)));
			}

			if (!CollectionUtils.isEmpty(gridPermArray)) {
				// 升序排列
				gridPermArray.sort((o1, o2) -> ((JSONObject) o1).getString("GridName")
						.compareToIgnoreCase(((JSONObject) o2).getString("GridName")));

			}
			// 组件权限数组
			data.put("compPermArray", compPermArray);
			// 表格权限数组
			data.put("gridPermArray", gridPermArray);
		}
	}

	/***
	 * 从文件路径总获取项目标识
	 * @param filePath 文件路径
	 * @return 项目标识
	 */
	private String getProjectKeyByFilePath(String filePath) {
		String parentPath = new File(filePath).getParent();
		return parentPath.substring(parentPath.lastIndexOf(File.separator) + 1);
	}

	/***
	 * 根据文件路径获取根元素
	 * @param filePath 文件路径
	 * @return 根元素
	 * @throws DocumentException 文档异常
	 */
	private Element getRootElementByFilePath(String filePath) throws Throwable {
		//获取临时文件路径
		String tempPath = XmlFileProcessor.instance.getTmpFile(filePath);
		if (StringUtils.isBlank(tempPath)) {
			tempPath = filePath;
		}
		// 创建SAX读取器
		SAXReader reader = new SAXReader();
		// 加载文档
		Document document = reader.read(new File(tempPath));
		// 获取根节点
		return document.getRootElement();
	}

	private Element getRootElementByFilePath(String filePath, boolean is) throws Throwable {
		//不创建临时文件
		// 创建SAX读取器
		SAXReader reader = new SAXReader();
		// 加载文档
		Document document = reader.read(new File(filePath));
		// 获取根节点
		return document.getRootElement();
	}

	/***
	 * 工作流保存功能，用临时文件替换文件夹文件
	 * @return 结果反馈
	 * @param
	 */
	public ResponseResult<JSONArray> SaveBPMXML(String filePaths) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		try {
			String newContent = FileUtils.readFileToString(new File(filePaths), "UTF-8");
			XmlFileProcessor.instance.clearTmpFile(filePaths);
			result.setCode(0);
			result.setMsg("保存工作流成功");
			//处理bpm实体
			IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
			String key = LoadFileTree.getKeyByFilePath(filePaths);
			String newSecondLine = DesignIOMetaUtil.getSecondLine(newContent);
			String version;
			if (newSecondLine.contains(ConstantUtil.VERSION)) {
				version = DesignIOMetaUtil.getSubString(newSecondLine, "Version=\"([A-Za-z0-9]\\w*)\"");
			} else {
				version = "1";
			}
			globalInstance.updateProcessDefination(key, Integer.parseInt(version));
			globalInstance.updateProcessDefinationByDeployKey(key);
		} catch (Throwable e) {
			logger.warning("保存出现异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("保存出现异常，失败消息为:" + e.getMessage());
		}
		return result;
	}

}
