package com.bokesoft.yes.design.bpm.util;

import org.apache.commons.lang3.StringUtils;

/***
 * 转换特殊字符的工具类
 * @date 2020-09-25
 * @author zhsy
 */
public class ConvertSpecialStringUtil {
	/***
	 * 转换特殊字符串
	 * @param sourceStr 源字符串
	 * @return 转换后的字符串
	 */
	public static String convertSpecialString(String sourceStr) {
		if (StringUtils.isEmpty(sourceStr)) {
			return sourceStr;
		}
		sourceStr = sourceStr.replaceAll("&", "&amp;")
				.replaceAll("<", "&lt;")
				.replaceAll(">", "&gt;")
				.replaceAll("\"", "&quot;")
				.replaceAll("\'", "&apos;")
				.replaceAll("\n", "@br@")
				.replaceAll("\\n", "@br@")
				.replaceAll("\r\n", "@br@")
				.replaceAll("\"", "\\\"");
		return sourceStr;
	}

	/***
	 * 替换特殊字符串
	 * @param sourceStr 源字符串
	 * @return 替换后的字符串
	 */
	public static String replaceSpecialString(String sourceStr) {
		if (StringUtils.isEmpty(sourceStr)) {
			return sourceStr;
		}
		sourceStr = sourceStr.replaceAll("&amp;", "&")
				.replaceAll("&lt;", "<")
				.replaceAll("&gt;", ">")
				.replaceAll("&quot;", "\"")
				.replaceAll("shuangyinghao", "\"")
				.replaceAll("&apos;", "\'")
				.replaceAll("\\n", "\n")
				.replaceAll("@n@", "\n")
				.replaceAll("@br@", "\n");
		return sourceStr;
	}
}
