package com.bokesoft.yes.design.bpm.po;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.enums.NodeKeyAndCaptionEnum;
import com.bokesoft.yes.design.constant.ConstantUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/***
 * 泳道节点
 * @date 2020-10-14
 * @author zhsy
 */
public class Swimline {
	private static final Logger logger = Logger.getLogger(Swimline.class.getName());

	/***节点类型*/
	private String NodeType;
	/***ID属性*/
	private String ID;
	/***Key属性*/
	private String Key;
	/***Caption属性*/
	private String Caption;
	/***Direction属性*/
	private String Direction;
	/***Position属性*/
	private String Position;
	/***Size属性*/
	private String Size;

	/***
	 * 保存到xml文件中
	 * @param operNodeJson 操作节点json
	 * @param nodeId 节点id
	 * @param nodeType 节点类型
	 * @return 操作后的节点元素
	 * @throws Throwable 抛出异常
	 */
	public Element save(JSONObject operNodeJson, Element root, String nodeType, String nodeId) throws Throwable {
		Element node = null;
		try {
			// 获取Key
			String key = operNodeJson.getJSONObject("props").getJSONObject(ConstantUtil.KEY).getString("value");
			key = StringUtils.isEmpty(key) ? nodeId : key;

			if (null == root.element("SwimlineCollection")) {
				root.addElement("SwimlineCollection");
			}
			// 判断给key的元素是否存在，存在先删除，然后插入
			List<Element> swimlineList = root.element("SwimlineCollection").elements("Swimline");
			if (!CollectionUtils.isEmpty(swimlineList)) {
				for (Element ele : swimlineList) {
					if (key.equals(ele.attributeValue(ConstantUtil.KEY))) {
						root.element("SwimlineCollection").remove(ele);
					}
				}
			}
			Element swimlineCollectionNode = root.element("SwimlineCollection");
			// 设置元素公共部分
			node = this.saveCommonAttributesToXml(operNodeJson, swimlineCollectionNode, nodeType, nodeId);

			// 设置属性
			JSONObject propsJsonObj = operNodeJson.getJSONObject("props");
			Set<String> keys = propsJsonObj.keySet();
			String v = "";
			List<String> list = new ArrayList<>();
			for (String k : keys) {
				v = propsJsonObj.getJSONObject(k).getString("value");
				if ("null".equals(v)) {
					v = "";
				}
				if (ConstantUtil.X.equals(k) || ConstantUtil.Y.equals(k)) {
					list.add(v);
				}
				if ("Width".equals(k) || ConstantUtil.HEIGHT.equals(k)) {
					if (list.size() == 2) {
						list.clear();
					}
					list.add(v);
				}
				switch (k) {
					case "Direction":
						this.saveAttributeToXml(node, propsJsonObj, k);
						break;
					case ConstantUtil.X:
					case ConstantUtil.Y:
						if (null != list && list.size() == 2) {
							node.addAttribute("Position", "X:" + list.get(0) + "," + "Y:" + list.get(1));
						}
						break;
					case "Width":
					case ConstantUtil.HEIGHT:
						if (null != list && list.size() == 2) {
							node.addAttribute("Size", "Width:"
									+ list.get(1) + "," + "Height:" + list.get(0));
						}
						break;
					default:
						break;
				}
			}

			// 设置Direction属性
			if (StringUtils.isNotEmpty(node.attributeValue("Direction"))) {
				this.setDirection(node.attributeValue("Direction"));
			} else {
				this.setDirection("Vertical");
			}

		} catch (Throwable e) {
			logger.warning("保存公共属性到xml文件异常，异常为:" + ExceptionUtils.getStackTrace(e));
			throw e;
		}
		return node;
	}

	/***
	 * 保存自己的属性到xml文件中
	 * @param operNodeJson 操作节点json
	 * @param node 当前节点
	 */
	public void saveSelfAttributesToXml(JSONObject operNodeJson, Element node) throws Throwable {
	}

	/***
	 * 获取前端默认值设置json
	 * @return 设置后的json
	 */
	public JSONObject setFrontDefaultValues() {
		Map<String, String> otherAttributesMap = new HashMap<>(1);
		otherAttributesMap.put("Direction", this.getDirection());
		return this.getFrontDefaultValuesJson(otherAttributesMap);
	}

	/***
	 * 设置元素公共部分
	 * @param operNodeJson 操作的节点json
	 * @param root 根元素
	 * @param nodeType 节点类型
	 * @param nodeId 节点id，也即xml中的属性Key
	 * @return 设置后的元素
	 */
	public Element saveCommonAttributesToXml(JSONObject operNodeJson, Element root, String nodeType, String nodeId) {
		// 获取id
		String id = nodeId.replaceAll("rect", "").replaceAll("path", "");
		// 获取Key
		String key = operNodeJson.getJSONObject("props").getJSONObject(ConstantUtil.KEY).getString("value");
		key = StringUtils.isEmpty(key) ? nodeId : key;
		// 获取Caption
		String caption = operNodeJson.getJSONObject("props").getJSONObject(ConstantUtil.CAPTION).getString("value");

		// 设置默认的Caption
		if (StringUtils.isEmpty(caption)) {
			caption = NodeKeyAndCaptionEnum.valueOf(nodeType).getCaption();
		}

		Element node = null;
		List<Element> elements = root.elements(nodeType);
		if (!CollectionUtils.isEmpty(elements)) {
			for (Element ele : elements) {
				if (key.equals(ele.attributeValue(ConstantUtil.KEY))) {
					node = ele;
					break;
				}
			}
		}

		if (null == node) {
			node = root.addElement(nodeType);
		}

		// 保存ID，Key，Caption属性到xml文件中
		node.addAttribute("ID", id).addAttribute(ConstantUtil.CAPTION, caption).addAttribute(ConstantUtil.KEY, key);
		// 设置属性到当前对象中，为了默认值显示服务
		this.setNodeType(nodeType);
		this.setID(id);
		this.setCaption(caption);
		this.setKey(key);
		return node;
	}

	/***
	 * 获取前端默认值设置json
	 * @param otherAttributesMap 其他属性map
	 * @return 设置后的json
	 */
	public JSONObject getFrontDefaultValuesJson(Map<String, String> otherAttributesMap) {
		JSONObject nodeJson = new JSONObject();
		this.setFrontDefaultValue(this, otherAttributesMap, nodeJson);
		return nodeJson;
	}

	/***
	 * 设置前端默认值
	 * @param node 节点对象
	 * @param otherAttributesMap 要设置默认值的其他属性map
	 * @param nodeJson 当前节点json
	 */
	private void setFrontDefaultValue(Swimline node, Map<String, String> otherAttributesMap, JSONObject nodeJson) {
		// hashMap的默认长度
		int length = 4;
		if (otherAttributesMap!=null && otherAttributesMap.size()>0) {
			length += otherAttributesMap.size();
		}

		// 设置公共属性，包括：NodeType,ID,Key,Caption
		Map<String, String> commonAttributesMap = this.setCommonAttributesToJson(node, length);

		// 将其他要设置默认值的属性添加到map中
		if (otherAttributesMap!=null && otherAttributesMap.size()>0) {
			commonAttributesMap.putAll(otherAttributesMap);
		}

		//将内容写入json中，并返回前端页面属性框中显示
		this.setProps(commonAttributesMap, nodeJson);
	}

	/***
	 * 保存属性到xml文件中
	 * @param node 当前node节点
	 * @param propsJsonObj 前端传过来的属性及对应的值json
	 * @param attribute 属性
	 */
	public void saveAttributeToXml(Element node, JSONObject propsJsonObj, String attribute) {
		String v = propsJsonObj.getJSONObject(attribute).getString("value");
		if (StringUtils.isNotEmpty(v)) {
			if (null != node.attribute(attribute)) {
				node.remove(node.attribute(attribute));
			}
			node.addAttribute(attribute, v);
		} else {
			deleteXmlElementAttribute(node, node.attribute(attribute));
		}
	}

	/***
	 * 设置公共属性的json，给前端使用
	 * @param node 节点对象
	 * @param length hashMap的默认长度
	 * @return 设置后的map
	 */
	private Map<String, String> setCommonAttributesToJson(Swimline node, int length) {
		// 设置公共属性值啊
		Map<String, String> commonAttributesMap = new HashMap<>(length);
		commonAttributesMap.put("NodeType", node.getNodeType());
		commonAttributesMap.put("ID", node.getID());
		commonAttributesMap.put(ConstantUtil.KEY, node.getKey());
		commonAttributesMap.put(ConstantUtil.CAPTION, node.getCaption());
		return commonAttributesMap;
	}

	/***
	 * 设置属性值
	 * @param commonAttributesMap 公共属性map
	 * @param nodeJson 节点json
	 */
	private void setProps(Map<String, String> commonAttributesMap, JSONObject nodeJson) {
		String key = "";
		JSONObject v = null;
		for (Map.Entry<String, String> map : commonAttributesMap.entrySet()) {
			key = map.getKey();
			v = new JSONObject();
			v.put("value", map.getValue());
			nodeJson.put(key, v);
		}
	}

	/***
	 * 删除xml元素属性
	 * @param element 元素
	 * @param attribute 属性
	 * @return true：删除成功；false:删除失败
	 */
	public boolean deleteXmlElementAttribute(Element element, Attribute attribute) {
		if (null != attribute) {
			return element.remove(attribute);
		}
		return false;
	}

	public Swimline() {
	}

	public String getNodeType() {
		return NodeType;
	}

	public void setNodeType(String nodeType) {
		NodeType = nodeType;
	}

	public String getID() {
		return ID;
	}

	public void setID(String ID) {
		this.ID = ID;
	}

	public String getKey() {
		return Key;
	}

	public void setKey(String key) {
		Key = key;
	}

	public String getCaption() {
		return Caption;
	}

	public void setCaption(String caption) {
		Caption = caption;
	}

	public String getDirection() {
		return Direction;
	}

	public void setDirection(String direction) {
		Direction = direction;
	}

	public String getPosition() {
		return Position;
	}

	public void setPosition(String position) {
		Position = position;
	}

	public String getSize() {
		return Size;
	}

	public void setSize(String size) {
		Size = size;
	}
}
