package com.bokesoft.yes.design.bpm.po;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.constant.ConstantUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/***
 * SubProcess节点
 * @date 2020-10-14
 * @author zhsy
 */
public class SubProcess extends Node {

	private static final Logger logger = Logger.getLogger(SubProcess.class.getName());
	/***TimerItemCollection属性*/
	private String TimerItemCollection;
	/***RevokeCondition属性*/
	private String RevokeCondition;
	/***CreateTrigger属性*/
	private String CreateTrigger;
	/***FinishTrigger属性*/
	private String FinishTrigger;
	/***FinishCondition属性*/
	private String FinishCondition;
	/***ValidCondition属性*/
	private String ValidCondition;
	/***PassCondition属性*/
	private String PassCondition;
	/***DataMapCondition属性*/
	private String DataMapCondition;
	/***BillDataMapInfoCollection属性*/
	private String BillDataMapInfoCollection;
	/***AutoStartAction属性*/
	private String AutoStartAction;
	/***SubProcessKey属性*/
	private String SubProcessKey;
	/***SyncMode属性*/
	private String SyncMode;
	/***AutoIgnoreNoParticipator属性*/
	private String AutoIgnoreNoParticipator;
	/***Perm属性*/
	private String Perm;
	/***OperationCollection属性*/
	private String OperationCollection;
	/***AssistanceCollection属性*/
	private String AssistanceCollection;
	/***ParticipatorCollection属性*/
	private String ParticipatorCollection;
	/***DenyNodeKey属性*/
	private String DenyNodeKey;
	/***DenyToLastNode属性*/
	private String DenyToLastNode;

	/***
	 * 保存自己的属性到xml文件中
	 * @param operNodeJson 操作节点json
	 * @param node 当前节点
	 */
	@Override
	public void saveSelfAttributesToXml(JSONObject operNodeJson, Element node) throws Throwable {
		try {
			// 设置属性
			JSONObject propsJsonObj = operNodeJson.getJSONObject("props");
			Set<String> keys = propsJsonObj.keySet();
			String v = "";
			for (String k : keys) {
				v = propsJsonObj.getJSONObject(k).getString("value");
				if ("null".equals(v)) {
					v = "";
				}
				switch (k) {
					case "TimerItemCollection":
						super.setTimerItemCollectionXmlValue(node, v, k);
						break;
					case "RevokeCondition":
					case "CreateTrigger":
					case "FinishTrigger":
					case "FinishCondition":
					case "ValidCondition":
					case "PassCondition":
					case "DataMapCondition":
					case "BillDataMapInfoCollection":
					case "AutoStartAction":
					case "SubProcessKey":
					case "SyncMode":
						super.saveAttributeToXml(node, propsJsonObj, k);
						break;
					case "AutoIgnoreNoParticipator":
					case "DenyToLastNode":
						if ("true".equals(v)) {
							node.addAttribute(k, v);
						} else {
							super.deleteXmlElementAttribute(node, node.attribute(k));
						}
						break;
					case "Perm":
						super.savePermToXml(node, v, k);
						break;
					case ConstantUtil.OPERATION_COLLECTION:
						super.setOperationCollectionXmlValue(node, v, k);
						break;
					case "AssistanceCollection":
						super.setAssistanceCollectionFromFrontJson(node, v, k);
						break;
					case "ParticipatorCollection":
						super.saveParticipatorCollectionToXml(node, v, k);
						break;
					case "DenyNodeKey":
						// 是否驳回上一步为"否"，并且驳回目标节点不为空时，添加该属性
						if ("false".equals(propsJsonObj.getJSONObject("DenyToLastNode").getString("value")) &&
                                StringUtils.isNotEmpty(v)) {
							node.addAttribute(k, v);
						} else {
							super.deleteXmlElementAttribute(node, node.attribute(k));
						}
						break;
					default:
						break;
				}
			}

			// 这两个元素页面上没有设置的地方，只添加元素不设置属性
			if (null == node.element("NodeAttachment")) {
				node.addElement("NodeAttachment");
			}

			// 获取属性SyncMode的值
			if (StringUtils.isNotEmpty(node.attributeValue("SyncMode"))) {
				this.setSyncMode(node.attributeValue("SyncMode"));
			} else {
				this.setSyncMode("Synchronized");
			}
		} catch (Exception e) {
			logger.warning("保存属性到xml文件异常，异常为:" + ExceptionUtils.getStackTrace(e));
			throw e;
		}
	}

	/***
	 * 获取前端默认值设置json
	 * @return 设置后的json
	 */
	@Override
	public JSONObject setFrontDefaultValues() {
		Map<String, String> otherAttributesMap = new HashMap<>(1);
		otherAttributesMap.put("SyncMode", this.getSyncMode());
		return super.getFrontDefaultValuesJson(otherAttributesMap);
	}

	public SubProcess() {
	}

	public String getTimerItemCollection() {
		return TimerItemCollection;
	}

	public void setTimerItemCollection(String timerItemCollection) {
		TimerItemCollection = timerItemCollection;
	}

	public String getRevokeCondition() {
		return RevokeCondition;
	}

	public void setRevokeCondition(String revokeCondition) {
		RevokeCondition = revokeCondition;
	}

	public String getCreateTrigger() {
		return CreateTrigger;
	}

	public void setCreateTrigger(String createTrigger) {
		CreateTrigger = createTrigger;
	}

	public String getFinishTrigger() {
		return FinishTrigger;
	}

	public void setFinishTrigger(String finishTrigger) {
		FinishTrigger = finishTrigger;
	}

	public String getFinishCondition() {
		return FinishCondition;
	}

	public void setFinishCondition(String finishCondition) {
		FinishCondition = finishCondition;
	}

	public String getValidCondition() {
		return ValidCondition;
	}

	public void setValidCondition(String validCondition) {
		ValidCondition = validCondition;
	}

	public String getPassCondition() {
		return PassCondition;
	}

	public void setPassCondition(String passCondition) {
		PassCondition = passCondition;
	}

	public String getDataMapCondition() {
		return DataMapCondition;
	}

	public void setDataMapCondition(String dataMapCondition) {
		DataMapCondition = dataMapCondition;
	}

	public String getBillDataMapInfoCollection() {
		return BillDataMapInfoCollection;
	}

	public void setBillDataMapInfoCollection(String billDataMapInfoCollection) {
		BillDataMapInfoCollection = billDataMapInfoCollection;
	}

	public String getAutoStartAction() {
		return AutoStartAction;
	}

	public void setAutoStartAction(String autoStartAction) {
		AutoStartAction = autoStartAction;
	}

	public String getSubProcessKey() {
		return SubProcessKey;
	}

	public void setSubProcessKey(String subProcessKey) {
		SubProcessKey = subProcessKey;
	}

	public String getSyncMode() {
		return SyncMode;
	}

	public void setSyncMode(String syncMode) {
		SyncMode = syncMode;
	}

	public String getAutoIgnoreNoParticipator() {
		return AutoIgnoreNoParticipator;
	}

	public void setAutoIgnoreNoParticipator(String autoIgnoreNoParticipator) {
		AutoIgnoreNoParticipator = autoIgnoreNoParticipator;
	}

	public String getPerm() {
		return Perm;
	}

	public void setPerm(String perm) {
		Perm = perm;
	}

	public String getOperationCollection() {
		return OperationCollection;
	}

	public void setOperationCollection(String operationCollection) {
		OperationCollection = operationCollection;
	}

	public String getAssistanceCollection() {
		return AssistanceCollection;
	}

	public void setAssistanceCollection(String assistanceCollection) {
		AssistanceCollection = assistanceCollection;
	}

	public String getParticipatorCollection() {
		return ParticipatorCollection;
	}

	public void setParticipatorCollection(String participatorCollection) {
		ParticipatorCollection = participatorCollection;
	}

	public String getDenyNodeKey() {
		return DenyNodeKey;
	}

	public void setDenyNodeKey(String denyNodeKey) {
		DenyNodeKey = denyNodeKey;
	}

	public String getDenyToLastNode() {
		return DenyToLastNode;
	}

	public void setDenyToLastNode(String denyToLastNode) {
		DenyToLastNode = denyToLastNode;
	}
}
