package com.bokesoft.yes.design.bpm.po;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.constant.ConstantUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/***
 * State节点
 * @date 2020-10-14
 * @author zhsy
 */
public class State extends Node {

	private static final Logger logger = Logger.getLogger(State.class.getName());
	/***Status属性*/
	private String Status;
	/***CreateTrigger属性*/
	private String CreateTrigger;
	/***FinishTrigger属性*/
	private String FinishTrigger;
	/***FieldKey属性*/
	private String FieldKey;
	/***RevokeCondition属性*/
	private String FieldValue;
	/***RevokeCondition属性*/
	private String RevokeCondition;
	/***Condition属性*/
	private String Condition;
	/***Enable属性*/
	private String Enable;
	/***Visible属性*/
	private String Visible;
	/***Icon属性*/
	private String Icon;
	/***TemplateKey属性*/
	private String TemplateKey;
	/***Action属性*/
	private String Action;
	/***Direction属性*/
	private String Direction;
	/***Perm属性*/
	private String Perm;
	/***ParticipatorCollection属性*/
	private String ParticipatorCollection;
	/***OperationKey属性*/
	private String OperationKey;
	/***OperationCaption属性*/
	private String OperationCaption;

	/***
	 * 保存自己的属性到xml文件中
	 * @param operNodeJson 操作节点json
	 * @param node 当前节点
	 */
	@Override
	public void saveSelfAttributesToXml(JSONObject operNodeJson, Element node) throws Throwable {
		try {
			// 设置属性"Status、CreateTrigger、FinishTrigger、Perm、FieldKey、FieldValue、ParticipatorCollection、
			//        RevokeCondition"
			JSONObject propsJsonObj = operNodeJson.getJSONObject("props");
			Set<String> keys = propsJsonObj.keySet();
			String v = "";
			for (String k : keys) {
				v = propsJsonObj.getJSONObject(k).getString("value");
				if ("null".equals(v)) {
					v = "";
				}
				switch (k) {
					case "Status":
					case "CreateTrigger":
					case "FinishTrigger":
					case ConstantUtil.FIELD_KEY:
					case "FieldValue":
					case "RevokeCondition":
					case "Condition":
					case ConstantUtil.ENABLE:
					case ConstantUtil.VISIBLE:
					case "Icon":
					case "TemplateKey":
					case ConstantUtil.ACTION:
						super.saveAttributeToXml(node, propsJsonObj, k);
						break;
					case "Direction":
						if ("Direction".equals(v)) {
							node.addAttribute(k, v);
						} else {
							super.deleteXmlElementAttribute(node, node.attribute(k));
						}
						break;
					case "Perm":
						savePermToXml(node, v, k);
						break;
					case "ParticipatorCollection":
						super.saveParticipatorCollectionToXml(node, v, k);
						break;
					case "OperationKey":
						if (StringUtils.isNotEmpty(v)) {
							node.element(ConstantUtil.OPERATION).addAttribute(ConstantUtil.KEY, v);
						} else {
							super.deleteXmlElementAttribute(node, node.attribute(k));
						}
						break;
					case "OperationCaption":
						if (StringUtils.isNotEmpty(v)) {
							node.element(ConstantUtil.OPERATION).addAttribute(ConstantUtil.CAPTION, v);
						} else {
							super.deleteXmlElementAttribute(node, node.attribute(k));
						}
						break;
					default:
						break;
				}
			}

			// 添加元素"NodeAttachment"
			if (null == node.element("NodeAttachment")) {
				node.addElement("NodeAttachment");
			}

			// 获取属性WorkitemRevoke的值
			if (StringUtils.isNotEmpty(node.attributeValue("WorkitemRevoke"))) {
				this.setWorkitemRevoke(node.attributeValue("WorkitemRevoke"));
			} else {
				this.setWorkitemRevoke("true");
			}

			// 获取属性IsSync的值
			if (StringUtils.isNotEmpty(node.attributeValue("IsSync"))) {
				this.setIsSync(node.attributeValue("IsSync"));
			} else {
				this.setIsSync("false");
			}
		} catch (Exception e) {
			logger.warning("保存属性到xml文件异常，异常为:" + ExceptionUtils.getStackTrace(e));
			throw e;
		}
	}

	/***
	 * 获取前端默认值设置json
	 * @return 设置后的json
	 */
	@Override
	public JSONObject setFrontDefaultValues() {
		Map<String, String> otherAttributesMap = new HashMap<>(2);
		otherAttributesMap.put("WorkitemRevoke", this.getWorkitemRevoke());
		otherAttributesMap.put("IsSync", this.getIsSync());
		return super.getFrontDefaultValuesJson(otherAttributesMap);
	}

	public State() {
	}

	public String getStatus() {
		return Status;
	}

	public void setStatus(String status) {
		Status = status;
	}

	public String getCreateTrigger() {
		return CreateTrigger;
	}

	public void setCreateTrigger(String createTrigger) {
		CreateTrigger = createTrigger;
	}

	public String getFinishTrigger() {
		return FinishTrigger;
	}

	public void setFinishTrigger(String finishTrigger) {
		FinishTrigger = finishTrigger;
	}

	public String getFieldKey() {
		return FieldKey;
	}

	public void setFieldKey(String fieldKey) {
		FieldKey = fieldKey;
	}

	public String getFieldValue() {
		return FieldValue;
	}

	public void setFieldValue(String fieldValue) {
		FieldValue = fieldValue;
	}

	public String getRevokeCondition() {
		return RevokeCondition;
	}

	public void setRevokeCondition(String revokeCondition) {
		RevokeCondition = revokeCondition;
	}

	public String getCondition() {
		return Condition;
	}

	public void setCondition(String condition) {
		Condition = condition;
	}

	public String getEnable() {
		return Enable;
	}

	public void setEnable(String enable) {
		Enable = enable;
	}

	public String getVisible() {
		return Visible;
	}

	public void setVisible(String visible) {
		Visible = visible;
	}

	public String getIcon() {
		return Icon;
	}

	public void setIcon(String icon) {
		Icon = icon;
	}

	public String getTemplateKey() {
		return TemplateKey;
	}

	public void setTemplateKey(String templateKey) {
		TemplateKey = templateKey;
	}

	public String getAction() {
		return Action;
	}

	public void setAction(String action) {
		Action = action;
	}

	public String getDirection() {
		return Direction;
	}

	public void setDirection(String direction) {
		Direction = direction;
	}

	public String getPerm() {
		return Perm;
	}

	public void setPerm(String perm) {
		Perm = perm;
	}

	public String getParticipatorCollection() {
		return ParticipatorCollection;
	}

	public void setParticipatorCollection(String participatorCollection) {
		ParticipatorCollection = participatorCollection;
	}

	public String getOperationKey() {
		return OperationKey;
	}

	public void setOperationKey(String operationKey) {
		OperationKey = operationKey;
	}

	public String getOperationCaption() {
		return OperationCaption;
	}

	public void setOperationCaption(String operationCaption) {
		OperationCaption = operationCaption;
	}
}
