package com.bokesoft.yes.design;

import com.bokesoft.yes.design.metaobjecttype.MetaObjectTypeDefine;
import com.bokesoft.yes.design.metaobjecttype.MetaXMLDiffProcessing;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.struct.document.Document;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

/**
 * 设计器配置对象类
 * （设计器表单）
 */
public class MetaObjectType implements MetaXMLDiffProcessing {


    public final String name;

    /**
     * 配置对象类型列表 通过反射加载
     */
    private static final Map<String, MetaObjectType> OBJECT_TYPE_LIST = new HashMap<>();

    /**
     *  这两个属性不知道为什么放在这里
     * 列表视图的头
     */
    public static final String listview_columnheader = "listview_columnheader";
    /**
     * 表格列的明细单元格
     */
    public static final String STR_GridField_GridCell = "GridField_gridcell";


    public MetaObjectType(String name) {
        this.name = name;
    }

    /**
     * 设置定义的配置对象（名称对应）
     */
    private static void setMetaObjectTypeList() {
        // 将MetaObjectTypeDefine中的配置对象类型加载到OBJECT_TYPE_LIST中
        Class<MetaObjectTypeDefine> metaObjectTypeDefClass = MetaObjectTypeDefine.class;
        Class<MetaObjectType> metaObjectTypeClass = MetaObjectType.class;
        Field[] fields = metaObjectTypeDefClass.getFields();
        for (Field field : fields) {
            try {
                // 只获取字段类型是MetaObjectType的
                if (!(MetaObjectType.class.getName().equals(field.getType().getName())
                        && Modifier.isStatic(field.getModifiers()))) {
                    continue;
                }
                MetaObjectType type = (MetaObjectType) field.get(metaObjectTypeClass);
                OBJECT_TYPE_LIST.put(type.name, type);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        Field[] fields1 = metaObjectTypeClass.getFields();
        for (Field field : fields1) {
            try {
                // 只获取字段类型是MetaObjectType的
                if (!(MetaObjectType.class.getName().equals(field.getType().getName())
                        && Modifier.isStatic(field.getModifiers()))) {
                    continue;
                }
                MetaObjectType type = (MetaObjectType) field.get(metaObjectTypeClass);
                OBJECT_TYPE_LIST.put(type.name, type);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }


    /**
     * 根据名称获取配置对象类型
     * @param name
     * @return
     */
    public static MetaObjectType getMetaObjectType(String name) {
        // 尝试获取一次
//        if (MetaObjectType_LIST.size() == 0) genMetaObjectTypeList();
        if (!OBJECT_TYPE_LIST.containsKey(name)) {
            throw new RuntimeException(name + "是未实现的配置对象类型。");
        }
        return OBJECT_TYPE_LIST.get(name);
    }


    @Override
    public String toString() {
        return name;
    }

    // 定义的配置对象类型 因为处理流程中还有很多使用的是MetaObject中的定义 暂时保留
    // 定义的配置对象类型
    public static final MetaObjectType MacroCollection = MetaObjectTypeDefine.MacroCollection;
    public static final MetaObjectType FormTool = MetaObjectTypeDefine.FormTool;
    public static final MetaObjectType Reseau = MetaObjectTypeDefine.Reseau;//网格
    public static final MetaObjectType form = MetaObjectTypeDefine.form;
    public static final MetaObjectType ComboBox = MetaObjectTypeDefine.ComboBox;
    public static final MetaObjectType dataSource = MetaObjectTypeDefine.dataSource;
    public static final MetaObjectType tableCollection = MetaObjectTypeDefine.tableCollection;
    public static final MetaObjectType DataObject = MetaObjectTypeDefine.DataObject;
    public static final MetaObjectType ItemFilter = MetaObjectTypeDefine.ItemFilter;
    public static final MetaObjectType Layout = MetaObjectTypeDefine.Layout;
    public static final MetaObjectType TraceCollection = MetaObjectTypeDefine.TraceCollection;
    public static final MetaObjectType ExtOptCollection = MetaObjectTypeDefine.ExtOptCollection;
    public static final MetaObjectType Separate = MetaObjectTypeDefine.Separate;//分隔尺寸
    public static final MetaObjectType fieldCondition = MetaObjectTypeDefine.fieldCondition;
    public static final MetaObjectType table = MetaObjectTypeDefine.table;
    public static final MetaObjectType column = MetaObjectTypeDefine.column;
    public static final MetaObjectType operation = MetaObjectTypeDefine.operation;
    public static final MetaObjectType operationCollection = MetaObjectTypeDefine.operationCollection;
    public static final MetaObjectType DataObjectCheckRule = MetaObjectTypeDefine.DataObjectCheckRule;
    public static final MetaObjectType GridFilter = MetaObjectTypeDefine.GridFilter;
    public static final MetaObjectType ColumnExpand = MetaObjectTypeDefine.ColumnExpand;
    /**
     * Panel使用layout形成诸如FlexFlowLayoutPanel、TabPanel、GridLayoutPanel等Panel
     */
    public static final MetaObjectType panel = MetaObjectTypeDefine.panel;
    public static final MetaObjectType gridLayoutPanel = MetaObjectTypeDefine.gridLayoutPanel;
    public static final MetaObjectType comboBoxType = MetaObjectTypeDefine.comboBoxType;
    public static final MetaObjectType comboboxSourceSetting = MetaObjectTypeDefine.ComBoBoxSourceSetting;
    /**
     * 界面字段
     */
    public static final MetaObjectType field = MetaObjectTypeDefine.field;
    /**
     * 表格字段
     */
    public static final MetaObjectType gridField = MetaObjectTypeDefine.gridField;
    /**
     * 表格头字段
     */
    public static final MetaObjectType GridField_columnheader = MetaObjectTypeDefine.GridField_columnheader;
    /**
     * 表格多行字段
     */
    public static final MetaObjectType GridFieldMultiRowTable = MetaObjectTypeDefine.GridFieldMultiRowTable;

    public static final MetaObjectType subDetail = MetaObjectTypeDefine.subDetail;
    public static final MetaObjectType grid = MetaObjectTypeDefine.grid;
    public static final MetaObjectType toolbar = MetaObjectTypeDefine.toolbar;
    public static final MetaObjectType ToolBar = MetaObjectTypeDefine.ToolBar;
    public static final MetaObjectType DropdownButton = MetaObjectTypeDefine.DropdownButton;
    public static final MetaObjectType ExtraLayout = MetaObjectTypeDefine.ExtraLayout;
    /**
     * ListView
     */
    public static final MetaObjectType listView = MetaObjectTypeDefine.listView;
    /**
     * ListView字段
     */
    public static final MetaObjectType listViewField = MetaObjectTypeDefine.listViewField;
    /**
     * 宏公式
     */
    public static final MetaObjectType Macro = MetaObjectTypeDefine.Macro;
    /**
     * 宏公式
     */
    public static final MetaObjectType Formula = MetaObjectTypeDefine.Formula;
    /**
     * 字段属性
     */
    public static final MetaObjectType Fieldinformation = MetaObjectTypeDefine.Fieldinformation;
    /**
     * 基本属性
     */
    public static final MetaObjectType BasicAttribute = MetaObjectTypeDefine.BasicAttribute;
    /**
     * 数据源属性
     */
    public static final MetaObjectType SetupMainTable = MetaObjectTypeDefine.SetupMainTable;
    //嵌入组件
    public static final MetaObjectType ContainerKey = MetaObjectTypeDefine.ContainerKey;
    public static final MetaObjectType SetupPersist = MetaObjectTypeDefine.SetupPersist;
    public static final MetaObjectType SetupObjectPersist = MetaObjectTypeDefine.SetupObjectPersist;
    public static final MetaObjectType GridFieldRow = MetaObjectTypeDefine.GridFieldRow;
    public static final MetaObjectType GridCellType = MetaObjectTypeDefine.GridCellType;
    public static final MetaObjectType EmbedPanel = MetaObjectTypeDefine.EmbedPanel;
    public static final MetaObjectType buttonReplace = MetaObjectTypeDefine.buttonReplace;
    public static final MetaObjectType EmbedVar = MetaObjectTypeDefine.EmbedVar;
    public static final MetaObjectType D_Embed = MetaObjectTypeDefine.D_Embed;
    public static final MetaObjectType Embed = MetaObjectTypeDefine.Embed;
    public static final MetaObjectType DictViewColumn = MetaObjectTypeDefine.DictViewColumn;
    public static final MetaObjectType D_DictView = MetaObjectTypeDefine.D_DictView;
    public static final MetaObjectType AddRowPanel = MetaObjectTypeDefine.AddRowPanel;
    public static final MetaObjectType DeleteRowPanel = MetaObjectTypeDefine.DeleteRowPanel;
    public static final MetaObjectType GridHeadColumn = MetaObjectTypeDefine.GridHeadColumn;

    public static final MetaObjectType ListViewColumn = MetaObjectTypeDefine.ListViewColumn;
    public static final MetaObjectType DataOperationToobar = MetaObjectTypeDefine.DataOperationToobar;
    public static final MetaObjectType GridRowTree = MetaObjectTypeDefine.GridRowTree;
    public static final MetaObjectType CommonDef = MetaObjectTypeDefine.CommonDef;
    public static final MetaObjectType UICheckRule = MetaObjectTypeDefine.UICheckRule;
    public static final MetaObjectType Setting = MetaObjectTypeDefine.Setting;
    public static final MetaObjectType NoRights = MetaObjectTypeDefine.NoRights;
    public static final MetaObjectType Enhance = MetaObjectTypeDefine.Enhance;
    public static final MetaObjectType IOSetting = MetaObjectTypeDefine.IOSetting;
    public static final MetaObjectType ParaTable = MetaObjectTypeDefine.ParaTable;
    public static final MetaObjectType SearchHelpDef = MetaObjectTypeDefine.SearchHelpDef;
    public static final MetaObjectType Parameter = MetaObjectTypeDefine.Parameter;
    public static final MetaObjectType DomainDef = MetaObjectTypeDefine.DomainDef;
    public static final MetaObjectType DataElementDef = MetaObjectTypeDefine.DataElementDef;
    public static final MetaObjectType Solution = MetaObjectTypeDefine.Solution;

    //图表
    public static final MetaObjectType ChartDataSource = MetaObjectTypeDefine.ChartDataSource;
    public static final MetaObjectType Chart = MetaObjectTypeDefine.Chart;
    public static final MetaObjectType WebBrowser = MetaObjectTypeDefine.WebBrowser;
    
    public static final MetaObjectType TabItem = MetaObjectTypeDefine.TabItem;

    //TableView
    public static final MetaObjectType TableView = MetaObjectTypeDefine.TableView;
    public static final MetaObjectType TableViewRow = MetaObjectTypeDefine.TableViewRow;
    public static final MetaObjectType AddTableViewRow = MetaObjectTypeDefine.AddTableViewRow;
    public static final MetaObjectType DeleteTableViewRow = MetaObjectTypeDefine.DeleteTableViewRow;

    //CollectionView
    public static final MetaObjectType CollectionView = MetaObjectTypeDefine.CollectionView;
    public static final MetaObjectType CollectionViewRow = MetaObjectTypeDefine.CollectionViewRow;

    //Container
    public static final MetaObjectType Container = MetaObjectTypeDefine.Container;
    public static final MetaObjectType GridRow = MetaObjectTypeDefine.GridRow;

    // EditView
    public static final MetaObjectType EditView = MetaObjectTypeDefine.EditView;
    public static final MetaObjectType EditViewColumn = MetaObjectTypeDefine.EditViewColumn;
    public static final MetaObjectType AddRowLayout = MetaObjectTypeDefine.AddRowLayout;
    public static final MetaObjectType DeleteRowLayout = MetaObjectTypeDefine.DeleteRowLayout;
    public static final MetaObjectType RowActionCollection = MetaObjectTypeDefine.RowActionCollection;
    public static final MetaObjectType EditViewItemCollection = MetaObjectTypeDefine.EditViewItemCollection;
    public static final MetaObjectType EditViewChildLayout = MetaObjectTypeDefine.EditViewChildLayout;
    public static final MetaObjectType EditViewRootGridLayout = MetaObjectTypeDefine.EditViewRootGridLayout;
    public static final MetaObjectType EditViewRootLinearLayout = MetaObjectTypeDefine.EditViewRootLinearLayout;
    public static final MetaObjectType EditViewChildGridLayout = MetaObjectTypeDefine.EditViewChildGridLayout;
    public static final MetaObjectType EditViewChildLinearLayout = MetaObjectTypeDefine.EditViewChildLinearLayout;
    public static final MetaObjectType EditViewChildFlexFlowLayout = MetaObjectTypeDefine.EditViewChildFlexFlowLayout;
    public static final MetaObjectType EditViewChildColumnLayout = MetaObjectTypeDefine.EditViewChildColumnLayout;
    public static final MetaObjectType EditViewChildSplitLayout = MetaObjectTypeDefine.EditViewChildSplitLayout;
    public static final MetaObjectType EditViewChildTabLayout = MetaObjectTypeDefine.EditViewChildTabLayout;
    public static final MetaObjectType EditViewChildFlowLayout = MetaObjectTypeDefine.EditViewChildFlowLayout;
    public static final MetaObjectType EditViewChildFlexGridLayout = MetaObjectTypeDefine.EditViewChildFlexGridLayout;

    // Block
    public static final MetaObjectType Block = MetaObjectTypeDefine.Block;

    @Override
    public void mergeDiff(MetaForm metaForm, Diff diff, Document document) throws Throwable {}


    /**
     * 反射获取 test
     * static初始化map集合 获取时直接获取
     */
    static {
        setMetaObjectTypeList();
    }
}
