package com.bokesoft.erp.webdesigner.service.datamap;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.erp.config.MetaFormNODBProcess;
import com.bokesoft.yes.mid.cmd.richdocument.strut.ComboxStringBuilder;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DataMapUtil {
	public static MetaTableCollection getTableCollection(String formKey) throws Throwable {
		TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
		MetaForm metaForm = metaFormOrMetaDataObject.metaForm;
		MetaDataObject metaDataObject = metaFormOrMetaDataObject.metaDataObject;
		MetaTableCollection tableCollection = null;
		if (metaForm != null) {//表单
			tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
		} else if (metaDataObject != null) {//数据对象表单
			tableCollection = metaDataObject.getTableCollection();
		}
		return tableCollection;
	}

	public static HashMap<String, HashMap<String, Object>> getNodbFields(MetaTableCollection tableCollection) {
		HashMap<String, HashMap<String, Object>> hashNODBFields = new HashMap<>();
		HashMap<String, Object> formKeys = new HashMap<>();
		hashNODBFields.put("DesignFormKeys", formKeys);
		for (MetaTable metaTable : tableCollection) {

			if (metaTable.getKey().contains(MetaFormNODBProcess.STR_NODBTable_Profix)) {
				HashMap<String, Object> hashNODBField = new HashMap<>();
				for (MetaColumn metaColumn : metaTable) {
					if (!metaColumn.isSystemControlField()) {
						hashNODBField.put(metaColumn.getKey(), metaColumn);
					}
				}
				String metaTableKey = metaTable.getKey().substring(0, metaTable.getKey().indexOf(MetaFormNODBProcess.STR_NODBTable_Profix));
				hashNODBFields.put(metaTableKey, hashNODBField);

				formKeys.put(metaTableKey, metaTable.getKey());

			}
		}

		return hashNODBFields;
	}

	public static void getComboxValues(MetaTable metaTable, MetaTableCollection tableCollection, IDLookup idLookup, String condition,
									   ComboxStringBuilder csb,String type) throws Throwable {
		String finalTable = metaTable.getKey();
		Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
		for (MetaColumn metaColumn : metaTable) {
//            if (metaColumn.getKey().endsWith(MetaFormNODBProcess.STR_NODBTable_Profix)) continue;
			int index = tableCollection.indexOf(metaTable) + 1;
			// 添加字段信息
			if (columKeysAndFieldKeys == null){
				continue;
			}
			List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
			if (CollectionUtils.isEmpty(fieldKeys)) {
				continue;
			}
			String fieldKey = fieldKeys.get(0);
			fieldKey = StringUtils.isBlank(fieldKey) ? metaColumn.getKey() : fieldKey;
			if (StringUtil.isBlankOrNull(condition) || fieldKey.toLowerCase().contains(condition.toLowerCase()) || metaColumn.getCaption().toLowerCase().contains(condition.toLowerCase())) {
				String value = metaTable.getKey() + "|" + fieldKey;
				String caption = "表(" + index + ")" + fieldKey + " " + metaColumn.getCaption();
				csb.addItem(value, caption);
			}
		}
		if ("target".equals(type) && getNodbFields(tableCollection).containsKey(metaTable.getKey())) {
			HashMap<String, HashMap<String, Object>> nodbFields = getNodbFields(tableCollection);
			HashMap<String, Object> designFormKeys = nodbFields.get("DesignFormKeys");
			columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys((String) designFormKeys.get(metaTable.getKey()));
			HashMap<String, Object> metaColumns = nodbFields.get(metaTable.getKey());
			for (Map.Entry<String, Object> Columns : metaColumns.entrySet()) {
				MetaColumn metaColumn = (MetaColumn) Columns.getValue();
				int index = tableCollection.indexOf(metaTable) + 1;
				// 添加字段信息
				List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
				if (CollectionUtils.isEmpty(fieldKeys)) {
					continue;
				}
				String fieldKey = fieldKeys.get(0);
				fieldKey = StringUtils.isBlank(fieldKey) ? metaColumn.getKey() : fieldKey;
				String cap = getCap(idLookup, metaColumn, fieldKey);
				if (StringUtil.isBlankOrNull(condition) || fieldKey.toLowerCase().contains(condition.toLowerCase()) || cap.toLowerCase().contains(condition.toLowerCase())) {
					String value = metaTable.getKey() + "|" + fieldKey;
					String caption = "表(" + index + ")" + fieldKey + " " + cap;
					csb.addItem(value, caption);
				}
			}
		}
	}

	public static String getCap(IDLookup idLookup, MetaColumn metaColumn, String fieldKey) {
		String cap = metaColumn.getCaption();
		MetaGridCell gridCellByKey = idLookup.getGridCellByKey(fieldKey);
		if (gridCellByKey == null) {
			try {
				cap = idLookup.getComponentByKey(fieldKey).getCaption();
			} catch (Exception e) {
				return cap;
			}
		} else {
			cap = gridCellByKey.getCaption();
		}
		return cap;
	}
}
