package com.bokesoft.erp.webdesigner.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoRawConfiger;
import com.bokesoft.distro.tech.bootsupport.starter.deployment.SpringResourceMultiSolutionMetaResolverFactory;

import javax.annotation.PostConstruct;

@Component
@ConditionalOnProperty(name = "application-erp.webdesigner.use-default-solution", havingValue = "true", matchIfMissing = true)
public class WebDesignerServiceBeanFactory {
    private static Logger logger = LoggerFactory.getLogger(WebDesignerServiceBeanFactory.class);
    @PostConstruct
    public void init() {
        logger.info("WebDesignerServiceBeanFactory inited!");
    }
    @Bean
    public YigoRawConfiger addYigoERPDesignerSolution() {



        /*return context -> {
            String rootResourcePath = "classpath:/sln-erpdesigner-solution";

            rootResourcePath ="file:///"+System.getProperty("user.dir")+"/../"+"erp-webdesigner/erp-webdesigner-backend/src/main/resources/sln-erpdesigner-solution";
            context.addSolution("sln-erpdesigner-solution",
                    SpringResourceMultiSolutionMetaResolverFactory.class,
                    SpringResourceMultiSolutionMetaResolverFactory
                            .buildParas(rootResourcePath));
        };*/





        return context -> context.addSolution("sln-erpdesigner-solution",
                SpringResourceMultiSolutionMetaResolverFactory.class,
                SpringResourceMultiSolutionMetaResolverFactory
                        .buildParas("classpath:/sln-erpdesigner-solution"));
    }
}
