package com.bokesoft.erp.desigerfunction;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 和ERP相关函数的一些方法
 */
public class DesigerFunctionUtil {
    private static final Logger logger = LoggerFactory.getLogger(DesigerFunctionUtil.class);

    public static void init() throws Throwable {
        if (DesigerFunctionNames != null) { // 表示已经加载过
            return;
        }
        DesigerFunctionNames = new ArrayList<String>();
        String className = "com.bokesoft.erp.desigerfunction.RegisterDesigerFunction";
        Class<?> clz = Class.forName(className);
        Method clzMethod = clz.getMethod("init");
        Class<?>[][] formulas = (Class<?>[][]) clzMethod.invoke(clz.newInstance());

        Set<Class<?>> allFormulasForCheckDuplicate = new HashSet<>();
        for (Class<?>[] clzs : formulas) {
            if (clzs == null) {
                continue;
            }
            for (Class<?> tmpclz : clzs) {
                if (!allFormulasForCheckDuplicate.contains(tmpclz)) {
                    registerERPMidFunction_(tmpclz);
                    allFormulasForCheckDuplicate.add(tmpclz);
                } else {
                    logger.warn("ERP函数类" + tmpclz.getName() + "重复定义，请检查相关代码。");
                }
            }
        }
        //RegisterDesigerShortNameFun

        className = "com.bokesoft.erp.desigerfunction.RegisterDesigerShortNameFun";
        clz = Class.forName(className);
        clzMethod = clz.getMethod("init");
        Class<?>[] clzArray = (Class<?>[]) clzMethod.invoke(clz);
        for (Class<?> tmpclz : clzArray) {
            if (!allFormulasForCheckDuplicate.contains(tmpclz)) {
                registerERPShortNameMidFunction_(tmpclz);
                allFormulasForCheckDuplicate.add(tmpclz);
            } else {
                logger.warn("ERP函数类" + tmpclz.getName() + "重复定义，请检查相关代码。");
            }
        }

    }

    // /** 所有的函数对应的原方法 */
    // public static StringHashMap<Method> ERPMidFunctions = new
    // StringHashMap<Method>();
    // /** 所有的函数对应的原类 */
    // public static StringHashMap<Class<?>> ERPMidFunctionClasses = new
    // StringHashMap<Class<?>>();
    /**
     * ERP的所有函数名 className.methodName
     */
    private static List<String> DesigerFunctionNames;

    /**
     * 中间层二次开发类缓冲 Key是className
     */
    private static StringHashMap<DesigerCustomClass> midCustomClasses = new StringHashMap<DesigerCustomClass>();

    /**
     * Key为methodName,Value 为className;
     *
     * @return
     * @throws Throwable
     */
    private static StringHashMap<String> methodNameAndClassName = new StringHashMap<String>();

    public static List<String> getDesigerFunctionNames() {
        if (DesigerFunctionNames == null) {
            try {
                init();
            } catch (Throwable e) {
                LogSvr.getInstance().error("加载函数", e);
            }
        }
        return DesigerFunctionNames;
    }

    public static void registerERPMidFunction(String className) throws Throwable {
        Class<?> clz = Class.forName(className);
        registerERPMidFunction_(clz);
    }

    public static void registerERPMidFunction_(Class<?> clz) throws Throwable {
        String className = clz.getName().intern();
        DesigerCustomClass result = new DesigerCustomClass(clz);
        result.genMethod(methodNameAndClassName, DesigerFunctionNames);
        midCustomClasses.put(className, result);
    }

    public static void registerERPShortNameMidFunction_(Class<?> clz) throws Throwable {
        String className = clz.getName();
        DesigerCustomClass result = new DesigerCustomClass(clz);
        result.genShortMethod(methodNameAndClassName, DesigerFunctionNames);
        midCustomClasses.put(className, result);
    }

    /**
     * 自定义函数最多的参数个数
     */
    private static final int INT_Max_ParaCount = 128;
    /**
     * 方法名到方法对象的缓存，按参数个数形成一个数组
     */
    private static Object/*Map<String, Method>*/[] methodNameMethods = new Object[INT_Max_ParaCount];

    public static Method getFunctionMethod(String methodName, int paraCount) {
        if (paraCount >= INT_Max_ParaCount) {
            throw new RuntimeException("函数最多127个参数，当前函数" + methodName + "的参数个数为" + paraCount);
        }
        @SuppressWarnings("unchecked") Map<String, Method> methodNameMethod =
                (Map<String, Method>) methodNameMethods[paraCount];
        if (methodNameMethod == null) {
            methodNameMethod = new HashMap<String, Method>();
            methodNameMethods[paraCount] = methodNameMethod;
        }
        Method result = methodNameMethod.get(methodName);
        if (result == null) {
            int ipos = methodName.lastIndexOf(".");
            String className = methodNameAndClassName.get(methodName);
            String shortMethodName = methodName;
            if (ipos > 0) {
                shortMethodName = methodName.substring(ipos + 1);
            }
            if (!StringUtil.isBlankOrNull(className)) {
                DesigerCustomClass erpCustomerClass = midCustomClasses.get(className);
                result = erpCustomerClass.getMethod(shortMethodName, paraCount);
                methodNameMethod.put(methodName, result);
            }
        }
        if (result == null) {
            if (VariableParasMethds.variableParasMethods.get(
                    methodName) != null && paraCount > VariableParasMethds.variableParasMethods.get(methodName)) {
                paraCount = VariableParasMethds.variableParasMethods.get(methodName);
                return getFunctionMethod(methodName, paraCount);
            }
        }
        return result;
    }

    public static Class<?> getClass(String methodName) {
        String className = methodNameAndClassName.get(methodName);
        DesigerCustomClass erpCustomerClass = midCustomClasses.get(className);
        return erpCustomerClass.getClz();
    }

}
