package com.bokesoft.erp.desigerfunction;

import com.bokesoft.yes.common.struct.StringHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;


/**
 * 二次开发的类,记录Class对象,主要用于判断是否存在二次开发的方法
 */
public class DesigerCustomClass {
	
	private static Logger logger = LoggerFactory.getLogger(DesigerCustomClass.class);
	/**
	 * 这个类所对应的Class对象
	 */
	private Class<?> clz;

	/** 类名 */
	final String className;

	public DesigerCustomClass(Class<?> clz) {
		this.clz = clz;
		this.className = clz.getName().intern();
		if (Modifier.isAbstract(clz.getModifiers())) {
			throw new RuntimeException("抽象类 "+ clz.getName()+ " 不能注册为公式");
		}
	}
	
	public void genMethod(StringHashMap<String> methodNameAndClassName,List<String> ERPFunctionNames){
		ensureLoadMethods(methodNameAndClassName,ERPFunctionNames,false);
	}
	
	public void genShortMethod(StringHashMap<String> methodNameAndClassName,List<String> ERPFunctionNames){
		ensureLoadMethods(methodNameAndClassName,ERPFunctionNames,true);
	}
	
	public  Class<?>  getClz(){
		return clz;
	}

	/**
	 * 判断是否有二次开发的方法
	 * 
	 * @param methodName
	 * @param paraCount
	 * @return
	 * @throws Throwable
	 */
	public boolean hasMethod(String methodName, int paraCount) throws Throwable {
//		ensureLoadMethods();
		for (CustomMethod method : methods) {
			if (method.paraCount == paraCount && method.methodName.equalsIgnoreCase(methodName)) {
				return true;
			}
		}
		return false;
	}

	public Method getMethod(String methodName, int paraCount) {
//		ensureLoadMethods();
		for (CustomMethod customMethod : methods) {
			if (customMethod.paraCount == paraCount && customMethod.methodName.equalsIgnoreCase(methodName)) {
				return customMethod.method;
			}
		}
		return null;
	}

	
	/** 所有的方法,这里方法不区分大小写,所以使用这个类 */
	List<CustomMethod> methods = null;

	private void ensureLoadMethods(StringHashMap<String> methodNameAndClassName,List<String> ERPFunctionNames,boolean shortName ) {
		if (methods != null) {
			return;
		}
		List<CustomMethod> tmpMethods = new ArrayList<CustomMethod>();
		try {
			for (Method method : clz.getMethods()) {
				if (method.getDeclaringClass().getName().equalsIgnoreCase("com.bokesoft.erp.entity.util.EntityContextAction")){
					continue;
				}
				int modifiers = method.getModifiers();
				if (Modifier.isPublic(modifiers) /*&& !Modifier.isStatic(modifiers)*/ && method.getReturnType() != null) {
					String methodName = method.getName().intern();
					int paraCount = method.getParameterTypes().length;
					if ((methodName.equals("toString") && paraCount == 0)
							|| (methodName.equals("getClass") && paraCount == 0)
							|| (methodName.equals("equals") && paraCount == 1)
							|| (methodName.equals("hashCode") && paraCount == 0)
							|| (methodName.equals("notify") && paraCount == 0)
							|| (methodName.equals("notifyAll") && paraCount == 0)
							|| (methodName.equals("wait") && (paraCount == 0 || paraCount == 1 || paraCount == 2))) {
						continue;
					}
					tmpMethods.add(new CustomMethod(methodName, paraCount,method));
					
					String funName="";
					if (shortName){
						funName = methodName;
					}else {
						funName = new StringBuilder(className).append(".").append(methodName).toString().intern();
					}
					methodNameAndClassName.put(funName, className);
					ERPFunctionNames.add(funName);
				}
			}
		} catch (Throwable e) {
			logger.error(e.getMessage(),e);
		}
		methods = tmpMethods;
	}
}

/**
 * 二次开发方法
 */
class CustomMethod {
	/** 方法名 */
	String methodName;
	/** 参数个数 */
	int paraCount;
	
	Method method;

	CustomMethod(String methodName, int paraCount,Method method) {
		this.methodName = methodName;
		this.paraCount = paraCount;
		this.method= method;
	}
}