package com.bokesoft.erp.all.controller;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.all.controller.util.SettingControlUtil;
import com.bokesoft.yes.design.setting.util.*;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.vo.SettingVo;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("/settingControl")
public class SettingControl {
    /**
     * 处理setting配置
     */
    @PostMapping("/handleSetting")
    @ResponseBody
    public ResponseResult<JSONObject> handleSetting(@RequestBody SettingVo settingVo) {
        final SettingOperJsonUtil settingOperJsonUtil = new SettingOperJsonUtil();
        return SettingControlUtil.getResponseResult(settingVo, settingOperJsonUtil);
    }

    /**
     * 处理NoRights配置
     */
    @PostMapping("/handleNoRights")
    @ResponseBody
    public ResponseResult<JSONObject> handleNoRights(@RequestBody SettingVo settingVo) {
        final NoRightsOperJsonUtil noRightsOperJsonUtil = new NoRightsOperJsonUtil();
        return SettingControlUtil.getResponseResult(settingVo, noRightsOperJsonUtil);
    }

    /**
     * 处理"ParaTable"配置
     */
    @PostMapping("/handleParaTable")
    @ResponseBody
    public ResponseResult<JSONObject> handleParaTable(@RequestBody SettingVo settingVo) {
        final ParaTableOperUtil paraTableOperUtil = new ParaTableOperUtil();
        return SettingControlUtil.getResponseResult(settingVo, paraTableOperUtil);
    }

    /**
     * 处理"Parameter"配置
     */
    @PostMapping("/handleParameter")
    @ResponseBody
    public ResponseResult<JSONObject> handleParameter(@RequestBody SettingVo settingVo) {
        final ParameterOperUtil parameterOperUtil = new ParameterOperUtil();
        return SettingControlUtil.getResponseResult(settingVo, parameterOperUtil);
    }

    /**
     * 处理Enhance配置
     */
    @PostMapping("/handleEnhance")
    @ResponseBody
    public ResponseResult<JSONObject> handleEnhance(@RequestBody SettingVo settingVo) {
        final EnhanceOperUtil enhanceOperUtil = new EnhanceOperUtil();
        return SettingControlUtil.getResponseResult(settingVo, enhanceOperUtil);
    }

    /**
     * 处理IOSetting配置
     */
    @PostMapping("/handleIOSetting")
    @ResponseBody
    public ResponseResult<JSONObject> handleIOSetting(@RequestBody SettingVo settingVo) {
        final IOSettingOperUtil ioSettingOperUtil = new IOSettingOperUtil();
        return SettingControlUtil.getResponseResult(settingVo, ioSettingOperUtil);
    }

    /**
     * 处理Solution配置
     */
    @PostMapping("/handleSolution")
    @ResponseBody
    public ResponseResult<JSONObject> handleSolution(@RequestBody SettingVo settingVo) {
         final SolutionOperUtil solutionOperUtil = new SolutionOperUtil();
        return SettingControlUtil.getResponseResult(settingVo, solutionOperUtil);
    }


    /**
     * 处理DataElementDef配置
     */
    @PostMapping("/handleDataElementDef")
    @ResponseBody
    public ResponseResult<JSONObject> handleDataElementDef(@RequestBody SettingVo settingVo) {
        final DataElementDefOperJsonUtil dataElementDefOperJsonUtil = new DataElementDefOperJsonUtil();
        return SettingControlUtil.getResponseResult(settingVo, dataElementDefOperJsonUtil);
    }


    /**
     * 处理DomainDef配置
     */
    @PostMapping("/handleDomainDef")
    @ResponseBody
    public ResponseResult<JSONObject> handleDomainDef(@RequestBody SettingVo settingVo) {
        final DomainDefOperJsonUtil domainDefOperJsonUtil = new DomainDefOperJsonUtil();
        return SettingControlUtil.getResponseResult(settingVo, domainDefOperJsonUtil);
    }

    /**
     * 处理CommonDef的方法
     */
    @PostMapping("/handleCommonDef")
    @ResponseBody
    public ResponseResult<JSONObject> handleCommonDef(@RequestBody SettingVo settingVo) {
        final CommonDefOperJsonUtil commonDefOperJsonUtil = new CommonDefOperJsonUtil();

        return SettingControlUtil.getResponseResult(settingVo, commonDefOperJsonUtil);
    }

}
