package com.bokesoft.erp.all.controller;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.all.controller.util.SettingControlUtil;
import com.bokesoft.yes.design.mergesingle.util.ExtraLayoutOperUtil;
import com.bokesoft.yes.design.mergesingle.util.FormToolOperUtil;
import com.bokesoft.yes.design.mergesingle.util.GridFilterOperUtil;
import com.bokesoft.yes.design.mergesingle.util.LayoutOperUtil;
import com.bokesoft.yes.design.mergesingle.util.NewGridFiledOperUtil;
import com.bokesoft.yes.design.mergesingle.util.QuoteGridFiledOperUtil;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.vo.SettingVo;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("/settingControl")
public class MergeSingleDiffControl {
    /**
     * 处理表单集合属性的方法
     */
    @PostMapping("/handleFormTool")
    @ResponseBody
    public ResponseResult<JSONObject> handleFormTool(@RequestBody SettingVo settingVo) {
        FormToolOperUtil formToolOperUtil = new FormToolOperUtil();
        return SettingControlUtil.getResponseResult(settingVo, formToolOperUtil);
    }
    /**
     * 处理表格过滤
     */
    @PostMapping("/handleGridFilter")
    @ResponseBody
    public ResponseResult<JSONObject> handleGridFilter(@RequestBody SettingVo settingVo) {
        GridFilterOperUtil gridFilterOperUtil = new GridFilterOperUtil();
        return SettingControlUtil.getResponseResult(settingVo, gridFilterOperUtil);
    }
    /**
     * 网格布局面板扩展设置
     */
    @PostMapping("/handleExtraLayout")
    @ResponseBody
    public ResponseResult<JSONObject> handleExtraLayout(@RequestBody SettingVo settingVo) {
        ExtraLayoutOperUtil extraLayoutOperUtil = new ExtraLayoutOperUtil();
        return SettingControlUtil.getResponseResult(settingVo, extraLayoutOperUtil);
    }
    /**
     * 网格布局面板扩展设置
     */
    @PostMapping("/handleLayout")
    @ResponseBody
    public ResponseResult<JSONObject> handleLayout(@RequestBody SettingVo settingVo) {
        LayoutOperUtil layoutOperUtil = new LayoutOperUtil();
        return SettingControlUtil.getResponseResult(settingVo, layoutOperUtil);
    }
    /**
     * 新增表格字段
     */
    @PostMapping("/handleNewGridFiled")
    @ResponseBody
    public ResponseResult<JSONObject> handleNewGridFiled(@RequestBody SettingVo settingVo) {
        NewGridFiledOperUtil newGridFiledOperUtil = new NewGridFiledOperUtil();
        return SettingControlUtil.getResponseResult(settingVo, newGridFiledOperUtil);
    }
    /**
     * 引入表格字段
     */
    @PostMapping("/handleQuoteGridFiled")
    @ResponseBody
    public ResponseResult<JSONObject> handleQuoteGridFiled(@RequestBody SettingVo settingVo) {
        QuoteGridFiledOperUtil quoteGridFiledOperUtil = new QuoteGridFiledOperUtil();
        return SettingControlUtil.getResponseResult(settingVo, quoteGridFiledOperUtil);
    }

}
