package com.bokesoft.erp.all.controller;


import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.XmlFormat;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.design.vo.JsonDesignerVo;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.tools.zip.GZIPTools;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;

@Controller
@RequestMapping("/DesignerController")
public class DesignerController {
    @PostMapping(value = "/checkColumn")
    @ResponseBody
    public ResponseResult<String> checkColumn(@RequestBody JsonDesignerVo jsonDesignerVo) throws Throwable {
        String formkey = jsonDesignerVo.getFormKey();
        String columnKey = jsonDesignerVo.getColumnKey();
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formkey);
        final String columnInfo;
        if (!"".equals(metaForm.getDataSource().getRefObjectKey())) {
            MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(metaForm.getDataSource().getRefObjectKey());
            columnInfo = getColumnInfo(columnKey, dataObject);
        } else {
            MetaDataObject dataObject = metaForm.getDataSource().getDataObject();
            columnInfo = getColumnInfo(columnKey, dataObject);
        }
        ResponseResult<String> response = new ResponseResult<>();
        response.setData(columnInfo);
        return response;
    }

    @PostMapping(value = "/formatXML")
    @ResponseBody
    public ResponseResult<JSONObject> formatXML(@RequestBody JsonDesignerVo jsonDesignerVo) throws Throwable {
        ResponseResult<JSONObject> response = new ResponseResult<>();
        JSONObject jsonObject = new JSONObject();
        //对前端数据进行解压缩
        String yigoData = jsonDesignerVo.getYigoData();
        if (yigoData != null) {
            byte[] bytes = Base64.decode(yigoData.getBytes());
            String resultDate = GZIPTools.decompress(new ByteArrayInputStream(bytes), "UTF-8");
            JSONObject jsonObject1 = JSONObject.parseObject(resultDate);
            jsonDesignerVo.setFormKey(jsonObject1.getString("formKey"));
            jsonDesignerVo.setColumnKey(jsonObject1.getString("columnKey"));
            jsonDesignerVo.setTableKey(jsonObject1.getString("tableKey"));
            jsonDesignerVo.setType(jsonObject1.getString("type"));
        }
        String formkey = jsonDesignerVo.getFormKey();
        try {
            String result = XmlFormat.formatXML_str(formkey);
            jsonObject.put("msg", result);
            response.setData(jsonObject);
            return response;
        } catch (Exception e) {
            jsonObject.put("msg", "false_" + e.getMessage());
            response.setData(jsonObject);
            return response;
        }
    }

    /**
     * linux,mac应该不支持
     *
     * @param jsonDesignerVo
     * @return
     */
    @PostMapping(value = "/openFileLocation")
    @ResponseBody
    public ResponseResult<JSONObject> openFileLocation(@RequestBody JsonDesignerVo jsonDesignerVo) {
        ResponseResult<JSONObject> response = new ResponseResult<>();
        JSONObject jsonObject = new JSONObject();
        try {
            String filePath = jsonDesignerVo.getFormKey();
            File file = new File(filePath);
            boolean windows = System.getProperty("os.name").toLowerCase().contains("windows");
            boolean linux = System.getProperty("os.name").toLowerCase().contains("linux");
            if (windows) {
                if ("1".equals(jsonDesignerVo.getType())) {
                    Runtime.getRuntime().exec("rundll32 SHELL32.DLL,ShellExec_RunDLL Explorer.exe /select," + file.getAbsolutePath());
                } else {
                    Runtime.getRuntime().exec("rundll32 shell32,OpenAs_RunDLL " + filePath);
                }
            } else if (linux) {//linux
                String folderPath  = FilePathHelper.toBackFilePath(filePath);
                String command;

                //FILE=$(zenity --file-selection --title="选择文件" --filename="/home")  选择命令
                // 根据用户的桌面环境选择合适的文件管理器命令
                if ("gnome".equalsIgnoreCase(System.getProperty("sun.desktop"))) {
                    command = "nautilus";
                } else if ("kde".equalsIgnoreCase(System.getProperty("sun.desktop"))) {
                    command = "dolphin";
                } else {
                    // 默认使用xdg-open，这是一个跨桌面环境的工具
                    command = "xdg-open";
                }
                try {
                    String[] envp = { command,folderPath};
                    Runtime.getRuntime().exec(envp);
                } catch (IOException e) {
                    e.printStackTrace();
                }
            } else {//mac
                if ("1".equals(jsonDesignerVo.getType())) {
                    String[] envp = { "/usr/bin/open",file.getParent()};
                    Runtime.getRuntime().exec(envp );
                } else {
                    String[] envp = { "/usr/bin/open",filePath};
                    Runtime.getRuntime().exec(envp );
                }
            }
            jsonObject.put("msg", "操作成功!");
            response.setCode(0);
            response.setMsg("返回成功");
            response.setData(jsonObject);
            return response;
        } catch (IOException e) {
            jsonObject.put("msg", "操作失败,失败原因为: " + e.getMessage());
            response.setCode(-99);
            response.setMsg("返回成功");
            response.setData(jsonObject);
            return response;
        }

/*
		以下有三种方式打开

*//**
         * 借助java.awt.Desktop打开
         * @see 打开的目录或文件名中允许包含空格

         *//*

		private static void useAWTDesktop() throws IOException{

			Desktop.getDesktop().open(new File("D:/my local/测试用例.xls"));

		}

		*//**
         * 借助cmd命令打开
         * @see WPS文字--------Runtime.getRuntime().exec("cmd /c start wps")

         * @see WPS表格--------Runtime.getRuntime().exec("cmd /c start et")

         * @see WPS演示--------Runtime.getRuntime().exec("cmd /c start wpp")

         * @see Office Word---Runtime.getRuntime().exec("cmd /c start winword")

         * @see Office Excel--Runtime.getRuntime().exec("cmd /c start excel")

         *//*

		private static void useCMDCommand() throws IOException{

			//若打开的目录或文件名中不包含空格,就用下面的方式

			//Runtime.getRuntime().exec("cmd /c start D:/mylocal/测试用例.xls");

			//(可以'运行'或'Win+R',然后输入'cmd /?'查看帮助信息)

			Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "D:/my local/测试用例.xls"});

		}

		*//**
         * 借助本地安装程序打开
         * @see 若打开的目录或文件名中包含空格,它就无能为力了.不过本地程序的安装目录允许含空格

         *//*

		private static void useLocalCommand() throws IOException{

			String etCommand = "D:/Program Files/WPS/8.1.0.3526/office6/et.exe";

			String filePath = "D:/mylocal/测试用例.xls";

			Runtime.getRuntime().exec(etCommand + " " + filePath);

		}

	}*/
    }

    @PostMapping(value = "/checkComponent")
    @ResponseBody
    public ResponseResult<JSONObject> checkComponent(@RequestBody JsonDesignerVo jsonDesignerVo) throws Throwable {
        ResponseResult<JSONObject> response = new ResponseResult<>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msg", "false");
        response.setData(jsonObject);
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(jsonDesignerVo.getFormKey());
        metaForm.getAllUIComponents().keySet().forEach(key -> {
            if (StringUtils.equalsIgnoreCase(key, jsonDesignerVo.getColumnKey())) {
                jsonObject.put("msg", "true");
                response.setData(jsonObject);
            }
        });
        return response;
    }

    @PostMapping(value = "/isHasColumnAndTableKey")
    @ResponseBody
    public ResponseResult<JSONObject> isHasColumnAndTableKey(@RequestBody JsonDesignerVo jsonDesignerVo) throws Throwable {
        //默认成功
        String str = "success";
        String type = jsonDesignerVo.getType();
        String formKey = jsonDesignerVo.getFormKey();
        String columnKey = jsonDesignerVo.getColumnKey();
        String tableKey = jsonDesignerVo.getTableKey();
        TwoTuple<MetaForm, MetaDataObject> twoTuple = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
        boolean metaFormNotNull = twoTuple.metaForm != null;
        boolean metaDataObjectNotNull = twoTuple.metaDataObject != null;
        MetaForm metaForm = twoTuple.metaForm;
        MetaDataObject metaDataObject = twoTuple.metaDataObject;
        if (ConstantUtil.TABLE_KEY.equals(type)) {
            if (metaFormNotNull) {
                MetaTable table = metaForm.getDataSource().getDataObject().getTable(tableKey);
                if (table != null) {
                    str = "当前添加的表标识 " + "<span style = 'color:red;font-size:14px'>" + tableKey + "</span>" + " 已经存在,请勿重复添加";
                }
            } else if (metaDataObjectNotNull) {
                MetaTable table = metaDataObject.getTable(tableKey);
                if (table != null) {
                    str = "当前添加的表标识 " + "<span style = 'color:red;font-size:14px'>" + tableKey + "</span>" + " 已经存在,请勿重复添加";
                }
            }
        } else if (ConstantUtil.COLUMN_KEY.equals(type)) {
            if (metaFormNotNull) {
                MetaColumn metaColumn = metaForm.getDataSource().getDataObject().findColumn(tableKey, columnKey);
                if (metaColumn != null) {
                    str = "当前添加的列标识 " + "<span style = 'color:red;font-size:14px'>" + columnKey + "</span>" + " 已经存在,请勿重复添加";
                }
            } else if (metaDataObjectNotNull) {
                MetaColumn metaColumn = metaDataObject.findColumn(tableKey, columnKey);
                if (metaColumn != null) {
                    str = "当前添加的列标识 " + "<span style = 'color:red;font-size:14px'>" + columnKey + "</span>" + " 已经存在,请勿重复添加";
                }
            }
        }
        ResponseResult<JSONObject> response = new ResponseResult<>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msg", str);
        response.setData(jsonObject);
        return response;
    }

    /**
     * @param columnKey
     * @param dataObject 获取字段信息
     */
    private String getColumnInfo(String columnKey, MetaDataObject dataObject) {
        for (MetaTable Table : dataObject.getTableCollection()) {
            if (dataObject.findColumn(Table.getKey(), columnKey) != null) {
                MetaColumn column = dataObject.findColumn(Table.getKey(), columnKey);
                return column.getKey() + " " + column.getCaption();
            }
        }
        return "";
    }
}
