package com.bokesoft.erp.all.controller;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.dataObject.util.DataObjectOperJsonUtil;
import com.bokesoft.yes.design.vo.DataObjectVO;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.helper.DocumentHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.tools.zip.GZIPTools;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONArray;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * 数据对象控制器方法
 */
@RestController
@RequestMapping("/dataObjectController")
public class DataObjectController {
    private final DataObjectOperJsonUtil dataObjectOperJsonUtil = new DataObjectOperJsonUtil();

    @PostMapping("/handleDataObject")
    public ResponseResult<JSONObject> handleDataObject(@RequestBody DataObjectVO dataObjectVO) {
        ResponseResult<JSONObject> response = new ResponseResult<>();
        JSONObject data = new JSONObject();
        try {
            //对前端数据进行解压缩
            String yigoData = dataObjectVO.getYigoData();
            if (yigoData != null) {
                byte[] bytes = Base64.decode(yigoData.getBytes());
                String resultDate = GZIPTools.decompress(new ByteArrayInputStream(bytes), "UTF-8");
                JSONObject jsonObject = JSONObject.parseObject(resultDate);
                dataObjectVO.setFormkey(jsonObject.getString("formkey"));
                dataObjectVO.setDataobjectkey(jsonObject.getString("dataobjectkey"));
                dataObjectVO.setDocument(jsonObject.getString("document"));
                dataObjectVO.setKey(jsonObject.getString("key"));
                dataObjectVO.setPath(jsonObject.getString("filePath"));
                dataObjectVO.setMark(jsonObject.getString("mark"));
                dataObjectVO.setValue(jsonObject.getString("value"));
                dataObjectVO.setDiff(jsonObject.getString("diff"));
            }
            String formKey = dataObjectVO.getFormkey();
            Document document = DocumentHelper.parseDocumentFormJSON(dataObjectVO.getDocument());

            //处理diffs数据
            String diffJsonString = dataObjectVO.getDiff();
            JSONArray array = new JSONArray(diffJsonString);
            int len = array.length();
            List<Diff> diffs = new ArrayList<>(len);
            for (int i = 0; i < len; i++) {
                diffs.add(Diff.fromJson(array.getJSONObject(i)));
            }
            return dataObjectOperJsonUtil.handleDataObject(formKey, document, diffs);
        } catch (RuntimeException e) {
            LogSvr.getInstance().warn("操作失败,失败信息为:" + ExceptionUtils.getStackTrace(e));
            data.put("code", 999);
            data.put("msg", e.getMessage());
        } catch (Throwable e) {
            LogSvr.getInstance().warn("操作失败,失败信息为:" + ExceptionUtils.getStackTrace(e));
            data.put("code", 999);
            data.put("msg", "操作失败,失败信息为:" + e.getMessage());
        }
        response.setData(data);
        return response;
    }

    /**
     * 处理字段信息和基本属性
     */
    @PostMapping("/FieldinforOrBasicAttribute")
    public ResponseResult<JSONObject> FieldinforOrBasicAttribute(@RequestBody DataObjectVO dataObjectVO) {
        ResponseResult<JSONObject> response = new ResponseResult<>();
        try {
            return dataObjectOperJsonUtil.FieldinforOrBasicAttribute(dataObjectVO);
        } catch (Exception e) {
            LogSvr.getInstance().error("处理字段信息和基本属性失败！", e);
            response.setCode(999);
            response.setMsg("处理字段信息和基本属性失败，失败信息为:" + e.getMessage());
        } catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        return response;
    }

    /**
     * 获得子明细组件Key
     */
    @PostMapping("/getKey")
    public ResponseResult<JSONObject> getKey(@RequestBody DataObjectVO dataObjectVO) {
        return dataObjectOperJsonUtil.getKey(dataObjectVO);
    }

    /**
     * 获得子明细组件Key
     */
    @PostMapping("/getEmbedKey")
    public String getEmbedKey(@RequestBody DataObjectVO dataObjectVO) {
        return dataObjectOperJsonUtil.getEmbedKey(dataObjectVO);
    }
}
