-- 判断本身是否已经加过写锁了
local lock_mode = ARGV[1]
local lock_num = ARGV[2]
local arg_num = 3
if redis.call("exists", ARGV[arg_num]) == 1 then
    if redis.call("SISMEMBER", KEYS[arg_num], ARGV[arg_num]) == 1 then
        redis.call("incr", ARGV[arg_num] .. "N")
        return "OK"
    else
        return redis.call("get", ARGV[arg_num])
    end
end
-- 检查上级的写锁
for i = 2, lock_num do
    arg_num = arg_num + 1
    if redis.call("exists", ARGV[arg_num]) == 1 then
        if redis.call("SISMEMBER", KEYS[arg_num], ARGV[arg_num]) == 0 then
            return redis.call("get", ARGV[arg_num])
        end
    end
end

-- 检查下级写锁
arg_num = arg_num + 1
local resdiff = redis.call("sdiff", KEYS[arg_num], ARGV[arg_num])
if next(resdiff) == nil then
else
    return redis.call("get", resdiff[1])
end

-- 如果是写锁，还要检查是否有人加读锁
if lock_mode == "W" then
    for i = 1, lock_num do
        arg_num = arg_num + 1
        resdiff = redis.call("sdiff", KEYS[arg_num], ARGV[arg_num])
        if next(resdiff) == nil then
        else
            return redis.call("get", resdiff[1])
        end
    end
end

--增加锁信息
arg_num = arg_num + 1
redis.call("set", KEYS[arg_num], ARGV[arg_num])
redis.call("incr", KEYS[arg_num] .. "N")

local loop_num = lock_num - 1
if lock_mode == "R" then
    arg_num = arg_num + 1
    redis.call("sadd", KEYS[arg_num], ARGV[arg_num])
    loop_num = lock_num
end
for i = 1, loop_num + 3 do
    arg_num = arg_num + 1
    redis.call("sadd", KEYS[arg_num], ARGV[arg_num])
end
return "OK"
