/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.util;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.cmd.richdocument.strut.IDLookup;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.struct.datatable.filter.FilterEval;
import com.bokesoft.yes.util.VarUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ERPDataTableUtil {
    private static Map<MetaTable, DataTableMetaData> dataTableMetaDataCache = new HashMap<MetaTable, DataTableMetaData>();

    public static boolean existColumn(DataTable dataTable, String string) throws Throwable {
        DataTableMetaData dataTableMetaData = dataTable.getMetaData();
        return dataTableMetaData.constains(string);
    }

    public static boolean isChange(DataTable dataTable) throws Throwable {
        FilterEval filterEval = null;
        ArrayList arrayList = dataTable.filter(filterEval);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            int n2 = dataTable.getState(dataTable.getRowIndexByBookmark(n));
            if (n2 != 1 && n2 != 2 && n2 != 3) continue;
            return true;
        }
        return false;
    }

    public static boolean isColumnUpdated(DataTable dataTable, int n, String string) throws Throwable {
        Object object;
        Object object2 = dataTable.getObject(n, string);
        boolean bl = VarUtil.compare((Object)object2, (Object)(object = dataTable.getOriginalObject(n, string))) != 0;
        return bl;
    }

    public static void cloneOneRow(DataTable dataTable, DataTable dataTable2, MetaTable metaTable, String string, int n, int n2) {
        for (MetaColumn metaColumn : metaTable) {
            String string2 = metaColumn.getBindingDBColumnName();
            if (!StringUtil.isBlankOrNull((String)string) && string.toUpperCase().contains("," + string2.toUpperCase() + ",")) continue;
            dataTable2.setObject(n2, string2, dataTable.getObject(n, string2));
        }
    }

    public static void cloneOneRowFromDtl2Dict(DataTable dataTable, RichDocument richDocument, MetaTable metaTable, String string, int n, int n2, boolean bl) throws Throwable {
        Iterator iterator = metaTable.iterator();
        IDLookup iDLookup = IDLookup.getIDLookup(richDocument.getMetaForm());
        String string2 = metaTable.getKey();
        String string3 = String.valueOf(string2) + "_NODB";
        while (iterator.hasNext()) {
            MetaColumn metaColumn = (MetaColumn)iterator.next();
            String string4 = metaColumn.getBindingDBColumnName();
            if (!StringUtil.isBlankOrNull((String)string) && string.toUpperCase().contains(string4.toUpperCase()) || !metaColumn.isPersist().booleanValue() && !metaColumn.isSupportI18n().booleanValue()) continue;
            List<Object> list = new ArrayList();
            if (metaColumn.isSupportI18n().booleanValue()) {
                list = iDLookup.getFieldListKeyByTableColumnKey(string3, string4);
                string4 = String.valueOf(string4) + "_NODB";
            } else {
                list = iDLookup.getFieldListKeyByTableColumnKey(string2, string4);
            }
            if (list.isEmpty()) continue;
            for (String string5 : list) {
                if (bl) {
                    richDocument.setValue(string5, n2, dataTable.getObject(n, string4));
                    continue;
                }
                richDocument.setValueNoChanged(string5, n2, dataTable.getObject(n, string4));
            }
        }
    }

    public static void appendOneDtl(DataTable dataTable, DataTable dataTable2, int n) throws Throwable {
        ERPDataTableUtil.appendOneDtl(dataTable, dataTable2, null, n);
    }

    public static void appendOneDtl(DataTable dataTable, DataTable dataTable2) throws Throwable {
        ERPDataTableUtil.appendOneDtl(dataTable, dataTable2, null, dataTable.getRowIndexByBookmark(dataTable.getBookmark()));
    }

    public static void appendOneDtl(DataTable dataTable, DataTable dataTable2, String string, int n) throws Throwable {
        string = "," + string + ",";
        DataTableMetaData dataTableMetaData = dataTable.getMetaData();
        int n2 = dataTableMetaData.getColumnCount();
        int n3 = dataTable2.append();
        int n4 = 0;
        while (n4 < n2) {
            ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(n4);
            String string2 = columnInfo.getColumnKey();
            if (StringUtil.isBlankOrNull((String)string) || !string.toUpperCase().contains("," + string2.toUpperCase() + ",")) {
                if (!dataTable2.getMetaData().constains(string2)) {
                    throw new Exception("\u4e0d\u5b58\u5728" + string2);
                }
                dataTable2.setObject(n3, string2, dataTable.getObject(n, string2));
            }
            ++n4;
        }
    }

    public static void appendAll(DataTable dataTable, DataTable dataTable2) throws Throwable {
        ERPDataTableUtil.appendAll(dataTable, dataTable2, null);
    }

    public static void appendAll(DataTable dataTable, DataTable dataTable2, String string) throws Throwable {
        string = "," + string + ",";
        DataTableMetaData dataTableMetaData = dataTable.getMetaData();
        int n = dataTableMetaData.getColumnCount();
        int n2 = dataTable.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = dataTable2.append();
            int n5 = 0;
            while (n5 < n) {
                ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(n5);
                String string2 = columnInfo.getColumnKey();
                if (!("MapCount".equalsIgnoreCase(string2) || !StringUtil.isBlankOrNull((String)string) && string.toUpperCase().contains("," + string2.toUpperCase() + ","))) {
                    if (!dataTable2.getMetaData().constains(string2)) {
                        throw new Exception("\u4e0d\u5b58\u5728" + string2);
                    }
                    dataTable2.setObject(n4, string2, dataTable.getObject(n3, string2));
                }
                ++n5;
            }
            ++n3;
        }
    }

    public static void appendAllWithoutError(DataTable dataTable, DataTable dataTable2, String string) throws Throwable {
        string = "," + string + ",";
        DataTableMetaData dataTableMetaData = dataTable.getMetaData();
        int n = dataTableMetaData.getColumnCount();
        int n2 = dataTable.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = dataTable2.append();
            int n5 = 0;
            while (n5 < n) {
                ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(n5);
                String string2 = columnInfo.getColumnKey();
                if (!("MapCount".equalsIgnoreCase(string2) || !StringUtil.isBlankOrNull((String)string) && string.toUpperCase().contains("," + string2.toUpperCase() + ","))) {
                    if (!dataTable2.getMetaData().constains(string2)) {
                        LogSvr.getInstance().warn("\u4e0d\u5b58\u5728" + string2);
                    } else {
                        dataTable2.setObject(n4, string2, dataTable.getObject(n3, string2));
                    }
                }
                ++n5;
            }
            ++n3;
        }
    }

    public static DataTable generateDataTable(MetaForm metaForm, String string) throws Throwable {
        if (metaForm.getDataSource().getDataObject() == null || metaForm.getDataSource().getDataObject().getMetaTable(string) == null) {
            throw new Exception("\u8868\u5355:" + metaForm.getKey() + "\u4e2d\u4e0d\u5b58\u5728\u8868\u683c:" + string);
        }
        MetaTable metaTable = metaForm.getDataSource().getDataObject().getMetaTable(string);
        return ERPDataTableUtil.generateDataTable(metaTable);
    }

    public static DataTableMetaData generateDataTableMetaData(MetaTable metaTable) {
        DataTableMetaData dataTableMetaData = dataTableMetaDataCache.get(metaTable);
        if (dataTableMetaData == null) {
            DataTableMetaData dataTableMetaData2 = new DataTableMetaData();
            for (MetaColumn metaColumn : metaTable) {
                String string = metaColumn.getBindingDBColumnName();
                int n = metaColumn.getDataType();
                ColumnInfo columnInfo = new ColumnInfo(string, n);
                columnInfo.setDefaultValue(metaColumn.getDefaultValue());
                columnInfo.setScale(metaColumn.getScale());
                columnInfo.setLength(metaColumn.getLength());
                dataTableMetaData2.addColumn(columnInfo);
            }
            dataTableMetaDataCache.put(metaTable, dataTableMetaData2);
            dataTableMetaData = dataTableMetaData2;
        }
        return dataTableMetaData;
    }

    public static DataTable generateDataTable(MetaTable metaTable) {
        DataTable dataTable = new DataTable(ERPDataTableUtil.generateDataTableMetaData(metaTable));
        dataTable.setKey(metaTable.getKey());
        return dataTable;
    }

    public static String createQueryItemsString(MetaTable metaTable, IDBManager iDBManager) {
        StringBuilder stringBuilder = new StringBuilder();
        for (MetaColumn metaColumn : metaTable) {
            if (!metaColumn.isPersist().booleanValue()) continue;
            String string = metaColumn.getBindingDBColumnName();
            stringBuilder.append(iDBManager.keyWordEscape(string)).append(",");
        }
        if (stringBuilder.length() == 0) {
            return "";
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }
}

