/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.schema;

import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.expression.MySQLIndexHint;
import net.boke.jsqlparser.expression.SQLServerHints;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.FromItemVisitor;
import net.boke.jsqlparser.statement.select.IntoTableVisitor;
import net.boke.jsqlparser.statement.select.Join;

public class Table
extends AbstractSqlElement
implements FromItem {
    private String schemaName;
    private String name;
    private String alias;
    private Join join;
    private MySQLIndexHint mysqlHints;
    private SQLServerHints sqlServerHints;
    private char keyWordEscapeStart = '\u0000';
    private char keyWordEscapeEnd = '\u0000';
    private Boolean isNotInOrExist = null;

    public Table() {
    }

    public Table(String schemaName, String name) {
        if (schemaName != null) {
            this.schemaName = schemaName.intern();
        }
        this.setNameWithKeyWordEscape(name);
    }

    private void setNameWithKeyWordEscape(String name) {
        char end;
        char first;
        int length;
        int n = length = name == null ? 0 : name.length();
        if (!(length <= 2 || (first = name.charAt(0)) != '`' && first != '[' && first != '\"' || (end = name.charAt(length - 1)) != '`' && end != ']' && end != '\"')) {
            this.keyWordEscapeStart = first;
            this.keyWordEscapeEnd = end;
            name = name.substring(1, length - 1);
        }
        if (name != null) {
            name = name.intern();
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setName(String string) {
        this.setNameWithKeyWordEscape(string);
    }

    public void setSchemaName(String string) {
        this.schemaName = string.intern();
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public String getAliasName() {
        return this.alias == null ? this.name : this.alias;
    }

    @Override
    public void setAlias(String string) {
        this.alias = string.intern();
    }

    public String getWholeTableName() {
        String tableWholeName = null;
        if (this.name == null) {
            return null;
        }
        if (this.schemaName != null || this.keyWordEscapeStart > '\u0000') {
            StringBuilder sb = new StringBuilder(60);
            if (this.schemaName != null) {
                sb.append(this.schemaName).append(".");
            }
            if (this.keyWordEscapeStart != '\u0000') {
                sb.append(this.keyWordEscapeStart);
            }
            sb.append(this.name);
            if (this.keyWordEscapeEnd != '\u0000') {
                sb.append(this.keyWordEscapeEnd);
            }
            tableWholeName = sb.toString();
        } else {
            tableWholeName = this.name;
        }
        return tableWholeName;
    }

    @Override
    public void accept(FromItemVisitor fromItemVisitor) {
        fromItemVisitor.visit(this);
    }

    public void accept(IntoTableVisitor intoTableVisitor) {
        intoTableVisitor.visit(this);
    }

    @Override
    public void setJoin(Join join) {
        this.join = join;
    }

    public MySQLIndexHint getIndexHint() {
        return this.mysqlHints;
    }

    public Table withHint(MySQLIndexHint hint) {
        this.setHint(hint);
        return this;
    }

    public void setHint(MySQLIndexHint hint) {
        this.mysqlHints = hint;
    }

    public SQLServerHints getSqlServerHints() {
        return this.sqlServerHints;
    }

    public void setSqlServerHints(SQLServerHints sqlServerHints) {
        this.sqlServerHints = sqlServerHints;
    }

    public Boolean getIsNotInOrExist() {
        return this.isNotInOrExist;
    }

    public void setIsNotInOrExist(Boolean isNotInOrExist) {
        this.isNotInOrExist = isNotInOrExist;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this.toString().equalsIgnoreCase(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getWholeTableName()) + (this.alias != null ? " " + this.alias : "");
    }
}

