/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.query.util;

import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.common.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.boke.jsqlparser.base.ISqlElement;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.CaseExpression;
import net.boke.jsqlparser.expression.DateValue;
import net.boke.jsqlparser.expression.DoubleValue;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.InverseExpression;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.WhenClause;
import net.boke.jsqlparser.expression.operators.arithmetic.Addition;
import net.boke.jsqlparser.expression.operators.arithmetic.Division;
import net.boke.jsqlparser.expression.operators.arithmetic.Modulo;
import net.boke.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.boke.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.query.source.AbstractQuerySource;
import net.boke.jsqlparser.query.source.type.EJoinOnType;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.AllTableColumns;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SelectItem;
import net.boke.jsqlparser.statement.select.SubSelect;

public class SourceHelperUtil {
    public static final String STR_TMPONLYONEROW = "TmpOnlyOneRow";
    public static final String STR_FUN_SUM = "sum";
    public static final String STR_FUN_MAX = "max";
    public static final String STR_FUN_MIN = "min";
    public static final String STR_FUN_COUNT = "count";
    public static final String STR_FUN_COALESCE = "coalesce";
    public static final String STR_FUN_IFNULL = "ifnull";
    public static final String STR_FUN_CONCAT = "concat";
    public static final String STR_FUN_AVG = "avg";
    public static final String STR_FUN_GROUP_CONCAT = "group_concat";
    public static final String STR_FUN_DATEDIFF = "datediff";
    public static final String STR_FUN_DATEFORMAT = "date_format";

    public static List<Column> getLinkedColumns(ISqlElement expression) {
        if (expression == null) {
            return Collections.emptyList();
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        expression.traversal(element -> {
            if (element instanceof SubSelect) {
                return false;
            }
            if (element instanceof Column) {
                columns.add((Column)element);
            }
            return true;
        });
        return columns;
    }

    public static boolean matchAllLinkedColumns(AbstractQuerySource<?> querySource, ISqlElement expression) {
        if (querySource == null) {
            return false;
        }
        List<Column> linkedColumns = SourceHelperUtil.getLinkedColumns(expression);
        for (Column column : linkedColumns) {
            if (querySource.isResultColumn(column)) continue;
            return false;
        }
        return true;
    }

    public static boolean containElement(Expression expression, ISqlElement elem) {
        if (expression == null) {
            return false;
        }
        RefObject refContain = new RefObject((Object)false);
        expression.traversal(element -> {
            if (element instanceof SubSelect) {
                return false;
            }
            if (elem == element) {
                refContain.setValue((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)refContain.getValue();
    }

    public static List<Column> getLinkedColumns(List list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Object item : list) {
            ((ISqlElement)item).traversal(element -> {
                if (element instanceof Column) {
                    columns.add((Column)element);
                }
                return true;
            });
        }
        return columns;
    }

    public static boolean containElement(List list, ISqlElement elem) {
        if (list == null) {
            return false;
        }
        RefObject refContain = new RefObject((Object)false);
        for (Object item : list) {
            ((ISqlElement)item).traversal(element -> {
                if (elem == element) {
                    refContain.setValue((Object)true);
                    return false;
                }
                return true;
            });
        }
        return (Boolean)refContain.getValue();
    }

    public static int getCalcItemDataType(ISqlElement exp) throws SQLException {
        Column column;
        if (exp == null) {
            return 0;
        }
        if (exp instanceof SelectExpressionItem) {
            return SourceHelperUtil.getCalcItemDataType(((SelectExpressionItem)exp).getExpression());
        }
        if (exp instanceof LongValue) {
            return 1010;
        }
        if (exp instanceof DoubleValue) {
            return 1005;
        }
        if (exp instanceof StringValue) {
            return 1002;
        }
        if (exp instanceof DateValue) {
            return 1003;
        }
        if (exp instanceof Parenthesis) {
            return SourceHelperUtil.getCalcItemDataType(((Parenthesis)exp).getExpression());
        }
        if (exp instanceof Addition || exp instanceof Subtraction || exp instanceof Multiplication || exp instanceof Modulo) {
            int leftDataType = SourceHelperUtil.getCalcItemDataType(((BinaryExpression)exp).getLeftExpression());
            int rightDataType = SourceHelperUtil.getCalcItemDataType(((BinaryExpression)exp).getRightExpression());
            if (leftDataType == 1002 || rightDataType == 1002) {
                return 1002;
            }
            if (leftDataType == 1005 || rightDataType == 1005) {
                return 1005;
            }
            if (leftDataType == 1003 || rightDataType == 1003) {
                return 1003;
            }
            if (leftDataType != rightDataType) {
                return Math.max(leftDataType, rightDataType);
            }
            return leftDataType;
        }
        if (exp instanceof Division) {
            return 1005;
        }
        if (exp instanceof EqualsTo || exp instanceof NotEqualsTo || exp instanceof GreaterThan || exp instanceof GreaterThanEquals || exp instanceof MinorThan || exp instanceof MinorThanEquals) {
            return 1009;
        }
        if (exp instanceof CaseExpression) {
            CaseExpression caseExpression = (CaseExpression)exp;
            Expression elseExpression = caseExpression.getElseExpression();
            int elseType = SourceHelperUtil.getCalcItemDataType(elseExpression);
            List whenClauses = ((CaseExpression)exp).getWhenClauses();
            ArrayList<Integer> list = new ArrayList<Integer>(whenClauses.size());
            for (WhenClause when : whenClauses) {
                list.add(SourceHelperUtil.getCalcItemDataType(when));
            }
            list.add(elseType);
            int ret = 0;
            boolean hasString = false;
            boolean hasNum = false;
            boolean hasDate = false;
            boolean hasBool = false;
            boolean hasLong = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                ret = i != 0 ? i : ret;
                switch (i) {
                    case 1002: {
                        hasString = true;
                        break;
                    }
                    case 1005: {
                        hasNum = true;
                        break;
                    }
                    case 1003: {
                        hasDate = true;
                        break;
                    }
                    case 1009: {
                        hasBool = true;
                        break;
                    }
                    case 1010: {
                        hasLong = true;
                        break;
                    }
                }
            }
            if (hasLong && hasNum) {
                ret = 1005;
            }
            return ret;
        }
        if (exp instanceof WhenClause) {
            return SourceHelperUtil.getCalcItemDataType(((WhenClause)exp).getThenExpression());
        }
        if (exp instanceof Function) {
            Function fun = (Function)exp;
            String functionName = fun.getName();
            if (functionName.equalsIgnoreCase(STR_FUN_DATEDIFF)) {
                return 1010;
            }
            if (functionName.equalsIgnoreCase(STR_FUN_CONCAT) || functionName.equalsIgnoreCase(STR_FUN_DATEFORMAT)) {
                return 1002;
            }
            if (STR_FUN_COUNT.equalsIgnoreCase(functionName)) {
                return 1001;
            }
            if (STR_FUN_SUM.equalsIgnoreCase(functionName)) {
                return 1005;
            }
            if (STR_FUN_IFNULL.equalsIgnoreCase(functionName)) {
                int firstParameterType = SourceHelperUtil.getCalcItemDataType((Expression)fun.getParameters().getExpressions().get(0));
                if (firstParameterType > 0) {
                    return firstParameterType;
                }
                return SourceHelperUtil.getCalcItemDataType((Expression)fun.getParameters().getExpressions().get(1));
            }
            if (STR_FUN_COALESCE.equalsIgnoreCase(functionName)) {
                return SourceHelperUtil.getCalcItemDataType((Expression)fun.getParameters().getExpressions().get(0));
            }
            if (fun.getParameters() == null) {
                return 0;
            }
            int i = 0;
            int size = fun.getParameters().getExpressions().size();
            while (i < size) {
                int calcItemDataType = SourceHelperUtil.getCalcItemDataType((Expression)fun.getParameters().getExpressions().get(i));
                if (calcItemDataType > 0) {
                    return calcItemDataType;
                }
                ++i;
            }
            return 0;
        }
        if (exp instanceof InverseExpression) {
            return SourceHelperUtil.getCalcItemDataType(((InverseExpression)exp).getExpression());
        }
        if (exp instanceof Column && (column = (Column)exp).getQuerySource() != null) {
            return column.getQuerySource().getField(column.getColumnName()).getDataType();
        }
        throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u672a\u652f\u6301\u7684\u8ba1\u7b97\u8868\u8fbe\u5f0f\uff0c" + exp + "\u3002");
    }

    public static Object getFirstSelectItem(PlainSelect plainSelect) {
        return plainSelect.getSelectItems().get(0);
    }

    public static boolean matchSelectItemByColumnName(String columnName, SelectExpressionItem selectItem) {
        Column tempColumn;
        if (selectItem.getExpression() instanceof Column && ((tempColumn = (Column)selectItem.getExpression()).getTable() == null || tempColumn.getTable().getAliasName() == null) && columnName.equalsIgnoreCase(tempColumn.getColumnName())) {
            return true;
        }
        if (!StringUtil.isBlankOrNull((String)selectItem.getAlias())) {
            return columnName.equalsIgnoreCase(selectItem.getAlias());
        }
        return selectItem.getExpression() instanceof Column && columnName.equalsIgnoreCase(((Column)selectItem.getExpression()).getColumnName());
    }

    public static FromItem getFromItemSelectItem(SelectItem selectItem) {
        AllTableColumns items;
        AbstractQuerySource<?> source;
        if (selectItem instanceof SelectExpressionItem) {
            SelectExpressionItem selectExpItem = (SelectExpressionItem)selectItem;
            if (selectExpItem.getExpression() instanceof Column) {
                Column tempColumn = (Column)selectExpItem.getExpression();
                return (FromItem)tempColumn.getQuerySource().getSqlItem();
            }
        } else if (selectItem instanceof AllTableColumns && (source = (items = (AllTableColumns)selectItem).getQuerySource().getSourceByTableAlias(items.getTable().getAliasName())) != null) {
            return (FromItem)source.getSqlItem();
        }
        return null;
    }

    public static boolean isSelectItemFromTable(SelectItem selectItem) {
        if (selectItem instanceof SelectExpressionItem) {
            SelectExpressionItem selectExpItem = (SelectExpressionItem)selectItem;
            if (selectExpItem.getExpression() instanceof Column) {
                Column tempColumn = (Column)selectExpItem.getExpression();
                return tempColumn.getQuerySource().isTable();
            }
        } else if (selectItem instanceof AllTableColumns) {
            AllTableColumns items = (AllTableColumns)selectItem;
            AbstractQuerySource<?> source = items.getQuerySource().getSourceByTableAlias(items.getTable().getAliasName());
            return source.isTable();
        }
        return false;
    }

    public static EJoinOnType getJoinOnType(Join join) {
        if (join.isNatural()) {
            if (join.isLeft()) {
                return EJoinOnType.NaturalLeft;
            }
            if (join.isRight()) {
                return EJoinOnType.NaturalRight;
            }
            if (join.isInner()) {
                return EJoinOnType.NaturalInner;
            }
        } else {
            if (join.isOuter()) {
                return join.isFull() ? EJoinOnType.FullOuter : EJoinOnType.Outer;
            }
            if (join.isInner()) {
                return EJoinOnType.Inner;
            }
            if (join.isLeft()) {
                return EJoinOnType.Left;
            }
            if (join.isRight()) {
                return EJoinOnType.Right;
            }
        }
        return EJoinOnType.UnDefined;
    }
}

