/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.base.IElementVisitor;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.PlainSelect;

public class Function
extends AbstractSqlElement
implements Expression {
    private String name;
    private ExpressionList parameters;
    private boolean allColumns = false;
    private boolean distinct = false;
    private boolean isEscaped = false;
    private ExpressionList orderByList;
    private String separator;

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public boolean needGroupBy(PlainSelect plainSelect) {
        switch (this.name.toLowerCase()) {
            case "max": 
            case "min": 
            case "sum": 
            case "count": {
                return true;
            }
        }
        if (this.parameters != null) {
            List exps = this.parameters.getExpressions();
            for (Object exp : exps) {
                if (!(exp instanceof Function)) continue;
                Function subFunction = (Function)exp;
                return subFunction.needGroupBy(plainSelect);
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.intern();
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean b) {
        this.allColumns = b;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public ExpressionList getParameters() {
        return this.parameters;
    }

    public void setParameters(ExpressionList list) {
        this.parameters = list;
    }

    public boolean isEscaped() {
        return this.isEscaped;
    }

    public void setEscaped(boolean isEscaped) {
        this.isEscaped = isEscaped;
    }

    public void setOrderByList(ExpressionList orderByList) {
        this.orderByList = orderByList;
    }

    public ExpressionList getOrderByList() {
        return this.orderByList;
    }

    public void setSeparator(String separator) {
        this.separator = separator.intern();
    }

    public String getSeparator() {
        return this.separator;
    }

    public List<Column> getColumns() {
        if (this.getParameters() == null || this.getParameters().getExpressions() == null) {
            return Collections.emptyList();
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Object exp : this.getParameters().getExpressions()) {
            if (!(exp instanceof Column)) continue;
            columns.add((Column)exp);
        }
        return columns;
    }

    public Column getFirstColumn() {
        List<Column> columns = this.getColumns();
        if (columns.size() == 0) {
            return null;
        }
        return columns.get(0);
    }

    public String toString() {
        StringBuilder params = new StringBuilder(30);
        if (this.allColumns) {
            params = params.append("*");
        } else if (this.parameters != null) {
            if (this.isDistinct()) {
                params = params.append("DISTINCT ");
            }
            params = params.append(PlainSelect.getStringList(this.parameters.getExpressions(), true, false));
            if (this.orderByList != null) {
                params.append(" ORDER BY ");
                params.append(PlainSelect.getStringList(this.orderByList.getExpressions(), true, false));
            }
            if (this.separator != null) {
                params.append(" SEPARATOR ").append(this.separator);
            }
        }
        StringBuilder ans = new StringBuilder(30).append(this.name).append("(").append((CharSequence)params).append(")");
        if (this.isEscaped) {
            ans.append("{fn ").append((CharSequence)ans).append("}");
        }
        return ans.toString();
    }

    @Override
    public void traversalChildren(IElementVisitor sqlElementVisitor) {
        if (this.parameters != null) {
            this.parameters.traversal(sqlElementVisitor);
        }
        if (this.orderByList != null) {
            this.orderByList.traversal(sqlElementVisitor);
        }
    }
}

