/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.parameterizedsql;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.parser.ICustomObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;

public class SqlString
implements ICustomObject {
    private static final String Blank = " ";
    private static final String SQLPara = " ? ";
    public static final SqlString SqlString_Null = new SqlString();
    StringBuilder sql;
    StringBuilder completeSql;
    List<Object> parameters;
    protected boolean isFinalResult = false;

    public SqlString() {
        this(256);
    }

    public SqlString(int length) {
        this.sql = new StringBuilder(length);
        this.completeSql = new StringBuilder(length);
    }

    public void setFinalResult() {
        this.isFinalResult = true;
    }

    public List<Object> getParameterList() {
        return this.parameters;
    }

    public List<Object> getParameterListNotNull() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Object>();
        }
        return this.parameters;
    }

    public SqlString append(Object ... objs) {
        SqlString result = this.isFinalResult ? this.deepClone() : this;
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null) {
                SqlString other;
                if (obj instanceof SqlString) {
                    other = (SqlString)obj;
                    result.sql.append((CharSequence)other.sql);
                    result.completeSql.append((CharSequence)other.completeSql);
                    if (other.parameters != null) {
                        result.getParameterListNotNull().addAll(other.parameters);
                    }
                } else if (obj instanceof PrepareSQL) {
                    other = (PrepareSQL)obj;
                    result.sql.append(other.getSQL());
                    result.completeSql.append(other.getSQL());
                    List prepareValues = other.getPrepareValues();
                    if (prepareValues.size() > 0) {
                        result.getParameterListNotNull().addAll(prepareValues);
                    }
                } else {
                    result.sql.append(obj);
                    result.completeSql.append(obj);
                }
            }
            ++n2;
        }
        return result;
    }

    public static SqlString sqlPara(Object para) {
        if ("".equals(para)) {
            para = "  ";
        }
        SqlString result = new SqlString(2);
        result.sql.append(SQLPara);
        result.completeSql.append(Blank);
        result.completeSql.append(para);
        result.parameters = new ArrayList<Object>(1);
        result.parameters.add(para);
        return result;
    }

    public SqlString appendPara(Object value) {
        if ("".equals(value)) {
            value = "  ";
        }
        this.sql.append(SQLPara);
        this.completeSql.append(Blank);
        this.completeSql.append(value);
        this.getParameterListNotNull().add(value);
        return this;
    }

    public static SqlString sqlLikePara(Object para, String left, String right) {
        Object escapedValue;
        if ("".equals(para)) {
            para = "  ";
        }
        boolean isChange = (escapedValue = SqlString.escapeLikeValue(para)) == null ? false : !escapedValue.equals(para);
        SqlString result = new SqlString(2);
        result.sql.append("?").append(isChange ? " escape '\\\\' " : "");
        result.completeSql.append(left).append(escapedValue).append(right).append(isChange ? " escape '\\\\' " : "");
        result.parameters = new ArrayList<Object>(1);
        result.parameters.add(String.valueOf(left) + escapedValue + right);
        return result;
    }

    public SqlString appendLikePara(Object value, String left, String right) {
        Object escapedValue;
        if ("".equals(value)) {
            value = "  ";
        }
        boolean isChange = (escapedValue = SqlString.escapeLikeValue(value)) == null ? false : !escapedValue.equals(value);
        this.sql.append("?").append(isChange ? " escape '\\\\' " : "");
        this.completeSql.append(left).append(escapedValue).append(right).append(isChange ? " escape '\\\\' " : "");
        this.getParameterListNotNull().add(String.valueOf(left) + escapedValue + right);
        return this;
    }

    private static Object escapeLikeValue(Object value) {
        if (value == null || !(value instanceof String)) {
            return value;
        }
        String stringValue = value.toString();
        if (!(stringValue.contains("%") || stringValue.contains("_") || stringValue.contains("\\"))) {
            return value;
        }
        String temp = StringUtil.replaceAll((String)stringValue, (String)"\\", (String)"\\\\");
        temp = StringUtil.replaceAll((String)temp, (String)"%", (String)"\\%");
        temp = StringUtil.replaceAll((String)temp, (String)"_", (String)"\\_");
        return temp;
    }

    public String getSql() {
        return this.sql.toString();
    }

    public String getCompleteSql() {
        return this.completeSql.toString();
    }

    public Object[] getParameters() {
        if (this.parameters == null) {
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        return this.parameters.toArray(ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public static SqlString format(Object object, Object ... args) {
        if (object == null) {
            throw new RuntimeException("sql\u4e3a\u7a7a");
        }
        if (args == null || args.length == 0) {
            return new SqlString().append(object);
        }
        String stringFormat = null;
        List<Object> parameterList = null;
        int parameterIndex = 0;
        boolean isSqlString = false;
        if (object instanceof SqlString) {
            SqlString temp = (SqlString)object;
            stringFormat = temp.getSql();
            parameterList = temp.getParameterList();
            isSqlString = true;
        } else if (object instanceof String) {
            stringFormat = (String)object;
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
        int argIndex = 0;
        SqlString sqlString = new SqlString();
        int i = 0;
        while (i < stringFormat.length()) {
            if (stringFormat.charAt(i) == '%' && i < stringFormat.length() - 1) {
                if (stringFormat.charAt(i + 1) == 's' || stringFormat.charAt(i + 1) == 'S') {
                    sqlString.append(args[argIndex++]);
                    ++i;
                } else if (stringFormat.charAt(i + 1) == '?') {
                    sqlString.appendPara(args[argIndex++]);
                    ++i;
                } else {
                    sqlString.append(Character.valueOf(stringFormat.charAt(i)));
                }
            } else if (stringFormat.charAt(i) == '?' && isSqlString) {
                sqlString.appendPara(parameterList.get(parameterIndex++));
            } else {
                sqlString.append(Character.valueOf(stringFormat.charAt(i)));
            }
            ++i;
        }
        if (argIndex < args.length || parameterList != null && parameterIndex < parameterList.size()) {
            throw new RuntimeException("format\u53c2\u6570\u5f02\u5e38:\n" + sqlString.getSql() + " args length : " + args.length + "\n" + args.toString() + (parameterList == null ? "parameters is null" : "parameters length:" + parameterList.size() + "\n" + parameterList.toString()));
        }
        return sqlString;
    }

    public SqlString insertBefore(Object obj) {
        SqlString result;
        SqlString sqlString = result = this.isFinalResult ? this.clone() : this;
        if (obj == null) {
            return null;
        }
        if (obj instanceof SqlString) {
            SqlString other = (SqlString)obj;
            result.sql.insert(0, other.sql);
            result.completeSql.insert(0, other.completeSql);
            if (other.parameters != null) {
                result.parameters.addAll(0, other.parameters);
            }
        } else {
            result.sql.insert(0, obj);
            result.completeSql.insert(0, obj);
        }
        return result;
    }

    public SqlString deleteLeft(int length) {
        this.sql.delete(0, length);
        this.completeSql.delete(0, length);
        return this;
    }

    public SqlString deleteRight(int length) {
        int orgLength = this.sql.length();
        this.sql.delete(orgLength - length, orgLength);
        orgLength = this.completeSql.length();
        this.completeSql.delete(orgLength - length, orgLength);
        return this;
    }

    public int length() {
        return this.sql.length();
    }

    public SqlString subString(int beginIndex) {
        return this.subString(beginIndex, this.sql.length());
    }

    public SqlString subString(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("SqlString index out of range: " + beginIndex);
        }
        String str = this.sql.toString();
        if (beginIndex + endIndex > this.sql.length()) {
            str = str.substring(beginIndex);
            this.sql = new StringBuilder(str.length()).append(str);
            return this;
        }
        str = str.substring(beginIndex, beginIndex + endIndex);
        this.sql = new StringBuilder(str.length()).append(str);
        return this;
    }

    public Object leftDiv(Object arg0) {
        throw new NotImplementedException("Code is not implemented");
    }

    public Object leftMul(Object arg0) {
        throw new NotImplementedException("Code is not implemented");
    }

    public Object leftPlus(Object arg0) {
        return this.append(arg0);
    }

    public Object leftStrcat(Object arg0) {
        return this.append(arg0);
    }

    public Object leftSub(Object arg0) {
        throw new NotImplementedException("Code is not implemented");
    }

    public Object rightDiv(Object arg0) {
        throw new NotImplementedException("Code is not implemented");
    }

    public Object rightMul(Object arg0) {
        throw new NotImplementedException("Code is not implemented");
    }

    public Object rightPlus(Object arg0) {
        return this.insertBefore(arg0);
    }

    public Object rightStrcat(Object arg0) {
        return this.insertBefore(arg0);
    }

    public Object rightSub(Object arg0) {
        throw new NotImplementedException("Code is not implemented");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024).append(this.sql.toString());
        if (this.parameters != null) {
            sb.append(Blank);
            sb.append(this.parameters.toString());
        }
        return sb.toString();
    }

    public String completeSqltoString() {
        StringBuilder sb = new StringBuilder(1024).append("\u5b8c\u6574Sql\uff1a").append(this.completeSql.toString());
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.sql.length() == 0;
    }

    public boolean contains(CharSequence s) {
        return this.indexOf(s.toString()) > -1;
    }

    public int indexOf(String str) {
        return this.sql.toString().indexOf(str);
    }

    public SqlString clone() {
        SqlString newInstance = new SqlString();
        newInstance.sql.append(this.sql.toString());
        newInstance.completeSql.append(this.completeSql.toString());
        if (this.parameters != null) {
            newInstance.parameters = new ArrayList<Object>();
            newInstance.parameters.addAll(this.parameters);
        }
        return newInstance;
    }

    public SqlString deepClone() {
        SqlString newInstance = new SqlString();
        newInstance.sql.append(this.sql.toString());
        newInstance.completeSql.append(this.completeSql.toString());
        newInstance.isFinalResult = this.isFinalResult;
        if (this.parameters != null) {
            newInstance.parameters = new ArrayList<Object>();
            newInstance.parameters.addAll(this.parameters);
        }
        return newInstance;
    }

    public SqlString replaceAll(String oldStr, String newStr) {
        StringBuilder stringBuilder = this.sql;
        if (stringBuilder == null || oldStr == null || newStr == null || stringBuilder.length() == 0 || oldStr.length() == 0) {
            return this;
        }
        int index = stringBuilder.indexOf(oldStr);
        if (index > -1 && !oldStr.equals(newStr)) {
            int lastIndex = 0;
            while (index > -1) {
                stringBuilder.replace(index, index + oldStr.length(), newStr);
                lastIndex = index + newStr.length();
                index = stringBuilder.indexOf(oldStr, lastIndex);
            }
        }
        this.sql = stringBuilder;
        this.completeSql = new StringBuilder(stringBuilder);
        return this;
    }
}

