/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.sql;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.LRUCacheNew;
import com.bokesoft.yes.mid.mysqls.sql.DeleteSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.InsertSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.UpdateSqlInfo;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.setting.MetaSimpleSetting;
import net.boke.jsqlparser.JSQLParserException;
import net.boke.jsqlparser.parser.CCJSqlParserManager;
import net.boke.jsqlparser.query.extend.ParseHelper;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.delete.Delete;
import net.boke.jsqlparser.statement.insert.Insert;
import net.boke.jsqlparser.statement.select.AllColumns;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.statement.update.Update;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlInfos {
    private static final Logger logger = LoggerFactory.getLogger(SqlInfos.class);
    private int cacheSize = 5000;
    private LRUCacheNew<String, SqlInfo> datas = null;
    public static final SqlInfos instance = new SqlInfos();
    private LRUCacheNew<String, Object> sqlStatementsCache = new LRUCacheNew(this.cacheSize);

    private SqlInfos() {
        MetaSimpleSetting cacheSettings;
        IMetaFactory factory = MetaFactory.getGlobalInstance();
        if (factory != null && (cacheSettings = factory.getSetting().getSimpleSetting("SqlInfosCache")) != null && cacheSettings.get("Size") != null) {
            this.cacheSize = TypeConvertor.toInteger((Object)cacheSettings.get("Size"));
        }
        this.datas = new LRUCacheNew(this.cacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlInfo getSqlInfo(String sql) {
        SqlInfo result = (SqlInfo)this.datas.get((Object)sql);
        if (result == null) {
            SqlInfos sqlInfos = instance;
            synchronized (sqlInfos) {
                result = (SqlInfo)this.datas.get((Object)sql);
                if (result == null) {
                    int action = Performance.startAction((Object[])new Object[]{"createSqlInfo:", sql});
                    result = this.createSqlInfo(sql);
                    Performance.endActive((int)action, (Object[])new Object[0]);
                    this.datas.put((Object)sql, (Object)result);
                }
            }
        }
        return result;
    }

    public void remove(String sql) {
        if (this.sqlStatementsCache != null) {
            this.sqlStatementsCache.remove((Object)sql);
        }
        if (this.datas != null) {
            this.datas.remove((Object)sql);
        }
    }

    public void clearData() {
        this.datas.clear();
        this.sqlStatementsCache.clear();
    }

    public Statement parseSql(String sql) throws JSQLParserException {
        Statement statement;
        Object obj = this.sqlStatementsCache.get((Object)sql);
        if (obj == null) {
            CCJSqlParserManager parser = new CCJSqlParserManager();
            try {
                statement = parser.parse(sql);
            }
            catch (JSQLParserException e) {
                logger.warn("SQL\u8bed\u53e5\u65e0\u6cd5\u89e3\u6790\uff1a{}", (Object)sql);
                this.sqlStatementsCache.put((Object)sql, (Object)e);
                throw e;
            }
            this.sqlStatementsCache.put((Object)sql, (Object)statement);
        } else {
            if (obj instanceof JSQLParserException) {
                throw (JSQLParserException)obj;
            }
            statement = (Statement)obj;
        }
        return statement;
    }

    public Statement reparseSql(String sql) throws JSQLParserException {
        Statement statement;
        CCJSqlParserManager parser = new CCJSqlParserManager();
        try {
            statement = parser.parse(sql);
        }
        catch (JSQLParserException e) {
            this.sqlStatementsCache.put((Object)sql, (Object)e);
            throw e;
        }
        this.sqlStatementsCache.put((Object)sql, (Object)statement);
        return statement;
    }

    private SqlInfo createSqlInfo(String sql) {
        Statement statement = null;
        try {
            statement = this.parseSql(sql);
        }
        catch (JSQLParserException e) {
            throw new RuntimeException("SQL\u8bed\u53e5\u89e3\u6790\u5931\u8d25\uff1a" + sql, e);
        }
        return this.createSqlInfo(sql, statement);
    }

    private SqlInfo createSqlInfo(String sql, Statement statement) {
        SqlInfo result;
        if (statement instanceof Select) {
            FromItem fromItem;
            PlainSelect plainSelect;
            SelectBody selectBody = ((Select)statement).getSelectBody();
            if (selectBody instanceof PlainSelect && (plainSelect = (PlainSelect)selectBody).getSelectItems().size() == 1 && plainSelect.getSelectItems().get(0) instanceof AllColumns && plainSelect.getWhere() == null && plainSelect.getOrderByElements() == null && plainSelect.getLimit() == null && (fromItem = plainSelect.getFromItem()) instanceof SubSelect) {
                statement = new Select();
                ((Select)statement).setSelectBody(((SubSelect)fromItem).getSelectBody());
            }
            result = ParseHelper.createSelectInfo(sql, (Select)statement);
        } else if (statement instanceof Insert) {
            result = new InsertSqlInfo(sql, (Insert)statement);
        } else if (statement instanceof Update) {
            result = new UpdateSqlInfo(sql, (Update)statement);
        } else if (statement instanceof Delete) {
            result = new DeleteSqlInfo(sql, (Delete)statement);
        } else {
            throw new RuntimeException("\u76ee\u524d\u53ea\u652f\u6301select/insert/update/delete/truncate\u8bed\u53e5\uff0c" + sql + "\u4e0d\u652f\u6301\u3002");
        }
        return result;
    }

    public int getJDBCParameterCount(String sql) {
        SqlInfo sqlInfo = (SqlInfo)this.datas.get((Object)sql);
        if (sqlInfo == null) {
            return StringUtils.countMatches((CharSequence)sql, (char)'?');
        }
        return sqlInfo.getJDBCParameterCount();
    }

    public static void main(String[] args) throws Throwable {
        CCJSqlParserManager parser = new CCJSqlParserManager();
        logger.info(TypeConvertor.toString((Object)parser.parse("select * from a where (a, b) in (1, 1)")));
        logger.info(TypeConvertor.toString((Object)parser.parse("select * from a where (a, b) in ((1, 1), (2, 2))")));
        logger.info(TypeConvertor.toString((Object)parser.parse("select * from a where (a, b) in (select c, d from e)")));
        logger.info(TypeConvertor.toString((Object)parser.parse("insert into a (a, b) values (1, 1)")));
        logger.info(TypeConvertor.toString((Object)parser.parse("insert into a (a, b) values (1, 1), (2, 2)")));
    }
}

