/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.route.service.convert.finals.map;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingFieldRelation;
import com.bokesoft.yes.mid.mysqls.route.service.convert.finals.map.IGroupValueMap;
import com.bokesoft.yes.mid.mysqls.route.service.convert.finals.map.impl.DateToYearMap;
import com.bokesoft.yes.mid.mysqls.route.service.convert.finals.map.impl.NormalMap;
import com.bokesoft.yes.mid.mysqls.route.service.convert.finals.map.impl.PeriodToYearMap;
import com.bokesoft.yes.mid.mysqls.route.service.convert.finals.map.loader.RelationSqlLoader;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.Collection;

public class GroupValueMapManager {
    private static final GroupValueMapManager instance = new GroupValueMapManager();
    private final HashMapIgnoreCase<IGroupValueMap> groupValueMap = new HashMapIgnoreCase();

    private GroupValueMapManager() {
    }

    public void init(Collection<MetaShardingFieldRelation> groupFieldRelations, IDBManager dbManager) throws Throwable {
        for (MetaShardingFieldRelation groupFieldRelation : groupFieldRelations) {
            String groupFieldKey = groupFieldRelation.getSourceFieldKey();
            switch (groupFieldRelation.getSourceGorupType()) {
                case DICT: 
                case STRING: {
                    NormalMap relationMap = new NormalMap();
                    RelationSqlLoader.load(groupFieldRelation.getRelation(), relationMap, dbManager);
                    this.groupValueMap.put(groupFieldKey, (Object)relationMap);
                    break;
                }
                case PERIOD: {
                    this.groupValueMap.put(groupFieldKey, (Object)new PeriodToYearMap());
                    break;
                }
                case DATE: {
                    this.groupValueMap.put(groupFieldKey, (Object)new DateToYearMap());
                    break;
                }
            }
        }
    }

    public void addGroupValueMap(String groupFieldKey, IGroupValueMap groupValueMap) {
        this.groupValueMap.put(groupFieldKey, (Object)groupValueMap);
    }

    public IGroupValueMap getGroupValueMap(String groupFieldKey) {
        return (IGroupValueMap)this.groupValueMap.get(groupFieldKey);
    }

    public static GroupValueMapManager getInstance() {
        return instance;
    }
}

