/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.route.meta;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingFieldRelation;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingGroup;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingGroupField;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingTable;
import com.bokesoft.yes.mid.mysqls.route.meta.type.EGroupFieldType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class ShardingMetaConfig {
    private static final ShardingMetaConfig instance = new ShardingMetaConfig();
    private final HashMap<String, MetaShardingGroup> mapRouteGroupConfigs;
    private HashSet<String> finalGroupFieldKeys = new HashSet();
    private final HashMapIgnoreCase<MetaShardingGroupField> mapRouteGroupFields;
    private final HashMapIgnoreCase<MetaShardingFieldRelation> mapRouteGroupFieldRelations;

    private ShardingMetaConfig() {
        this.mapRouteGroupConfigs = new HashMap();
        this.mapRouteGroupFields = new HashMapIgnoreCase();
        this.mapRouteGroupFieldRelations = new HashMapIgnoreCase();
    }

    public void clearAll() {
        this.finalGroupFieldKeys.clear();
        this.mapRouteGroupConfigs.clear();
        this.mapRouteGroupFields.clear();
        this.mapRouteGroupFieldRelations.clear();
    }

    public MetaShardingGroup getGroupByTableName(String tableName) {
        for (MetaShardingGroup groupConfig : this.getGroupConfigs()) {
            if (!groupConfig.containsTable(tableName)) continue;
            return groupConfig;
        }
        return null;
    }

    public String getGroupKeyByTableName(String tableName) {
        for (MetaShardingGroup groupConfig : this.getGroupConfigs()) {
            if (!groupConfig.containsTable(tableName)) continue;
            return groupConfig.getKey();
        }
        return null;
    }

    public boolean isMainShardingTable(String tableName) {
        for (MetaShardingGroup groupConfig : this.getGroupConfigs()) {
            if (!groupConfig.containsTable(tableName)) continue;
            return true;
        }
        return false;
    }

    public void addGroupConfig(MetaShardingGroup groupConfig) {
        this.mapRouteGroupConfigs.put(groupConfig.getKey(), groupConfig);
    }

    public Collection<MetaShardingGroup> getGroupConfigs() {
        return this.mapRouteGroupConfigs.values();
    }

    public MetaShardingGroup getGroupConfig(String groupKey) {
        return this.mapRouteGroupConfigs.get(groupKey);
    }

    public void addGroupField(MetaShardingGroupField groupField) throws Throwable {
        if (!this.mapRouteGroupFields.containsKey(groupField.getKey())) {
            this.addFinalGroupFieldKey(groupField.getFinalFieldKey());
            this.addGroupFieldMapRelation(groupField.getKey(), groupField.getGroupType(), groupField.getFinalFieldKey(), groupField.getRelation());
            this.mapRouteGroupFields.put(groupField.getKey(), (Object)groupField);
        }
    }

    public MetaShardingGroupField getGroupField(String groupColumnName) {
        return (MetaShardingGroupField)this.mapRouteGroupFields.get(groupColumnName);
    }

    public void addGroupFieldMapRelation(String key, EGroupFieldType type, String finalFieldKey, String relation) {
        if (!StringUtil.isBlankOrNull((String)finalFieldKey)) {
            MetaShardingFieldRelation groupFieldRelation = new MetaShardingFieldRelation(key, type, finalFieldKey, relation);
            this.mapRouteGroupFieldRelations.put(key, (Object)groupFieldRelation);
        }
    }

    public void addGroupFieldRelation(MetaShardingFieldRelation groupFieldRelation) throws Throwable {
        this.mapRouteGroupFieldRelations.put(groupFieldRelation.getSourceFieldKey(), (Object)groupFieldRelation);
    }

    public MetaShardingFieldRelation getGroupFieldRelation(String groupColumnName) throws Throwable {
        return (MetaShardingFieldRelation)this.mapRouteGroupFieldRelations.get(groupColumnName);
    }

    public Collection<MetaShardingFieldRelation> getGroupFieldRelations() {
        return this.mapRouteGroupFieldRelations.values();
    }

    public void addFinalGroupFieldKey(String finalGroupFieldKey) {
        if (!StringUtil.isBlankOrNull((String)finalGroupFieldKey)) {
            this.finalGroupFieldKeys.add(finalGroupFieldKey);
        }
    }

    public boolean isFinalGroupColumn(String groupColumnName) {
        return this.finalGroupFieldKeys.contains(groupColumnName);
    }

    public boolean isShardingColumn(String columnName, String tableName) {
        MetaShardingGroup group = this.getGroupByTableName(tableName);
        if (group == null) {
            return false;
        }
        MetaShardingTable table = group.getShardingTable(tableName);
        if (table == null) {
            return false;
        }
        return table.containsColumn(columnName);
    }

    public static ShardingMetaConfig getInstance() {
        return instance;
    }
}

