/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.route.meta;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingTable;
import java.util.ArrayList;
import java.util.Collection;

public class MetaShardingGroup {
    private String key;
    private ArrayList<String> groupFieldKeys;
    private HashMapIgnoreCase<MetaShardingTable> mapGroupTables;

    public MetaShardingGroup(String key) {
        this.key = key;
        this.groupFieldKeys = new ArrayList();
        this.mapGroupTables = new HashMapIgnoreCase();
    }

    public String getKey() {
        return this.key;
    }

    public boolean containsTable(String tableName) {
        return this.mapGroupTables.containsKey(tableName);
    }

    public void addGroupField(String groupFieldKey) throws Throwable {
        this.groupFieldKeys.add(groupFieldKey);
    }

    public void addGroupTable(MetaShardingTable metaShardingTable) throws Throwable {
        this.mapGroupTables.put(metaShardingTable.getTableName(), (Object)metaShardingTable);
    }

    public String getGroupFieldKey(int index) {
        return this.groupFieldKeys.get(index);
    }

    public Collection<String> getGroupFieldKeys() {
        return this.groupFieldKeys;
    }

    public Collection<MetaShardingTable> getGroupTables() {
        return this.mapGroupTables.values();
    }

    public MetaShardingTable getShardingTable(String tableName) {
        return (MetaShardingTable)this.mapGroupTables.get(tableName);
    }
}

