/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.resultset;

import com.bokesoft.erp.mid.util.NotImplemented;
import com.bokesoft.yes.mid.mysqls.resultset.EmptyResultSetMetaData;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetAndPos;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetGetObjectByPos;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetUtil;
import com.bokesoft.yes.mid.mysqls.resultset.UnionResultSetMetaData;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class UnionResultSet
implements ResultSetGetObjectByPos {
    final SelectSqlInfo select;
    List<ResultSetGetObjectByPos> allResultSet = new ArrayList<ResultSetGetObjectByPos>();
    int pos;
    List<ResultSetAndPos> rows = new ArrayList<ResultSetAndPos>();
    ResultSet curResultSet;
    private UnionResultSetMetaData unionRsMetaData = null;
    private int hiddenColumnCount = 0;

    public UnionResultSet(SelectSqlInfo select) {
        this.select = select;
        this.rows.add(null);
        this.pos = 0;
    }

    public void addResultSet(ResultSetGetObjectByPos rs) throws SQLException {
        this.allResultSet.add(rs);
        int count = ResultSetUtil.getRowCount(rs);
        int i = 1;
        while (i <= count) {
            this.rows.add(new ResultSetAndPos(rs, i));
            ++i;
        }
        this.unionRsMetaData = null;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.pos = row;
        ResultSetAndPos resultSetAndPos = this.rows.get(this.pos);
        this.curResultSet = resultSetAndPos.resultSet;
        if (this.curResultSet == null) {
            return false;
        }
        return this.curResultSet.absolute(resultSetAndPos.pos);
    }

    @Override
    public void afterLast() throws SQLException {
        int rowCount = this.rows.size() - 1;
        this.pos = rowCount == 0 ? 1 : rowCount + 1;
        ResultSet resultSet = this.curResultSet = rowCount == 0 ? null : this.rows.get((int)rowCount).resultSet;
        if (this.curResultSet != null) {
            this.curResultSet.afterLast();
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.pos = 0;
        if (this.rows.size() > 1) {
            this.curResultSet = this.rows.get((int)1).resultSet;
            this.curResultSet.beforeFirst();
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void close() throws SQLException {
        for (ResultSet resultSet : this.allResultSet) {
            resultSet.close();
        }
        this.allResultSet.clear();
        this.rows.clear();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.allResultSet.get(0).findColumn(columnLabel);
    }

    @Override
    public boolean first() throws SQLException {
        int rowCount = this.rows.size() - 1;
        if (rowCount == 0) {
            this.pos = 0;
            return false;
        }
        this.absolute(1);
        return true;
    }

    public List<ResultSetAndPos> getRows() {
        return this.rows;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getBigDecimal(columnIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getBigDecimal(columnIndex, scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getBigDecimal(columnLabel);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getBigDecimal(columnLabel, scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return false;
        }
        return this.curResultSet.getBoolean(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return false;
        }
        return this.curResultSet.getBoolean(columnLabel);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return 0;
        }
        return this.curResultSet.getByte(columnIndex);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return 0;
        }
        return this.curResultSet.getByte(columnLabel);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getBytes(columnIndex);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getBytes(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getDate(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getDate(columnLabel);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getDate(columnLabel, cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return 0.0;
        }
        return this.curResultSet.getDouble(columnIndex);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return 0.0;
        }
        return this.curResultSet.getDouble(columnLabel);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return 0.0f;
        }
        return this.curResultSet.getFloat(columnIndex);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return 0.0f;
        }
        return this.curResultSet.getFloat(columnLabel);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return 0;
        }
        return this.curResultSet.getInt(columnIndex);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return 0;
        }
        return this.curResultSet.getInt(columnLabel);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return 0L;
        }
        return this.curResultSet.getLong(columnIndex);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return 0L;
        }
        return this.curResultSet.getLong(columnLabel);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.allResultSet.size() > 0) {
            if (this.unionRsMetaData == null) {
                this.unionRsMetaData = new UnionResultSetMetaData(this.allResultSet);
            }
            return this.unionRsMetaData;
        }
        return new EmptyResultSetMetaData(this.select);
    }

    @Override
    public void setHiddenColumnCount(int hiddenColumnCount) {
        this.hiddenColumnCount = hiddenColumnCount;
    }

    @Override
    public int getHiddenColumnCount() {
        return this.hiddenColumnCount;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getNString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getNString(columnLabel);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        if (this.getMetaData() instanceof UnionResultSetMetaData) {
            columnIndex = ((UnionResultSetMetaData)this.getMetaData()).getRealColumnIndex(this.curResultSet, columnIndex);
        }
        if (columnIndex == -1) {
            return null;
        }
        return this.curResultSet.getObject(columnIndex);
    }

    @Override
    public Object getObject(int pos, int columnIndex) throws SQLException {
        ResultSetAndPos resultSetAndPos = this.rows.get(pos);
        return resultSetAndPos.resultSet.getObject(resultSetAndPos.pos, columnIndex);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getObject(columnIndex, type);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getObject(columnIndex, map);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getObject(columnLabel);
    }

    @Override
    public Object getObject(int pos, String columnLabel) throws SQLException {
        ResultSetAndPos resultSetAndPos = this.rows.get(pos);
        return resultSetAndPos.resultSet.getObject(resultSetAndPos.pos, columnLabel);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getObject(columnLabel, type);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getObject(columnLabel, map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int getRow() throws SQLException {
        return this.pos;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return 0;
        }
        return this.curResultSet.getShort(columnIndex);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return 0;
        }
        return this.curResultSet.getShort(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getString(columnIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getString(columnLabel);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getTime(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getTime(columnLabel);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getTime(columnLabel, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getTimestamp(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        if (this.curResultSet == null) {
            return null;
        }
        return this.curResultSet.getTimestamp(columnLabel, cal);
    }

    @Override
    public int getType() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void insertRow() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        int rowCount = this.rows.size() - 1;
        return rowCount == 0 ? true : this.rows.get((int)rowCount).resultSet.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        int rowCount = this.rows.size() - 1;
        return rowCount == 0 ? true : this.rows.get((int)1).resultSet.isAfterLast();
    }

    @Override
    public boolean isClosed() throws SQLException {
        int rowCount = this.rows.size() - 1;
        return rowCount == 0 ? true : this.rows.get((int)1).resultSet.isClosed();
    }

    @Override
    public boolean isFirst() throws SQLException {
        int rowCount = this.rows.size() - 1;
        return rowCount == 0 ? false : this.rows.get((int)1).resultSet.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        int rowCount = this.rows.size() - 1;
        return rowCount == 0 ? false : this.rows.get((int)rowCount).resultSet.isLast();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean last() throws SQLException {
        int rowCount;
        this.pos = rowCount = this.rows.size() - 1;
        return rowCount == 0 ? false : this.rows.get((int)rowCount).resultSet.last();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean next() throws SQLException {
        ++this.pos;
        if (this.pos == this.rows.size()) {
            this.afterLast();
            return false;
        }
        return this.absolute(this.pos);
    }

    @Override
    public boolean previous() throws SQLException {
        --this.pos;
        if (this.pos == 0) {
            this.beforeFirst();
            return false;
        }
        return this.absolute(this.pos);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.curResultSet.wasNull();
    }

    public int getRowCount() {
        return this.rows.size() - 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UnionResultSet:").append("\n");
        if (this.allResultSet != null) {
            for (ResultSetGetObjectByPos rs : this.allResultSet) {
                sb.append(rs.toString()).append("\n");
            }
        }
        return sb.toString();
    }
}

