/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.result.sqlconvertor;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.dbcache.structure.OrderBy;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.result.function.ExpressionLocation;
import com.bokesoft.yes.mid.mysqls.result.sqlconvertor.ISelectFunctionProcessor;
import com.bokesoft.yes.mid.mysqls.result.sqlconvertor.change.IConvertChange;
import com.bokesoft.yes.mid.mysqls.result.sqlconvertor.processor.AvgFunctionProcessor;
import com.bokesoft.yes.mid.mysqls.result.sqlconvertor.processor.CountFunctionProcessor;
import com.bokesoft.yes.mid.mysqls.result.sqlconvertor.processor.MaxMinSumFunctionProcessor;
import com.bokesoft.yes.mid.mysqls.result.util.TypeUtils;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.Distinct;
import net.boke.jsqlparser.statement.select.Limit;
import net.boke.jsqlparser.statement.select.OrderByElement;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;

public class GroupFunctionConvertor {
    private static HashMapIgnoreCase<ISelectFunctionProcessor> funcProcessors = new HashMapIgnoreCase();
    private PlainSelect groupPlainSelect = null;
    private Expression orgHaving = null;
    private Distinct orgDistinct = null;
    private Limit orgLimit = null;
    private List<OrderBy> orgOrderBy = null;
    private List<ExpressionLocation> listFinalGroupFunc = new ArrayList<ExpressionLocation>();
    private List<IConvertChange> listGroupChanges = new ArrayList<IConvertChange>();

    static {
        funcProcessors.put("sum", (Object)new MaxMinSumFunctionProcessor());
        funcProcessors.put("max", (Object)new MaxMinSumFunctionProcessor());
        funcProcessors.put("min", (Object)new MaxMinSumFunctionProcessor());
        funcProcessors.put("avg", (Object)new AvgFunctionProcessor());
        funcProcessors.put("count", (Object)new CountFunctionProcessor());
    }

    public GroupFunctionConvertor(PlainSelect plainSelect, Expression extHaving, List extOrderBy) {
        this.groupPlainSelect = plainSelect;
        this.orgHaving = ParsedSqlUtil.newAndExpression(extHaving, plainSelect.getHaving());
        this.orgDistinct = plainSelect.getDistinct();
        this.orgLimit = plainSelect.getLimit();
        this.orgOrderBy = this.buildOrderByElements(plainSelect, extOrderBy);
    }

    private List<OrderBy> buildOrderByElements(PlainSelect plainSelect, List extOrderBy) {
        List orderByElements = plainSelect.getOrderByElements();
        orderByElements = orderByElements == null ? extOrderBy : orderByElements;
        int size = orderByElements != null ? orderByElements.size() : 0;
        ArrayList<OrderBy> result = new ArrayList<OrderBy>();
        result.ensureCapacity(size);
        int i = 0;
        int length = size;
        while (i < length) {
            Expression expression = ((OrderByElement)orderByElements.get(i)).getExpression();
            boolean isAsc = ((OrderByElement)orderByElements.get(i)).isAsc();
            if (expression instanceof Column) {
                Column column = (Column)expression;
                assert (column.getExtendSelectItemInGroupByOrderByHaving() != null);
                String realColumnName = ParsedSqlUtil.getSelectItemShortName(column.getExtendSelectItemInGroupByOrderByHaving());
                result.add(new OrderBy(realColumnName, -1, isAsc));
            }
            ++i;
        }
        return result;
    }

    public Expression getOrgHaving() {
        return this.orgHaving;
    }

    public Distinct getOrgDistinct() {
        return this.orgDistinct;
    }

    public Limit getOrgLimit() {
        return this.orgLimit;
    }

    public List<OrderBy> getOrgOrderBy() {
        return this.orgOrderBy;
    }

    public List<ExpressionLocation> getFinalGroupFuncs() {
        return this.listFinalGroupFunc;
    }

    public void prepareChanges(List<?> selectItems, SelectSqlInfo sqlInfo) {
        int columnIndex = 0;
        boolean bSimple = ParsedSqlUtil.isGroupFunctionColumnsInSameFromItem(selectItems);
        for (Object item : selectItems) {
            SelectExpressionItem selectItem;
            Expression expression;
            if (item instanceof SelectExpressionItem && ParsedSqlUtil.hasGroupFunc(expression = (selectItem = (SelectExpressionItem)item).getExpression())) {
                expression.traversal(elem -> {
                    if (elem instanceof Expression && ParsedSqlUtil.hasGroupFunc((Expression)elem)) {
                        Expression exp = (Expression)elem;
                        String functionName = ParsedSqlUtil.getFunctionName(exp);
                        if (ParsedSqlUtil.isGroupFunc(functionName)) {
                            ISelectFunctionProcessor processor = GroupFunctionConvertor.getFunctionConvertor(functionName);
                            if (processor != null) {
                                processor.process((Function)exp, bSimple, this.listGroupChanges, this.groupPlainSelect, sqlInfo);
                            }
                            return false;
                        }
                        return true;
                    }
                    return false;
                });
                int dataType = TypeUtils.getCalcItemDataType(selectItem.getExpression());
                this.listFinalGroupFunc.add(new ExpressionLocation(selectItem.getExpression(), columnIndex, dataType));
            }
            ++columnIndex;
        }
    }

    public boolean commitChanges() {
        if (this.groupPlainSelect == null) {
            return false;
        }
        for (IConvertChange change : this.listGroupChanges) {
            change.commit();
        }
        this.listGroupChanges.clear();
        for (ExpressionLocation groupFuncItem : this.listFinalGroupFunc) {
            SelectExpressionItem selectItem = (SelectExpressionItem)this.groupPlainSelect.getSelectItems().get(groupFuncItem.getColumnIndex());
            if (StringUtil.isBlankOrNull((String)selectItem.getAlias())) {
                selectItem.setAlias(String.valueOf(ParsedSqlUtil.getFuncAlias(groupFuncItem.getExp().toString())) + "_" + groupFuncItem.getColumnIndex());
            }
            selectItem.clearGroupExpressionBy(TypeUtils.getEmptyExpressionByType(groupFuncItem.getDataType()));
        }
        return this.listFinalGroupFunc.size() > 0;
    }

    public boolean hasGroupFunction() {
        return !this.listFinalGroupFunc.isEmpty();
    }

    private static ISelectFunctionProcessor getFunctionConvertor(String funcName) {
        return (ISelectFunctionProcessor)funcProcessors.get(funcName);
    }
}

