/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect.regular.actions;

import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.processselect.regular.AbstractRegularAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.visitor.RegularPlainSelectVisitor;
import java.util.List;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;

public class ResetJoinTypeAction
extends AbstractRegularAction {
    public ResetJoinTypeAction(Select select) {
        super(select);
    }

    @Override
    public void doAction() {
        RegularPlainSelectVisitor masterPlainVisitor = new RegularPlainSelectVisitor(elem -> {
            if (elem instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)elem;
                ResetJoinTypeAction.process(plainSelect);
            }
            return true;
        });
        this.select.getSelectBody().accept(masterPlainVisitor);
    }

    public static void process(PlainSelect plainSelect) {
        List joins = plainSelect.getJoins();
        int joinSizeTmp = joins != null ? joins.size() : 0;
        int i = joinSizeTmp - 1;
        while (i >= 0) {
            Join join = (Join)joins.get(i);
            if (join.isLeft()) {
                if (ParsedSqlUtil.isUseTableNotIsNull(plainSelect.getWhere(), join.getRightItem())) {
                    join.setInner(true);
                    join.setLeft(false);
                } else {
                    int j = i + 1;
                    while (j < joinSizeTmp) {
                        Join afterJoin = (Join)joins.get(j);
                        if (!afterJoin.isLeft() && !afterJoin.isRight() && !afterJoin.isFull() && ParsedSqlUtil.isUseTableNotIsNull(afterJoin.getOnExpression(), join.getRightItem())) {
                            join.setInner(true);
                            join.setLeft(false);
                            break;
                        }
                        ++j;
                    }
                }
            }
            --i;
        }
    }

    @Override
    public String getName() {
        return "ResetJoinType";
    }
}

