/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect.regular.actions;

import com.bokesoft.yes.mid.mysqls.processselect.AssignColumnToFromItem;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.processselect.regular.AbstractRegularAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.actions.RemoveInExistAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.change.ChangedFromItems;
import com.bokesoft.yes.mid.mysqls.processselect.regular.change.DeletedSubSelect;
import com.bokesoft.yes.mid.mysqls.processselect.regular.util.SqlRegularUtil;
import com.bokesoft.yes.mid.mysqls.processselect.regular.visitor.RegularPlainSelectVisitor;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SubSelect;

public class FlatSubSelectAction
extends AbstractRegularAction {
    public FlatSubSelectAction(Select select) {
        super(select);
    }

    @Override
    public void doAction() {
        RegularPlainSelectVisitor masterPlainVisitor = new RegularPlainSelectVisitor(elem -> {
            if (elem instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)elem;
                this.process(plainSelect);
            }
            return true;
        });
        this.select.getSelectBody().accept(masterPlainVisitor);
    }

    public void process(PlainSelect plainSelect) {
        FromItem fromItem = plainSelect.getFromItem();
        if (!(fromItem instanceof SubSelect)) {
            return;
        }
        SubSelect subSelect = (SubSelect)fromItem;
        SelectBody subSelectBody = subSelect.getSelectBody();
        if (!(subSelectBody instanceof PlainSelect) || ((PlainSelect)subSelectBody).getFromItem() == null) {
            return;
        }
        ChangedFromItems changedFromItems = new ChangedFromItems();
        if (SqlRegularUtil.isNeedFlatSubSelect4AllColumns(plainSelect)) {
            this.flatSubSelect4AllColumns(plainSelect, subSelect, changedFromItems);
        } else {
            this.flatSubSelect(plainSelect, subSelect, changedFromItems);
        }
        SqlRegularUtil.doChangeFormItem(plainSelect, changedFromItems);
        if (changedFromItems.getSize() > 0) {
            AssignColumnToFromItem.reAssign(this.select);
        }
    }

    private void flatSubSelect(PlainSelect plainSelect, SubSelect subSelect, ChangedFromItems changedFromItems) {
        List joins = plainSelect.getJoins();
        SelectBody subSelectBody = subSelect.getSelectBody();
        PlainSelect subPlainSelect = (PlainSelect)subSelectBody;
        RemoveInExistAction.process(subPlainSelect);
        if (subPlainSelect.getJoins() != null) {
            if (joins != null) {
                joins.addAll(0, subPlainSelect.getJoins());
            } else {
                joins = subPlainSelect.getJoins();
                plainSelect.setJoins(joins);
            }
        }
        if (subPlainSelect.getDistinct() != null && plainSelect.getDistinct() == null) {
            plainSelect.setDistinct(subPlainSelect.getDistinct());
        }
        if (subPlainSelect.getWhere() != null) {
            plainSelect.setWhere(ParsedSqlUtil.newAndExpression(plainSelect.getWhere(), subPlainSelect.getWhere()));
        }
        changedFromItems.addDeletedSubSelect(plainSelect, new DeletedSubSelect(subSelect, plainSelect));
        plainSelect.setFromItem(subPlainSelect.getFromItem());
    }

    private void flatSubSelect4AllColumns(PlainSelect plainSelect, SubSelect subSelect, ChangedFromItems changedFromItems) {
        SelectBody subSelectBody = subSelect.getSelectBody();
        if (subSelectBody instanceof PlainSelect && ((PlainSelect)subSelectBody).getFromItem() != null) {
            PlainSelect subPlainSelect = (PlainSelect)subSelectBody;
            plainSelect.setSelectItems(subPlainSelect.getSelectItems());
            plainSelect.setDistinct(subPlainSelect.getDistinct());
            plainSelect.setFromItem(subPlainSelect.getFromItem());
            plainSelect.setJoins(subPlainSelect.getJoins());
            List joins = plainSelect.getJoins();
            if (joins != null) {
                ArrayList<FromItem> findTables = new ArrayList<FromItem>();
                ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, plainSelect.getWhere(), findTables);
                for (Object tmp : joins) {
                    Join join = (Join)tmp;
                    FromItem joinFormItem = join.getRightItem();
                    if (!findTables.contains(joinFormItem)) continue;
                    join.setInner(true);
                    join.setLeft(false);
                }
            }
            plainSelect.setGroupByColumnReferences(subPlainSelect.getGroupByColumnReferences());
            plainSelect.setWhere(ParsedSqlUtil.newAndExpression(plainSelect.getWhere(), subPlainSelect.getWhere()));
            plainSelect.setHaving(ParsedSqlUtil.newAndExpression(plainSelect.getHaving(), subPlainSelect.getHaving()));
            if (plainSelect.getOrderByElements() == null && subPlainSelect.getOrderByElements() != null) {
                plainSelect.setOrderByElements(subPlainSelect.getOrderByElements());
            }
            changedFromItems.addDeletedSubSelect(plainSelect, new DeletedSubSelect(subSelect, plainSelect));
        }
    }

    @Override
    public String getName() {
        return "FlatSubSelect";
    }
}

