/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect;

import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.util.RefParameter;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.operators.relational.MultiInExpression;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectBody;

public class SelectMulitInConvert {
    public static Select convertFromMultiJdbcParasToMultiSqlParas(Select select, Parameters paras, RefParameter<List<Parameters>> parasListRef) {
        Select result = SelectMulitInConvert.copySelect(select);
        MultiInExpression multiIn = (MultiInExpression)((PlainSelect)result.getSelectBody()).getWhere();
        List<List<Expression>> expressionsList = multiIn.getValuesList();
        List<Expression> firstExpressions = expressionsList.get(0);
        int jdbcParameterCount = 0;
        for (Expression tmp : firstExpressions) {
            if (!(tmp instanceof JdbcParameter)) continue;
            ++jdbcParameterCount;
        }
        int parasSize = paras.size();
        if (parasSize % jdbcParameterCount != 0) {
            throw new RuntimeException("\u591a\u5b57\u6bb5\u591a\u7ec4JDBC\u53c2\u6570\uff08\u5373\uff1f\uff09\u4e00\u7ec4SQL\u53c2\u6570In\u6761\u4ef6\u67e5\u8be2\u8bed\u53e5\u8f6c\u6362\u6210\u591a\u5b57\u6bb5\u4e00\u7ec4JDBC\u53c2\u6570\uff08\u5373\uff1f\uff09\u591a\u7ec4SQL\u53c2\u6570in\u6761\u4ef6\u67e5\u8be2\u8bed\u53e5\u8f6c\u6362\u9519\u8bef\uff0c\u53c2\u6570\u6570\u91cf\u4e0d\u5bf9\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
        }
        int parasListSize = parasSize / jdbcParameterCount;
        ArrayList<Parameters> parasList = new ArrayList<Parameters>(parasListSize);
        int i = 0;
        while (i < parasListSize) {
            Parameters tmp = new Parameters(jdbcParameterCount);
            int j = 1;
            while (j <= jdbcParameterCount) {
                int index = i * jdbcParameterCount + j;
                tmp.setArg(j, paras.getType(index), paras.getValue(index));
                ++j;
            }
            parasList.add(tmp);
            ++i;
        }
        parasListRef.setValue(parasList);
        ArrayList<List<Expression>> newExpressionsList = new ArrayList<List<Expression>>(1);
        newExpressionsList.add(firstExpressions);
        multiIn.setValuesList(newExpressionsList);
        return result;
    }

    public static Select convertFromMultiSqlParasToMultiJdbcParas(Select select, List<Parameters> parasList, RefParameter<Parameters> parasRef) {
        MultiInExpression multiIn = (MultiInExpression)((PlainSelect)select.getSelectBody()).getWhere();
        List<List<Expression>> expressionsList = multiIn.getValuesList();
        List<Expression> firstExpressions = expressionsList.get(0);
        int jdbcParameterCount = 0;
        for (Expression tmp : firstExpressions) {
            if (!(tmp instanceof JdbcParameter)) continue;
            ++jdbcParameterCount;
        }
        int parasListSize = parasList.size();
        if (parasListSize == 0) {
            throw new RuntimeException("\u5c06\u591a\u5b57\u6bb5\u4e00\u7ec4JDBC\u53c2\u6570\uff08\u5373\uff1f\uff09\u591a\u7ec4SQL\u53c2\u6570in\u6761\u4ef6\u67e5\u8be2\u8bed\u53e5\u8f6c\u6362\u6210\u591a\u5b57\u6bb5\u591a\u7ec4JDBC\u53c2\u6570\uff08\u5373\uff1f\uff09\u4e00\u7ec4SQL\u53c2\u6570In\u6761\u4ef6\u67e5\u8be2\u8bed\u53e5\u8f6c\u6362\u51fa\u9519\uff0c\u6ca1\u6709\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
        }
        int parasSize = parasList.get(0).size();
        if (parasSize != jdbcParameterCount) {
            throw new RuntimeException("\u591a\u5b57\u6bb5\u591a\u7ec4JDBC\u53c2\u6570\uff08\u5373\uff1f\uff09\u4e00\u7ec4SQL\u53c2\u6570In\u6761\u4ef6\u67e5\u8be2\u8bed\u53e5\u8f6c\u6362\u6210\u591a\u5b57\u6bb5\u4e00\u7ec4JDBC\u53c2\u6570\uff08\u5373\uff1f\uff09\u591a\u7ec4SQL\u53c2\u6570in\u6761\u4ef6\u67e5\u8be2\u8bed\u53e5\u8f6c\u6362\u9519\u8bef\uff0c\u53c2\u6570\u4e2a\u6570\u4e0d\u5bf9\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
        }
        if (parasListSize == 1) {
            parasRef.setValue(parasList.get(0));
            return select;
        }
        Select result = SelectMulitInConvert.copySelect(select);
        multiIn = (MultiInExpression)((PlainSelect)result.getSelectBody()).getWhere();
        expressionsList = multiIn.getValuesList();
        int i = 1;
        while (i < parasListSize) {
            expressionsList.add(SelectMulitInConvert.copyExpressionList(firstExpressions));
            ++i;
        }
        Parameters paras = new Parameters(jdbcParameterCount * parasListSize);
        int i2 = 0;
        while (i2 < parasListSize) {
            Parameters tmp = parasList.get(i2);
            int j = 1;
            while (j <= jdbcParameterCount) {
                paras.setArg(i2 * jdbcParameterCount + j, tmp.getType(j), tmp.getValue(j));
                ++j;
            }
            ++i2;
        }
        parasRef.setValue(paras);
        return result;
    }

    private static Select copySelect(Select select) {
        Select result = new Select();
        PlainSelect body = new PlainSelect();
        result.setSelectBody(body);
        PlainSelect oldBody = (PlainSelect)select.getSelectBody();
        body.setSelectItems(oldBody.getSelectItems());
        body.setFromItem(oldBody.getFromItem());
        MultiInExpression multiIn = new MultiInExpression();
        body.setWhere(multiIn);
        MultiInExpression oldMultiIn = (MultiInExpression)oldBody.getWhere();
        multiIn.setColumnList(oldMultiIn.getColumnList());
        List<List<Expression>> oldValuesList = oldMultiIn.getValuesList();
        ArrayList<List<Expression>> valuesList = new ArrayList<List<Expression>>(oldValuesList.size());
        valuesList.addAll(oldValuesList);
        multiIn.setValuesList(valuesList);
        return result;
    }

    private static List<Expression> copyExpressionList(List<Expression> expressionList) {
        int size = expressionList.size();
        ArrayList<Expression> result = new ArrayList<Expression>(size);
        int i = 0;
        while (i < size) {
            Expression old = expressionList.get(i);
            if (old instanceof JdbcParameter) {
                result.add(new JdbcParameter());
            } else {
                result.add(old);
            }
            ++i;
        }
        return result;
    }

    public static boolean isMultiJdbcParasMultiIn(Select select) {
        SelectBody tmpBody = select.getSelectBody();
        if (!(tmpBody instanceof PlainSelect)) {
            return false;
        }
        PlainSelect body = (PlainSelect)tmpBody;
        if (body.getJoins() != null) {
            return false;
        }
        Expression where = body.getWhere();
        if (where == null || !(where instanceof MultiInExpression)) {
            return false;
        }
        MultiInExpression multiIn = (MultiInExpression)where;
        if (multiIn.getValuesList().size() <= 1) {
            return false;
        }
        List<List<Expression>> expressionsList = multiIn.getValuesList();
        int expressionsListSize = expressionsList.size();
        if (expressionsListSize <= 1) {
            return false;
        }
        List<Expression> firstExpressions = expressionsList.get(0);
        int expressionCount = firstExpressions.size();
        String[] firstExpressionStrings = new String[expressionCount];
        int i = 0;
        while (i < expressionCount) {
            firstExpressionStrings[i] = firstExpressions.get(i).toString();
            ++i;
        }
        i = 1;
        while (i < expressionsListSize) {
            List<Expression> expressions = expressionsList.get(i);
            int j = 0;
            while (j < expressionCount) {
                if (!firstExpressionStrings[j].equals(expressions.get(j).toString())) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isMultiSqlParasMultiIn(Select select) {
        SelectBody tmpBody = select.getSelectBody();
        if (!(tmpBody instanceof PlainSelect)) {
            return false;
        }
        PlainSelect body = (PlainSelect)tmpBody;
        if (body.getJoins() != null) {
            return false;
        }
        Expression where = body.getWhere();
        if (where == null || !(where instanceof MultiInExpression)) {
            return false;
        }
        MultiInExpression multiIn = (MultiInExpression)where;
        return multiIn.getValuesList().size() <= 1;
    }
}

