/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect;

import com.bokesoft.yes.common.struct.LinkedHashMapIgnoreCase;
import com.bokesoft.yes.mid.dbmanager.interceptor.stage.visitor.BaseExpressionVisitor;
import com.bokesoft.yes.mid.mysqls.dbstruct.DBStruct;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.AllColumns;
import net.boke.jsqlparser.statement.select.AllTableColumns;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.OrderByElement;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SubJoin;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.statement.select.Union;

public class AssignColumnToFromItem {
    public static void assign(Select select) {
        if (!select.isExtendAssignColumn()) {
            SelectBody selectBody = select.getSelectBody();
            AssignColumnToFromItem.assign(selectBody, null, null);
            select.setExtendAssignColumn();
        }
    }

    private static List<SelectExpressionItem> assign(SelectBody selectBody, List<Table> outTables, HashMap<SubSelect, List<SelectExpressionItem>> outSubSelect2SelectItems) {
        if (selectBody instanceof Union) {
            List<SelectExpressionItem> firstSelect = null;
            for (Object body : ((Union)selectBody).getPlainSelects()) {
                List<SelectExpressionItem> tmp = AssignColumnToFromItem.assign((SelectBody)body, outTables, outSubSelect2SelectItems);
                if (firstSelect != null) continue;
                firstSelect = tmp;
            }
            return firstSelect;
        }
        assert (selectBody instanceof PlainSelect);
        return AssignColumnToFromItem.assign((PlainSelect)selectBody, outTables, outSubSelect2SelectItems);
    }

    private static List<SelectExpressionItem> assign(PlainSelect plainSelect, List<Table> outTables, HashMap<SubSelect, List<SelectExpressionItem>> outSubSelect2SelectItems) {
        ArrayList<Table> tables = new ArrayList<Table>();
        HashMap<SubSelect, List<SelectExpressionItem>> subSelect2SelectItems = new HashMap<SubSelect, List<SelectExpressionItem>>();
        AssignColumnToFromItem.loadColumns(plainSelect.getFromItem(), tables, subSelect2SelectItems);
        if (plainSelect.getJoins() != null) {
            for (Object join : plainSelect.getJoins()) {
                AssignColumnToFromItem.loadColumns(((Join)join).getRightItem(), tables, subSelect2SelectItems);
            }
        }
        ArrayList<SelectExpressionItem> result = new ArrayList<SelectExpressionItem>();
        for (Object selectItem : plainSelect.getSelectItems()) {
            SelectExpressionItem newSelectItem;
            if (selectItem instanceof SelectExpressionItem) {
                AssignColumnToFromItem.assign(((SelectExpressionItem)selectItem).getExpression(), tables, subSelect2SelectItems, outTables, outSubSelect2SelectItems);
                result.add((SelectExpressionItem)selectItem);
                continue;
            }
            if (selectItem instanceof AllTableColumns) {
                Table selectTable = ((AllTableColumns)selectItem).getTable();
                String tableName = selectTable.getName();
                for (Table table : tables) {
                    if (!tableName.equalsIgnoreCase(table.getAlias()) && !tableName.equalsIgnoreCase(table.getName())) continue;
                    ((AllTableColumns)selectItem).setExtendFromItem(table);
                    for (String columnName : DataObjects.getInstance().getColumnsByTableName(table.getName()).keySet()) {
                        newSelectItem = new SelectExpressionItem();
                        newSelectItem.setExpression(new Column(selectTable, columnName).setExtendTable(table, columnName));
                        result.add(newSelectItem);
                    }
                }
                for (SubSelect subSelect : subSelect2SelectItems.keySet()) {
                    if (!tableName.equalsIgnoreCase(subSelect.getAlias())) continue;
                    ((AllTableColumns)selectItem).setExtendFromItem(subSelect);
                    for (SelectExpressionItem subSelectItem : subSelect2SelectItems.get(subSelect)) {
                        newSelectItem = new SelectExpressionItem();
                        newSelectItem.setExpression(new Column(selectTable, subSelectItem.getColumnNameInResultSet()).setExtendSubSelect(subSelect, subSelectItem));
                        result.add(newSelectItem);
                    }
                }
                continue;
            }
            assert (selectItem instanceof AllColumns);
            for (Table table : tables) {
                LinkedHashMapIgnoreCase<MetaColumn> columns = DataObjects.getInstance().getColumnsByTableName(table.getName());
                if (columns == null) {
                    throw new RuntimeException("\u5206\u5e93\u5904\u7406\uff0c\u8868 " + table.getName() + " \u5728\u914d\u7f6e\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728\uff0cSQL\u7247\u65ad\uff08\u683c\u5f0f\u5316\u540e\u7684\uff09\uff1a" + plainSelect.toString());
                }
                Table selectTable = new Table(null, ParsedSqlUtil.getFromItemShortName(table));
                for (String columnName : columns.keySet()) {
                    newSelectItem = new SelectExpressionItem();
                    newSelectItem.setExpression(new Column(selectTable, columnName).setExtendTable(table, columnName));
                    result.add(newSelectItem);
                }
            }
            for (SubSelect subSelect : subSelect2SelectItems.keySet()) {
                Table selectTable = new Table(null, subSelect.getAlias());
                for (SelectExpressionItem subSelectItem : subSelect2SelectItems.get(subSelect)) {
                    SelectExpressionItem newSelectItem2 = new SelectExpressionItem();
                    newSelectItem2.setExpression(new Column(selectTable, subSelectItem.getColumnNameInResultSet()).setExtendSubSelect(subSelect, subSelectItem));
                    result.add(newSelectItem2);
                }
            }
        }
        if (plainSelect.getJoins() != null) {
            for (Object join : plainSelect.getJoins()) {
                Expression onExpression = ((Join)join).getOnExpression();
                AssignColumnToFromItem.assign(onExpression, tables, subSelect2SelectItems, outTables, outSubSelect2SelectItems);
            }
        }
        AssignColumnToFromItem.assign(plainSelect.getWhere(), tables, subSelect2SelectItems, outTables, outSubSelect2SelectItems);
        AssignColumnToFromItem.assignToSelectItem(plainSelect.getHaving(), result);
        AssignColumnToFromItem.assign(plainSelect.getHaving(), tables, subSelect2SelectItems, outTables, outSubSelect2SelectItems);
        if (plainSelect.getGroupByColumnReferences() != null) {
            for (Object groupByExpression : plainSelect.getGroupByColumnReferences()) {
                AssignColumnToFromItem.assign((Expression)groupByExpression, tables, subSelect2SelectItems, outTables, outSubSelect2SelectItems);
                AssignColumnToFromItem.assignToSelectItem((Expression)groupByExpression, result);
            }
        }
        if (plainSelect.getOrderByElements() != null) {
            for (Object orderByExpression : plainSelect.getOrderByElements()) {
                Expression orderByItem = ((OrderByElement)orderByExpression).getExpression();
                AssignColumnToFromItem.assignToSelectItem(orderByItem, result);
                AssignColumnToFromItem.assign(orderByItem, tables, subSelect2SelectItems, outTables, outSubSelect2SelectItems);
            }
        }
        return result;
    }

    private static void loadColumns(FromItem fromItem, List<Table> tables, HashMap<SubSelect, List<SelectExpressionItem>> subSelect2SelectItems) {
        assert (!(fromItem instanceof SubJoin));
        if (fromItem instanceof Table) {
            tables.add((Table)fromItem);
        } else if (fromItem instanceof SubSelect) {
            List<SelectExpressionItem> result = AssignColumnToFromItem.assign(((SubSelect)fromItem).getSelectBody(), null, null);
            subSelect2SelectItems.put((SubSelect)fromItem, result);
        }
    }

    private static void assign(final Expression exp, final List<Table> tables, final HashMap<SubSelect, List<SelectExpressionItem>> subSelect2SelectItems, final List<Table> outTables, final HashMap<SubSelect, List<SelectExpressionItem>> outSubSelect2SelectItems) {
        if (exp == null) {
            return;
        }
        exp.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(Column tableColumn) {
                if (tableColumn.getExtendSelectItemInGroupByOrderByHaving() != null) {
                    return;
                }
                if (tableColumn.getTable() == null || tableColumn.getTable().getName() == null) {
                    for (Table table : tables) {
                        if (!DBStruct.isExistColumnInTable(tableColumn.getColumnName(), table.getName())) continue;
                        tableColumn.setExtendTable(table, tableColumn.getColumnName());
                        return;
                    }
                    for (SubSelect subSelect : subSelect2SelectItems.keySet()) {
                        for (SelectExpressionItem selectItem : (List)subSelect2SelectItems.get(subSelect)) {
                            if (!selectItem.getColumnNameInResultSet().equalsIgnoreCase(tableColumn.getColumnName())) continue;
                            tableColumn.setExtendSubSelect(subSelect, selectItem);
                            return;
                        }
                    }
                } else {
                    String tableName = tableColumn.getTable().getName();
                    for (Table table : tables) {
                        if (!tableName.equalsIgnoreCase(table.getAlias()) && !tableName.equalsIgnoreCase(table.getName())) continue;
                        LinkedHashMapIgnoreCase<MetaColumn> columns = DataObjects.getInstance().getColumnsByTableName(table.getName());
                        if (columns == null) {
                            throw new RuntimeException("\u5206\u5e93\u5904\u7406\uff0c\u8868 " + table.getName() + " \u5728\u914d\u7f6e\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728\uff0cSQL\u7247\u65ad\uff08\u683c\u5f0f\u5316\u540e\u7684\uff09\uff1a" + exp.toString());
                        }
                        if (!columns.containsKey(tableColumn.getColumnName())) continue;
                        tableColumn.setExtendTable(table, tableColumn.getColumnName());
                        return;
                    }
                    for (SubSelect subSelect : subSelect2SelectItems.keySet()) {
                        if (!tableName.equalsIgnoreCase(subSelect.getAlias())) continue;
                        for (SelectExpressionItem selectItem : (List)subSelect2SelectItems.get(subSelect)) {
                            if (!selectItem.getColumnNameInResultSet().equalsIgnoreCase(tableColumn.getColumnName())) continue;
                            tableColumn.setExtendSubSelect(subSelect, selectItem);
                            return;
                        }
                    }
                    if (outTables != null) {
                        for (Table table : outTables) {
                            if (!tableName.equalsIgnoreCase(table.getAlias()) && !tableName.equalsIgnoreCase(table.getName()) || !DBStruct.isExistColumnInTable(tableColumn.getColumnName(), table.getName())) continue;
                            tableColumn.setExtendTable(table, tableColumn.getColumnName());
                            return;
                        }
                    }
                    if (outSubSelect2SelectItems != null) {
                        for (SubSelect subSelect : outSubSelect2SelectItems.keySet()) {
                            if (!tableName.equalsIgnoreCase(subSelect.getAlias())) continue;
                            for (SelectExpressionItem selectItem : (List)outSubSelect2SelectItems.get(subSelect)) {
                                if (!selectItem.getColumnNameInResultSet().equalsIgnoreCase(tableColumn.getColumnName())) continue;
                                tableColumn.setExtendSubSelect(subSelect, selectItem);
                                return;
                            }
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }

            @Override
            public void visit(SubSelect subSelect) {
                List selectItems = AssignColumnToFromItem.assign(subSelect.getSelectBody(), (List<Table>)tables, (HashMap<SubSelect, List<SelectExpressionItem>>)subSelect2SelectItems);
                if (!($assertionsDisabled || selectItems != null && selectItems.size() >= 1)) {
                    throw new AssertionError();
                }
            }
        });
    }

    private static void assignToSelectItem(Expression exp, final List<SelectExpressionItem> selectItems) {
        if (exp == null) {
            return;
        }
        exp.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(Column tableColumn) {
                if (tableColumn.getTable() == null || tableColumn.getTable().getName() == null) {
                    for (SelectExpressionItem selectItem : selectItems) {
                        if (!tableColumn.getColumnName().equalsIgnoreCase(selectItem.getColumnNameInResultSet()) && (!(selectItem.getExpression() instanceof Column) || !tableColumn.getColumnName().equalsIgnoreCase(((Column)selectItem.getExpression()).getColumnName()))) continue;
                        tableColumn.setExtendSelectItemInGroupByOrderByHaving(selectItem);
                        return;
                    }
                } else {
                    String tableName = tableColumn.getTable().getName();
                    for (SelectExpressionItem selectItem : selectItems) {
                        if (!(selectItem.getExpression() instanceof Column) || !tableColumn.getColumnName().equalsIgnoreCase(selectItem.getColumnNameInResultSet()) && !tableColumn.getColumnName().equalsIgnoreCase(((Column)selectItem.getExpression()).getColumnName()) || !tableName.equalsIgnoreCase(ParsedSqlUtil.getFromItemShortName(((Column)selectItem.getExpression()).getExtendFromItem()))) continue;
                        tableColumn.setExtendSelectItemInGroupByOrderByHaving(selectItem);
                        return;
                    }
                }
            }
        });
    }

    public static void reAssign(Select select) {
        select.traversal(elem -> {
            if (elem instanceof Column) {
                ((Column)elem).clearAssignFromItem();
                return false;
            }
            return true;
        });
        select.clearExtendAssignColumn();
        AssignColumnToFromItem.assign(select);
    }
}

