/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.oidpool;

import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DSNTableName
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String tableNamePostFix = "";
    private OneOrMultiValue<String> dsnNames;
    private OneOrMultiValue<String> newDSNNames;
    private boolean isDataMayRepeat;

    public DSNTableName() {
    }

    public DSNTableName(String dsnName) {
        this.dsnNames = new OneOrMultiValue<String>(dsnName);
    }

    public DSNTableName(OneOrMultiValue<String> dsnNames) {
        this.dsnNames = dsnNames;
    }

    public DSNTableName(OneOrMultiValue<String> dsnNames, String tableNamePostFix) {
        this.dsnNames = dsnNames;
        this.tableNamePostFix = tableNamePostFix;
    }

    public DSNTableName(String dsnName, String tableNamePostFix) {
        this(dsnName);
        this.tableNamePostFix = tableNamePostFix;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DSNTableName)) {
            return false;
        }
        DSNTableName tmp = (DSNTableName)obj;
        return this.dsnNames.equals(tmp.dsnNames) && this.isEquals(this.newDSNNames, tmp.newDSNNames);
    }

    private boolean isEquals(OneOrMultiValue<String> s1, OneOrMultiValue<String> s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder(64).append(this.dsnNames);
        if (this.newDSNNames != null && !this.isEquals(this.newDSNNames, this.dsnNames)) {
            result.append("->").append(this.newDSNNames);
        }
        result.append("#").append(this.tableNamePostFix);
        return result.toString();
    }

    public OneOrMultiValue<String> getDsnNames() {
        return this.dsnNames;
    }

    public void setNewDSNName(String newDSNName) {
        if (this.newDSNNames != null) {
            throw new RuntimeException("ERROR");
        }
        this.newDSNNames = new OneOrMultiValue<String>(newDSNName);
    }

    public void addNewDSNName(String newDSNName) {
        if (this.newDSNNames == null) {
            this.newDSNNames = new OneOrMultiValue<String>(newDSNName);
        } else {
            this.newDSNNames.addValue(newDSNName);
        }
    }

    public void setDsnNames(OneOrMultiValue<String> dsnNames) {
        this.dsnNames = dsnNames;
    }

    public OneOrMultiValue<String> getNewDSNNames() {
        return this.newDSNNames;
    }

    public void setNewDSNNames(OneOrMultiValue<String> newDSNNames) {
        this.newDSNNames = newDSNNames;
    }

    public boolean hasNewDSNName() {
        if (this.newDSNNames == null || this.newDSNNames.isEmpty()) {
            return false;
        }
        if (this.dsnNames == null || this.dsnNames.isEmpty()) {
            throw new RuntimeException("ERROR");
        }
        return !this.newDSNNames.equals(this.dsnNames);
    }

    public void addDSNName(String dsnName) {
        if (this.dsnNames == null) {
            this.dsnNames = new OneOrMultiValue();
        }
        this.dsnNames.addValue(dsnName);
    }

    public void addDSNNames(OneOrMultiValue<String> dsnNames) {
        if (dsnNames == null) {
            return;
        }
        for (String dsnName : dsnNames) {
            this.addDSNName(dsnName);
        }
    }

    public boolean isDsnNameEmpty() {
        return this.dsnNames == null || this.dsnNames.isEmpty();
    }

    public boolean isSingleDsnName() {
        return this.newDSNNames != null ? this.newDSNNames.isSingleValue() : this.dsnNames != null && this.dsnNames.isSingleValue();
    }

    public String getSingleDSNName() {
        return this.newDSNNames != null ? this.newDSNNames.getSingleValue() : this.dsnNames.getSingleValue();
    }

    public void setIsDataMayRepeat() {
        this.isDataMayRepeat = true;
    }

    public boolean isDataMayRepeat() {
        return this.isDataMayRepeat;
    }

    public List<String> getDeleteDSNNames() {
        if (this.newDSNNames == null || this.newDSNNames.isEmpty()) {
            throw new RuntimeException("ERROR");
        }
        if (this.dsnNames == null || this.dsnNames.isEmpty()) {
            throw new RuntimeException("ERROR");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String dsnName : this.dsnNames) {
            if (this.newDSNNames.hasValue(dsnName)) continue;
            result.add(dsnName);
        }
        return result;
    }

    public List<String> getInsertDSNNames() {
        if (this.newDSNNames == null || this.newDSNNames.isEmpty()) {
            throw new RuntimeException("ERROR");
        }
        if (this.dsnNames == null || this.dsnNames.isEmpty()) {
            throw new RuntimeException("ERROR");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String dsnName : this.newDSNNames) {
            if (this.dsnNames.hasValue(dsnName)) continue;
            result.add(dsnName);
        }
        return result;
    }

    public static DSNTableName getDSNTableNameNewValue(DSNTableName dsnTableName) {
        if (dsnTableName.hasNewDSNName()) {
            return new DSNTableName(dsnTableName.getNewDSNNames());
        }
        return dsnTableName;
    }
}

