/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group.meta;

import com.bokesoft.erp.mid.util.ProcessKeysMigrateDataObject;
import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.struct.LinkedHashMapIgnoreCase;
import com.bokesoft.yes.mid.base.MidGlobalEnv;
import com.bokesoft.yes.mid.base.MidVEUtil;
import com.bokesoft.yes.mid.connection.MdbDSNItems;
import com.bokesoft.yes.mid.migration.period.MigrationStruct;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaEmbedTable;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DataObjects {
    List<MetaDataObject> allDataObjects;
    HashMapIgnoreCase<List<MetaDataObject>> tableToDataObject;
    private HashMapIgnoreCase<LinkedHashMapIgnoreCase<MetaColumn>> columns = new HashMapIgnoreCase();

    private DataObjects() {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        if (metaFactory == null) {
            metaFactory = MidGlobalEnv.getInstance().getMetaFactory();
        }
        try {
            this.init(metaFactory);
        }
        catch (Throwable e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static DataObjects getInstance() {
        return DataObjectsHolder.instance;
    }

    public void report() throws Throwable {
        ArrayList<String> tableNames = new ArrayList<String>(this.tableToDataObject.keySet());
        tableNames.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(((List)DataObjects.this.tableToDataObject.get(o2)).size()).compareTo(((List)DataObjects.this.tableToDataObject.get(o1)).size());
            }
        });
        int top = Math.min(40, tableNames.size());
        int i = 0;
        while (i < top) {
            String tableName = (String)tableNames.get(i);
            List list = (List)this.tableToDataObject.get(tableName);
            ++i;
        }
        int columnCount = 0;
        for (String tableName : tableNames) {
            columnCount += this.getColumnsByTableName(tableName).size();
        }
    }

    private void putTable2DataObject(String tableName, MetaDataObject dataObject) {
        ArrayList<MetaDataObject> dataObjects;
        if (this.tableToDataObject == null) {
            this.tableToDataObject = new HashMapIgnoreCase();
        }
        if ((dataObjects = (ArrayList<MetaDataObject>)this.tableToDataObject.get(tableName)) == null) {
            dataObjects = new ArrayList<MetaDataObject>();
            this.tableToDataObject.put(tableName, dataObjects);
        }
        if (dataObject.getExtend() != null && !dataObjects.contains(dataObject)) {
            dataObjects.add(dataObject);
        }
    }

    private void init(IMetaFactory metaFactory) throws Throwable {
        this.init(metaFactory, false);
    }

    public void init(IMetaFactory metaFactory, boolean bInitByDesign) throws Throwable {
        this.allDataObjects = new ArrayList<MetaDataObject>();
        List<MetaDataObject> allMetaDataObject = DataObjects.getAllMetaDataObject(metaFactory);
        for (MetaDataObject metaDataObject : allMetaDataObject) {
            String tableName;
            if (metaDataObject.getTableCollection() == null && metaDataObject.getEmbedTables() != null) continue;
            this.allDataObjects.add(metaDataObject);
            if (metaDataObject.getTableCollection() != null) {
                for (MetaTable metaTable : metaDataObject.getTableCollection()) {
                    if (!metaTable.isPersist().booleanValue()) continue;
                    String tableName2 = metaTable.getBindingDBTableName();
                    this.putTable2DataObject(tableName2, metaDataObject);
                }
            }
            if (metaDataObject.getEmbedTables() != null) {
                for (MetaEmbedTable metaEmbedTable : metaDataObject.getEmbedTables()) {
                    MetaTable metaTable = metaFactory.getDataObject(metaEmbedTable.getObjectKey()).getTable(metaEmbedTable.getTableKeys());
                    if (!metaTable.isPersist().booleanValue()) continue;
                    String tableName3 = metaTable.getBindingDBTableName();
                    this.putTable2DataObject(tableName3, metaDataObject);
                }
            }
            if (metaDataObject.getSecondaryType() != 6) continue;
            MetaTable table = metaDataObject.getErpMigrationNewTable();
            if (table != null) {
                tableName = table.getBindingDBTableName();
                this.putTable2DataObject(tableName, metaDataObject);
            }
            if ((table = metaDataObject.getErpMigrationIncrTable()) != null) {
                tableName = table.getBindingDBTableName();
                this.putTable2DataObject(tableName, metaDataObject);
            }
            if ((table = metaDataObject.getErpMigrationKeysTable()) != null) {
                tableName = table.getBindingDBTableName();
                this.putTable2DataObject(tableName, metaDataObject);
            }
            if ((table = metaDataObject.getMigrationLastPointTable()) != null) {
                tableName = table.getBindingDBTableName();
                this.putTable2DataObject(tableName, metaDataObject);
            }
            if ((table = metaDataObject.getErpMigrationKeysPreTable()) != null) {
                tableName = table.getBindingDBTableName();
                this.putTable2DataObject(tableName, metaDataObject);
            }
            if ((table = metaDataObject.getErpMigrationNewPreTable()) != null) {
                tableName = table.getBindingDBTableName();
                this.putTable2DataObject(tableName, metaDataObject);
            }
            if (!bInitByDesign) continue;
            DataObjects.updateMDGroupColumnKeys(metaDataObject);
        }
    }

    public List<MetaDataObject> getAllDataObject() {
        return this.allDataObjects;
    }

    private static List<MetaDataObject> getAllMetaDataObject(IMetaFactory metaFactory) throws Throwable {
        ArrayList<MetaDataObject> allMetaDataObjects = new ArrayList<MetaDataObject>();
        for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
            MetaDataObject metaDataObject;
            MetaForm metaForm = metaFactory.getMetaForm(metaFormProfile.getKey());
            MetaDataSource metaDataSource = metaForm.getDataSource();
            if (metaDataSource == null || (metaDataObject = metaDataSource.getDataObject()) == null || allMetaDataObjects.contains(metaDataObject)) continue;
            allMetaDataObjects.add(metaDataObject);
        }
        for (MetaDataObjectProfile dataObjectProfile : metaFactory.getDataObjectList()) {
            MetaDataObject metaDataObject = metaFactory.getDataObject(dataObjectProfile.getKey());
            if (metaDataObject == null || allMetaDataObjects.contains(metaDataObject)) continue;
            allMetaDataObjects.add(metaDataObject);
        }
        return allMetaDataObjects;
    }

    public List<MetaDataObject> getDataObjectsByTableName(String tableName) {
        if (this.tableToDataObject == null) {
            return Collections.emptyList();
        }
        return (List)this.tableToDataObject.get(tableName);
    }

    public LinkedHashMapIgnoreCase<MetaColumn> getColumnsByTableName(String tableName) {
        LinkedHashMapIgnoreCase result = (LinkedHashMapIgnoreCase)this.columns.get(tableName);
        if (result == null) {
            String itemTableName;
            List<MetaDataObject> itemDataObjects;
            List<MetaDataObject> dataObjects = this.getDataObjectsByTableName(tableName);
            if (dataObjects != null) {
                for (MetaDataObject dataObject : dataObjects) {
                    for (MetaTable table : dataObject.getTableCollection()) {
                        if (result == null) {
                            result = new LinkedHashMapIgnoreCase();
                        }
                        DataObjects.addColumnIfKeyMatch(tableName, (LinkedHashMapIgnoreCase<MetaColumn>)result, table);
                    }
                    if (dataObject.getSecondaryType() != 6) continue;
                    if (result == null) {
                        result = new LinkedHashMapIgnoreCase();
                    }
                    DataObjects.addColumnIfKeyMatch(tableName, (LinkedHashMapIgnoreCase<MetaColumn>)result, dataObject.getMigrationLastPointTable());
                    if (dataObject.getMigrationUpdateStrategy() != 5) continue;
                    DataObjects.addColumnIfKeyMatch(tableName, (LinkedHashMapIgnoreCase<MetaColumn>)result, dataObject.getErpMigrationNewTable());
                    DataObjects.addColumnIfKeyMatch(tableName, (LinkedHashMapIgnoreCase<MetaColumn>)result, dataObject.getErpMigrationIncrTable());
                    DataObjects.addColumnIfKeyMatch(tableName, (LinkedHashMapIgnoreCase<MetaColumn>)result, dataObject.getErpMigrationKeysTable());
                }
            } else if (StringUtils.endsWithIgnoreCase((CharSequence)tableName, (CharSequence)"_RR")) {
                String itemTableName2 = tableName.substring(0, tableName.length() - "_RR".length());
                List<MetaDataObject> itemDataObjects2 = this.getDataObjectsByTableName(itemTableName2);
                if (itemDataObjects2 != null) {
                    for (MetaDataObject dataObject : itemDataObjects2) {
                        int secondaryType = dataObject.getSecondaryType();
                        if (secondaryType != 3 && secondaryType != 5) continue;
                        for (MetaTable table : dataObject.getTableCollection()) {
                            if (!itemTableName2.equalsIgnoreCase(table.getKey())) continue;
                            if (result == null) {
                                result = new LinkedHashMapIgnoreCase();
                            }
                            DataObjects.addColumnIfKeyMatch(tableName, (LinkedHashMapIgnoreCase<MetaColumn>)result, DataObjects.newRRTable(tableName));
                        }
                    }
                }
            } else if (StringUtils.endsWithIgnoreCase((CharSequence)tableName, (CharSequence)"_OR") && (itemDataObjects = this.getDataObjectsByTableName(itemTableName = tableName.substring(0, tableName.length() - "_OR".length()))) != null) {
                for (MetaDataObject dataObject : itemDataObjects) {
                    int secondaryType = dataObject.getSecondaryType();
                    if (secondaryType != 3 && secondaryType != 5) continue;
                    for (MetaTable table : dataObject.getTableCollection()) {
                        if (!itemTableName.equalsIgnoreCase(table.getKey())) continue;
                        if (result == null) {
                            result = new LinkedHashMapIgnoreCase();
                        }
                        DataObjects.addColumnIfKeyMatch(tableName, (LinkedHashMapIgnoreCase<MetaColumn>)result, DataObjects.newORTable(tableName));
                    }
                }
            }
            this.columns.put(tableName, (Object)result);
        }
        return result;
    }

    static MetaTable newRRTable(String tableName) {
        assert (StringUtils.endsWithIgnoreCase((CharSequence)tableName, (CharSequence)"_RR"));
        MetaTable rrTable = new MetaTable();
        rrTable.setKey(tableName);
        MetaColumn column = new MetaColumn();
        column.setKey("RoleID");
        column.setDataType(Integer.valueOf(1010));
        rrTable.add((KeyPairMetaObject)column);
        column = new MetaColumn();
        column.setKey("FormKey");
        column.setDataType(Integer.valueOf(1002));
        column.setLength(Integer.valueOf(128));
        rrTable.add((KeyPairMetaObject)column);
        column = new MetaColumn();
        column.setKey("DictID");
        column.setDataType(Integer.valueOf(1010));
        rrTable.add((KeyPairMetaObject)column);
        column = new MetaColumn();
        column.setKey("HasRights");
        column.setDataType(Integer.valueOf(1001));
        rrTable.add((KeyPairMetaObject)column);
        column = new MetaColumn();
        column.setKey("HasRead");
        column.setDataType(Integer.valueOf(1001));
        rrTable.add((KeyPairMetaObject)column);
        column = new MetaColumn();
        column.setKey("HasWrite");
        column.setDataType(Integer.valueOf(1001));
        rrTable.add((KeyPairMetaObject)column);
        return rrTable;
    }

    static MetaTable newORTable(String tableName) {
        assert (StringUtils.endsWithIgnoreCase((CharSequence)tableName, (CharSequence)"_OR"));
        MetaTable orTable = new MetaTable();
        orTable.setKey(tableName);
        MetaColumn column = new MetaColumn();
        column.setKey("OperatorID");
        column.setDataType(Integer.valueOf(1010));
        orTable.add((KeyPairMetaObject)column);
        column = new MetaColumn();
        column.setKey("FormKey");
        column.setDataType(Integer.valueOf(1002));
        column.setLength(Integer.valueOf(128));
        orTable.add((KeyPairMetaObject)column);
        column = new MetaColumn();
        column.setKey("DictID");
        column.setDataType(Integer.valueOf(1010));
        orTable.add((KeyPairMetaObject)column);
        column = new MetaColumn();
        column.setKey("HasRights");
        column.setDataType(Integer.valueOf(1001));
        orTable.add((KeyPairMetaObject)column);
        column = new MetaColumn();
        column.setKey("HasRead");
        column.setDataType(Integer.valueOf(1001));
        orTable.add((KeyPairMetaObject)column);
        column = new MetaColumn();
        column.setKey("HasWrite");
        column.setDataType(Integer.valueOf(1001));
        orTable.add((KeyPairMetaObject)column);
        return orTable;
    }

    private static void addColumnIfKeyMatch(String tableName, LinkedHashMapIgnoreCase<MetaColumn> result, MetaTable table) {
        if (table != null && table.getKey().equalsIgnoreCase(tableName)) {
            for (MetaColumn column : table) {
                if (column.isHidden().booleanValue() || !column.isPersist().booleanValue() || result.containsKey(column.getBindingDBColumnName())) continue;
                result.put(column.getBindingDBColumnName(), (Object)column);
            }
        }
    }

    public static MetaTable getMetaTableByTableNameIgnoreCase(MetaDataObject dataObject, String tableName) {
        MetaTable result = dataObject.getTable(tableName);
        if (result == null) {
            for (MetaTable metaTable : dataObject.getTableCollection()) {
                if (!metaTable.isPersist().booleanValue() || !metaTable.getKey().equalsIgnoreCase(tableName)) continue;
                result = metaTable;
                break;
            }
        }
        return result;
    }

    public static MetaDataObject getDataObject(String headTableName, String tableName) throws Throwable {
        DataObjects instance = DataObjects.getInstance();
        List<MetaDataObject> dataObjects = instance.getDataObjectsByTableName(headTableName);
        for (MetaDataObject dataObject : dataObjects) {
            if (!((MetaTable)dataObject.getTableCollection().get(0)).getKey().equalsIgnoreCase(headTableName) || DataObjects.getMetaTableByTableNameIgnoreCase(dataObject, tableName) == null) continue;
            return dataObject;
        }
        return null;
    }

    public static MetaDataObject getDataObjectBy2TableNames(String tableName0, String tableName1) {
        DataObjects instance = DataObjects.getInstance();
        List<MetaDataObject> dataObjects = instance.getDataObjectsByTableName(tableName0);
        for (MetaDataObject dataObject : dataObjects) {
            if (DataObjects.getMetaTableByTableNameIgnoreCase(dataObject, tableName1) == null) continue;
            return dataObject;
        }
        return null;
    }

    public static List<String> getHeadTableNames(String tableName) throws Throwable {
        DataObjects instance = DataObjects.getInstance();
        List<MetaDataObject> dataObjects = instance.getDataObjectsByTableName(tableName);
        int size = dataObjects.size();
        ArrayList<String> result = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            String headTableName = ((MetaTable)dataObjects.get(i).getTableCollection().get(0)).getKey();
            if (!result.contains(headTableName)) {
                result.add(headTableName);
            }
            ++i;
        }
        return result;
    }

    public static boolean isHeadTable(String tableName) {
        DataObjects instance = DataObjects.getInstance();
        List<MetaDataObject> dataObjects = instance.getDataObjectsByTableName(tableName);
        if (dataObjects == null) {
            return false;
        }
        int size = dataObjects.size();
        int i = 0;
        while (i < size) {
            MetaDataObject dataObject = dataObjects.get(i);
            MetaTable mainTable = dataObject.getMainTable();
            if (mainTable != null) {
                if (!tableName.equalsIgnoreCase(mainTable.getBindingDBTableName())) {
                    return false;
                }
            } else {
                MetaTableCollection metaTables = dataObject.getTableCollection();
                int j = 0;
                int tableSize = metaTables.size();
                while (j < tableSize) {
                    MetaTable metaTable = (MetaTable)metaTables.get(j);
                    if (!metaTable.isPersist().booleanValue()) {
                        if (!tableName.equalsIgnoreCase(metaTable.getBindingDBTableName())) break;
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return size > 0;
    }

    public static boolean isNoBusinessForm() {
        String STR_FormKeyInThreadLocal = "FormKeyInThreadLocal";
        return "SU_ToolsForm".equalsIgnoreCase((String)MidVEUtil.getThreadLocalData().get("FormKeyInThreadLocal"));
    }

    public static void updateMDGroupColumnKeys(MetaDataObject dataObject) throws Throwable {
        if (!MdbDSNItems.instance.isEmpty() && dataObject.getMigrationUpdateStrategy() == 5 && ProcessKeysMigrateDataObject.updateMDGroupColumnKeys(dataObject)) {
            MigrationStruct.remove(dataObject.getKey());
        }
    }

    public static void main(String[] args) throws Throwable {
        String solutionPath = "C:/src/erp/sourceV2/solution";
        DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
        DefaultMetaFactory metaFactory = new DefaultMetaFactory((IMetaResolverFactory)metaResolverFactory);
        metaFactory.getSolution();
        MetaFactory.setGlobalInstance((IMetaFactory)metaFactory);
        DataObjects dataObjectPackages = DataObjects.getInstance();
        dataObjectPackages.report();
    }

    /* synthetic */ DataObjects(DataObjects dataObjects) {
        this();
    }

    private static class DataObjectsHolder {
        private static final DataObjects instance = new DataObjects(null);

        private DataObjectsHolder() {
        }
    }
}

