/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.mysqls.group.DateGroupField;
import com.bokesoft.yes.mid.mysqls.group.DictGroupField;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupTable;
import com.bokesoft.yes.mid.mysqls.group.HeadDetailTable;
import com.bokesoft.yes.mid.mysqls.group.NormalGroupField;
import com.bokesoft.yes.mid.mysqls.group.RelationTable;
import com.bokesoft.yes.mid.mysqls.group.SysGroupField;
import com.bokesoft.yes.mid.mysqls.group.YearGroupField;
import com.bokesoft.yes.mid.mysqls.group.YearMonthGroupField;
import com.bokesoft.yes.mid.mysqls.route.meta.type.EGroupFieldType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class Groups
implements Iterable<Group> {
    public static final String DictGroupFields = "DictGroupFields";
    public static final String DateGroupField = "DateGroupField";
    public static final String GroupField = "GroupField";
    public static final String Tables = "Tables";
    public static final String TableName = "TableName";
    public static final String RelationTables = "RelationTables";
    public static final String DetailTableExtras = "DetailTableExtras";
    public static final String YearGroupField = "YearGroupField";
    public static final String YearMonthGroupField = "YearMonthGroupField";
    public static final String SysGroupField = "SysGroupField";
    List<Group> groups = new ArrayList<Group>();

    public void addGroup(Group group) {
        this.groups.add(group);
    }

    static Group loadGroupValue(Element element) {
        Field[] filed1;
        String groupKey = element.getAttribute("key");
        Group group = new Group(groupKey);
        List childList = DomHelper.getChildList((Element)element);
        Iterator it = childList.iterator();
        StringHashMap fieldMap = new StringHashMap();
        Field[] fieldArray = filed1 = Group.class.getDeclaredFields();
        int n = filed1.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            f.setAccessible(true);
            fieldMap.put((Object)f.getName().toLowerCase(), (Object)f);
            ++n2;
        }
        while (it.hasNext()) {
            String DefaultValues;
            String key;
            Element childElement = (Element)it.next();
            String tagName = childElement.getTagName();
            if (DictGroupFields.equals(tagName)) {
                List fileds = DomHelper.getChildList((Element)childElement);
                for (Element filed : fileds) {
                    try {
                        key = filed.getAttribute("FieldKey");
                        String value = filed.getAttribute("ItemKey");
                        DictGroupField dictGroupField = new DictGroupField(key, value);
                        group.addGroupField(dictGroupField);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("DictGroupFields \u5bfc\u5165\u5f02\u5e38", e);
                    }
                }
                continue;
            }
            if (Tables.equals(tagName)) {
                List tables = DomHelper.getChildList((Element)childElement);
                for (Element table : tables) {
                    try {
                        String tableName = table.getAttribute("name");
                        String groupColumnNames = table.getAttribute("Fields");
                        group.addTable(tableName, new GroupTable(groupColumnNames.split(",")));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Table \u5bfc\u5165\u5f02\u5e38", e);
                    }
                }
                continue;
            }
            if (DateGroupField.equals(tagName)) {
                try {
                    DateGroupField dateGroupField;
                    String key2 = childElement.getAttribute("FieldKey");
                    DefaultValues = childElement.getAttribute("DefaultValues");
                    if (!StringUtil.isBlankOrNull((String)DefaultValues)) {
                        dateGroupField = new DateGroupField(key2);
                        dateGroupField.setDefaultValues(DefaultValues);
                        group.addGroupField(dateGroupField);
                        continue;
                    }
                    dateGroupField = new DateGroupField(key2);
                    group.addGroupField(dateGroupField);
                    continue;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("dateGroupField \u5bfc\u5165\u5f02\u5e38", throwable);
                }
            }
            if (GroupField.equals(tagName)) {
                try {
                    String key3 = childElement.getAttribute("FieldKey");
                    String type = childElement.getAttribute("Type");
                    NormalGroupField groupField = new NormalGroupField(key3, EGroupFieldType.valueOf(type.toUpperCase()));
                    group.addGroupField(groupField);
                    continue;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("NormalGroupField \u5bfc\u5165\u5f02\u5e38", throwable);
                }
            }
            if (RelationTables.equals(tagName)) {
                List fileds3 = DomHelper.getChildList((Element)childElement);
                for (Element filed : fileds3) {
                    try {
                        String Tablename = filed.getAttribute("name");
                        String Sql = filed.getAttribute("Sql");
                        RelationTable relationTable = new RelationTable(Tablename);
                        relationTable.setSql(Sql);
                        group.addRelationTable(relationTable);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("RelationTable \u5bfc\u5165\u5f02\u5e38", e);
                    }
                }
                continue;
            }
            if (YearMonthGroupField.equals(tagName)) {
                try {
                    YearMonthGroupField yearMonth;
                    String key4 = childElement.getAttribute("FieldKey");
                    DefaultValues = childElement.getAttribute("DefaultValues");
                    if (!StringUtil.isBlankOrNull((String)DefaultValues)) {
                        yearMonth = new YearMonthGroupField(key4);
                        yearMonth.setDefaultValues(DefaultValues);
                        group.addGroupField(yearMonth);
                        continue;
                    }
                    yearMonth = new YearMonthGroupField(key4);
                    group.addGroupField(yearMonth);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("YearMonthGroupField \u5bfc\u5165\u5f02\u5e38", e);
                }
            }
            if (YearGroupField.equals(tagName)) {
                try {
                    String key5 = childElement.getAttribute("FieldKey");
                    YearGroupField year = new YearGroupField(key5);
                    String DefaultValues2 = childElement.getAttribute("DefaultValues");
                    if (!StringUtil.isBlankOrNull((String)DefaultValues2)) {
                        year.setDefaultValues(DefaultValues2);
                    }
                    group.addGroupField(year);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("YearGroupField \u5bfc\u5165\u5f02\u5e38", e);
                }
            }
            if (SysGroupField.equals(tagName)) {
                String key6 = childElement.getAttribute("FieldKey");
                String modPara = childElement.getAttribute("ModPara");
                SysGroupField longGroup = new SysGroupField(key6);
                longGroup.setModPara(TypeConvertor.toInteger((Object)modPara));
                group.addGroupField(longGroup);
                continue;
            }
            if (!DetailTableExtras.equals(tagName)) continue;
            List extraTables = DomHelper.getChildList((Element)childElement);
            for (Element table : extraTables) {
                try {
                    key = table.getAttribute("key");
                    String[] detailTableExtra = key.split(",");
                    group.addDetailTableExtra(new HeadDetailTable(detailTableExtra[0], detailTableExtra[1], detailTableExtra[2]));
                }
                catch (Exception e) {
                    throw new RuntimeException("DetailTableExtra \u5bfc\u5165\u5f02\u5e38", e);
                }
            }
        }
        return group;
    }

    @Override
    public Iterator<Group> iterator() {
        return this.groups.iterator();
    }

    public Group getDefaultGroup() {
        return this.groups.get(0);
    }

    public Group getGroup(String key) {
        for (Group group : this.groups) {
            if (!group.getKey().equals(key)) continue;
            return group;
        }
        return null;
    }

    public Group getGroupByTableName(String tableName) {
        for (Group group : this.groups) {
            if (!group.containGroupTable(tableName)) continue;
            return group;
        }
        return null;
    }

    public String[] getDSNNamesByTableName(String tableName) {
        Group group = this.getGroupByTableName(tableName);
        if (group != null) {
            return group.getAllDSNNames();
        }
        return new String[0];
    }

    public int compare(String groupKey0, String groupKey1) {
        if (groupKey0.equals(groupKey1)) {
            return 0;
        }
        for (Group group : this.groups) {
            if (group.key.equals(groupKey0)) {
                return -1;
            }
            if (!group.key.equals(groupKey1)) continue;
            return 1;
        }
        throw new RuntimeException("\u4f20\u5165\u7684GroupKey\u4e0d\u5b58\u5728;" + groupKey0 + "," + groupKey1);
    }
}

