/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group;

import com.bokesoft.yes.mid.mysqls.group.IntGroupField;
import com.bokesoft.yes.mid.mysqls.route.meta.type.EGroupFieldType;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public class DateGroupField
extends IntGroupField {
    private static int[] days = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public DateGroupField(String key) {
        super(key);
    }

    @Override
    public EGroupFieldType getGroupType() {
        return EGroupFieldType.DATE;
    }

    @Override
    public int[] getValues(int start, int end) {
        if (this.defaultValues != null && end - start > this.defaultValues[this.defaultValues.length - 1] - this.defaultValues[0]) {
            if (start < this.defaultValues[0]) {
                start = Integer.min(this.defaultValues[0], end);
            }
            if (end > this.defaultValues[this.defaultValues.length - 1]) {
                end = Integer.max(this.defaultValues[this.defaultValues.length - 1], start);
            }
        }
        int current = start;
        int currentYear = start / 10000;
        int currentMonth = start / 100 % 100;
        int currentDay = start % 100;
        int endYear = end / 10000;
        int endMonth = end / 100 % 100;
        int endDay = end % 100;
        int estimateCount = (endYear - currentYear) * 366 + (endMonth - currentMonth) * 31 + endDay - currentDay + 12;
        ArrayList<Integer> dateList = new ArrayList<Integer>(estimateCount);
        while (current <= end) {
            dateList.add(current);
            if (currentDay < days[currentMonth - 1]) {
                ++current;
                ++currentDay;
                continue;
            }
            if (currentMonth == 2 && currentDay == 28) {
                if (currentYear % 4 == 0 && currentYear % 100 != 0) {
                    ++current;
                    ++currentDay;
                    continue;
                }
                currentMonth = 3;
                currentDay = 1;
                current = currentYear * 10000 + currentMonth * 100 + currentDay;
                continue;
            }
            if (currentMonth < 12) {
                currentDay = 1;
                current = currentYear * 10000 + ++currentMonth * 100 + currentDay;
                continue;
            }
            currentMonth = 1;
            currentDay = 1;
            current = ++currentYear * 10000 + currentMonth * 100 + currentDay;
        }
        return ArrayUtils.toPrimitive((Integer[])dateList.toArray(new Integer[dateList.size()]));
    }
}

