/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group;

import com.bokesoft.yes.mid.mysqls.execute.ExecuteUtil;
import com.bokesoft.yes.mid.mysqls.group.RefDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.ArrayList;
import java.util.List;

public class DataObjectRelationTable {
    public final String name;
    private List<RefDataObject> refDataObjects = new ArrayList<RefDataObject>();
    String[] headTableNames;

    public DataObjectRelationTable(String name) {
        this.name = name;
    }

    public void addRefDataObject(RefDataObject refDataObject) {
        this.refDataObjects.add(refDataObject);
    }

    public List<RefDataObject> getRefDataObjects() {
        return this.refDataObjects;
    }

    public String getQuerySql(IDBManager dbm, String tableName) throws Throwable {
        if (!this.isTableValid(tableName)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(1024).append("SELECT ").append(ExecuteUtil.getAllColumnName(dbm, this.name)).append(" FROM ");
        dbm.appendKeyWordEscape(sb, this.name).append(" WHERE ");
        RefDataObject refDataObject0 = this.refDataObjects.get(0);
        sb.append(refDataObject0.refSOIDColumnName).append("=?");
        int i = 1;
        int size = this.refDataObjects.size();
        while (i < size) {
            sb.append(" OR ").append(this.refDataObjects.get((int)i).refSOIDColumnName).append("=?");
            ++i;
        }
        return sb.toString();
    }

    private boolean isTableValid(String tableName) throws Throwable {
        for (RefDataObject refDataObject : this.refDataObjects) {
            if (refDataObject.refKeyColumnName == null || refDataObject.refKeyColumnName.length() <= 0) continue;
            return true;
        }
        for (RefDataObject refDataObject : this.refDataObjects) {
            String dataObjectKey = refDataObject.refKey;
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            if (!((MetaTable)metaFactory.getDataObject(dataObjectKey).getTableCollection().get(0)).getKey().equalsIgnoreCase(tableName)) continue;
            return true;
        }
        return false;
    }

    public boolean maybeHasDataObject(String dataObjectKey) {
        for (RefDataObject refDataObject : this.refDataObjects) {
            if ((refDataObject.refKeyColumnName == null || refDataObject.refKeyColumnName.length() <= 0) && !dataObjectKey.equals(refDataObject.refKey)) continue;
            return true;
        }
        return false;
    }
}

