/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.dbstruct;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.mysqls.dbstruct.DBStruct;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SchemaCheck {
    private MetaSchemaTable table;

    public SchemaCheck(MetaSchemaTable table) {
        this.table = table;
    }

    public List<MetaSchemaColumn> checkTable(String dsnName, DBStruct dbStruct) throws Throwable {
        MetaSchemaColumn metaColumn;
        HashMapIgnoreCase<String> columns = DBStruct.getComfirmedColumns(dsnName, this.table.getKey());
        Iterator iterator = this.table.getColumnCollection().iterator();
        ArrayList<MetaSchemaColumn> list = new ArrayList<MetaSchemaColumn>();
        while (iterator.hasNext()) {
            metaColumn = (MetaSchemaColumn)iterator.next();
            if (columns != null && columns.containsKey(metaColumn.getKey())) continue;
            list.add(metaColumn);
        }
        if (list.size() > 0 && dbStruct.reloadTableStruct(dsnName, this.table.getKey())) {
            columns = DBStruct.getComfirmedColumns(dsnName, this.table.getKey());
            iterator = this.table.getColumnCollection().iterator();
            list.clear();
            while (iterator.hasNext()) {
                metaColumn = (MetaSchemaColumn)iterator.next();
                if (columns != null && columns.containsKey(metaColumn.getKey())) continue;
                list.add(metaColumn);
            }
        }
        return list;
    }

    public List<MetaIndex> checkIndex(String dsnName, DBStruct dbStruct) throws Throwable {
        MetaIndex metaColumn;
        HashMapIgnoreCase<String> indexes = DBStruct.getConfirmedIndexes(dsnName, this.table.getKey());
        Iterator iterator = this.table.getIndexCollection().iterator();
        ArrayList<MetaIndex> list = new ArrayList<MetaIndex>();
        while (iterator.hasNext()) {
            metaColumn = (MetaIndex)iterator.next();
            if (indexes.containsKey(metaColumn.getKey().toUpperCase())) continue;
            list.add(metaColumn);
        }
        if (list.size() > 0 && dbStruct.reloadTableStruct(dsnName, this.table.getKey())) {
            indexes = DBStruct.getConfirmedIndexes(dsnName, this.table.getKey());
            iterator = this.table.getIndexCollection().iterator();
            list.clear();
            while (iterator.hasNext()) {
                metaColumn = (MetaIndex)iterator.next();
                if (indexes.containsKey(metaColumn.getKey().toUpperCase())) continue;
                list.add(metaColumn);
            }
        }
        return list;
    }
}

