/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.migration.process;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil;
import com.bokesoft.yes.mid.migration.groupkeys.RowData;
import com.bokesoft.yes.mid.migration.period.DataTableBatchPsPara;
import com.bokesoft.yes.mid.migration.period.MigrationStruct;
import com.bokesoft.yes.mid.migration.period.PeriodUtil;
import com.bokesoft.yes.mid.migration.process.MDBKeysTableSaveData;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.migration.IPeriodProcess;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class KeysTableSaveData {
    private static final Map<String, Lock> locks = new ConcurrentHashMap<String, Lock>();

    public void batchUpdateData(DefaultContext context, MetaDataObject tgtDataObject, DataTable changeData) throws Throwable {
        Object[] actions = new Object[]{"batchUpdateData:", tgtDataObject.getKey()};
        int action = Performance.startAction((Object[])actions);
        MigrationStruct struct = MigrationStruct.get(tgtDataObject.getKey());
        RowData[] rowDatas = this.saveKeysTable(context, changeData, struct);
        this.saveIncrTable(context, changeData, struct, rowDatas);
        Performance.endActive((int)action, (Object[])actions);
    }

    public static ICache<Object> getCache(MigrationStruct struct) throws Throwable {
        return KeysTableSaveData.getCache(struct, null);
    }

    public static ICache<Object> getCache(MigrationStruct struct, String dsnName) throws Throwable {
        String keysTableName = struct.getKeysTableName();
        ICache balanceGidCache = CacheFactory.getInstance().createCache(dsnName == null ? keysTableName : String.valueOf(keysTableName) + dsnName);
        return balanceGidCache;
    }

    public RowData[] saveKeysTable(DefaultContext context, DataTable dataTable, MigrationStruct struct) throws Throwable {
        if (context.getDBManager() instanceof MultiDBManager && TableGroupProps.getInstance().getTableGroupProp(struct.getNewTableName()) != null) {
            return new MDBKeysTableSaveData().saveKeysTable(context, dataTable, struct);
        }
        int dataTableSize = dataTable.size();
        RowData[] result = new RowData[dataTableSize];
        Object[][] keyValuesArray = new Object[dataTableSize][struct.getMetaGroupColumnsForGroupID().size()];
        MDBKeysTableSaveData.loadData(dataTable, struct, result, keyValuesArray);
        this.saveKeysTable(context, result, keyValuesArray, struct);
        return result;
    }

    private void saveKeysTable(DefaultContext context, RowData[] rowDatas, Object[][] keyValuesArray, MigrationStruct struct) throws Throwable {
        if (keyValuesArray.length == 0) {
            return;
        }
        int keyValueCount = keyValuesArray[0].length;
        ICache<Object> balanceGidCache = KeysTableSaveData.getCache(struct);
        int notFoundInCache = MDBKeysTableSaveData.loadGroupFromCache(balanceGidCache, rowDatas, keyValuesArray);
        if (notFoundInCache > 0) {
            Lock lock = locks.computeIfAbsent(struct.getKeysTableName(), reentrantLock -> new ReentrantLock());
            lock.lock();
            try {
                RowData[] notFoundRowDatas = MDBKeysTableSaveData.getGroupIDEqualZeroRowDatas(rowDatas, notFoundInCache);
                DataTable keysDBData = this.loadKeysFromDB(context, notFoundRowDatas, struct, keyValuesArray);
                int notFoundInDB = MDBKeysTableSaveData.getGroupIDIntoRowDatas(struct, keysDBData, notFoundRowDatas, keyValuesArray);
                MDBKeysTableSaveData.saveKeysDataInCache(keysDBData, balanceGidCache, keyValueCount);
                if (notFoundInDB > 0) {
                    RowData[] notfoundInDBRowDatas = MDBKeysTableSaveData.getGroupIDEqualZeroRowDatas(notFoundRowDatas, notFoundInDB);
                    DataTable insertKeysDB = MDBKeysTableSaveData.genInsertKeys(context, notfoundInDBRowDatas, keyValuesArray, struct);
                    this.saveInsertKeysInDB(context, insertKeysDB, struct);
                    MDBKeysTableSaveData.saveKeysDataInCache(insertKeysDB, balanceGidCache, keyValueCount);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private DataTable loadKeysFromDB(DefaultContext context, RowData[] rowDatas, MigrationStruct struct, Object[][] keyValuesArray) throws Throwable {
        List<Object> notFoundHashCodes = MDBKeysTableSaveData.getHashCodeList(struct, rowDatas, keyValuesArray);
        String fullLoadSql = struct.getLoadGroupIDFromKeysByHashCodeSql(notFoundHashCodes.size());
        DataTable keysDBData = context.getDBManager().execPrepareQuery(fullLoadSql, notFoundHashCodes);
        return keysDBData;
    }

    private void saveInsertKeysInDB(DefaultContext context, DataTable insertKeysCurDB, MigrationStruct struct) throws Throwable {
        if (insertKeysCurDB.size() == 0) {
            return;
        }
        RefObject argumentSize = new RefObject((Object)0);
        String insertSql = struct.getInsertKeysSql((RefObject<Integer>)argumentSize);
        DataTableBatchPsPara batchPsPara = new DataTableBatchPsPara(insertSql, insertKeysCurDB, (Integer)argumentSize.getValue());
        try (IDBManager dbManager = null;){
            dbManager = context.newDBManager();
            dbManager.executeUpdate((BatchPsPara)batchPsPara);
            dbManager.commit();
        }
    }

    private void saveIncrTable(DefaultContext context, DataTable changeData, MigrationStruct struct, RowData[] rowDatas) throws Throwable {
        DataTable incrDataTable = new DataTable(struct.getIncrDataTableMetaData());
        int oidColumnIndex = struct.getIncrOIDColumnIndex();
        int[][] splitDataColumnIndexes = struct.getIncrSplitDataColumnIndexes();
        int[] beginColumnIndexes = struct.getIncrBeginColumnIndexes();
        int[] endColumnIndexes = struct.getIncrEndColumnIndexes();
        int[][] dataNoSplitColumnIndexes = struct.getIncrDataNoSplitColumnIndexes();
        int[] periodColumnIndex = struct.getIncrPeriodColumnIndex();
        int groupIDColumnIndex = struct.getIncrGroupIDColumnIndex();
        int[][] periodGroupColumnIndexes = struct.getIncrPeriodGroupColumnIndexes();
        int splitDataColumnSize = beginColumnIndexes.length;
        int[][] groupColumnIndexesForIncrTable = this.getGroupColumnIndexForIncrTable(struct.getIncrDataTableMetaData(), struct.getMetaGroupColumns(), changeData.getMetaData());
        int rowIndex = 0;
        int len = changeData.size();
        while (rowIndex < len) {
            int size;
            int j;
            int newRowIndex = incrDataTable.append();
            Object[] newDataList = incrDataTable.getRowByIndex(newRowIndex).getDataList();
            newDataList[oidColumnIndex] = context.applyNewOID();
            Object[] orgDataList = changeData.getRowByIndex(rowIndex).getDataList();
            if (periodColumnIndex[0] >= 0) {
                newDataList[periodColumnIndex[0]] = orgDataList[periodColumnIndex[1]];
                j = 0;
                size = periodGroupColumnIndexes[0].length;
                while (j < size) {
                    newDataList[periodGroupColumnIndexes[0][j]] = orgDataList[periodGroupColumnIndexes[1][j]];
                    ++j;
                }
            }
            newDataList[groupIDColumnIndex] = rowDatas[rowIndex].getGroupId();
            j = 0;
            size = dataNoSplitColumnIndexes[0].length;
            while (j < size) {
                Object tmp = orgDataList[dataNoSplitColumnIndexes[1][j]];
                newDataList[dataNoSplitColumnIndexes[0][j]] = tmp == null ? Integer.valueOf(0) : tmp;
                ++j;
            }
            j = 0;
            while (j < splitDataColumnSize) {
                Object tmp = orgDataList[splitDataColumnIndexes[1][j]];
                newDataList[splitDataColumnIndexes[0][j]] = tmp == null ? Integer.valueOf(0) : tmp;
                newDataList[endColumnIndexes[j]] = tmp == null ? Integer.valueOf(0) : tmp;
                newDataList[beginColumnIndexes[j]] = 0;
                ++j;
            }
            int k = 0;
            size = groupColumnIndexesForIncrTable[0].length;
            while (k < size) {
                int index = groupColumnIndexesForIncrTable[1][k];
                if (index >= 0) {
                    Object tmp = orgDataList[index];
                    newDataList[groupColumnIndexesForIncrTable[0][k]] = tmp == null ? Integer.valueOf(0) : tmp;
                }
                ++k;
            }
            ++rowIndex;
        }
        MetaColumn periodColumn = struct.getMetaPeriodColumn();
        if (periodColumn != null) {
            IPeriodProcess periodProcess = this.getPeriodImpl(context, periodColumn);
            List<MetaColumn> metaPeriodGroupColumns = struct.getMetaPeriodGroupColumns();
            int periodGroupColumnSize = metaPeriodGroupColumns.size();
            String[] periodGroupColumnNames = new String[periodGroupColumnSize];
            int i = 0;
            while (i < periodGroupColumnSize) {
                periodGroupColumnNames[i] = metaPeriodGroupColumns.get(i).getBindingDBColumnName();
                ++i;
            }
            String loadLastPoindSql = struct.getLoadLastPointSql();
            Object[][] periodGroupValueses = changeData.fastDistinctValues(periodGroupColumnNames);
            int i2 = 0;
            int size = periodGroupValueses.length;
            while (i2 < size) {
                DataTable lpDataTable = context.getDBManager().execPrepareQuery(loadLastPoindSql, Arrays.asList(periodGroupValueses[i2]));
                if (lpDataTable != null && lpDataTable.first()) {
                    int maxPeriod = lpDataTable.getInt(0, 0);
                    int[] rowIndexes = changeData.fastFilter(periodGroupColumnNames, periodGroupValueses[i2]);
                    int minPeriod = DataTableExUtil.getMinIntValue(changeData, rowIndexes, periodColumnIndex[1]);
                    HashMap<String, Object> groupFieldValue = new HashMap<String, Object>();
                    int j = 0;
                    while (j < periodGroupColumnSize) {
                        groupFieldValue.put(periodGroupColumnNames[j], periodGroupValueses[i2][j]);
                        ++j;
                    }
                    ArrayList afterPeriodList = new ArrayList();
                    periodProcess.getBetweenPeriod(context, (Object)minPeriod, (Object)maxPeriod, periodColumn.getPeriodGranularity().intValue(), groupFieldValue, afterPeriodList);
                    int j2 = 0;
                    int rowIndexSize = rowIndexes.length;
                    while (j2 < rowIndexSize) {
                        int periodValue = changeData.getInt(rowIndexes[j2], periodColumnIndex[1]);
                        if (periodValue < maxPeriod) {
                            int newRowIndex = incrDataTable.append();
                            Object[] newDataList = incrDataTable.getRowByIndex(newRowIndex).getDataList();
                            newDataList[oidColumnIndex] = context.applyNewOID();
                            newDataList[periodColumnIndex[0]] = maxPeriod;
                            Object[] orgDataList = changeData.getRowByIndex(rowIndexes[j2]).getDataList();
                            int k = 0;
                            int sizeK = periodGroupColumnIndexes[0].length;
                            while (k < sizeK) {
                                newDataList[periodGroupColumnIndexes[0][k]] = orgDataList[periodGroupColumnIndexes[1][k]];
                                ++k;
                            }
                            newDataList[groupIDColumnIndex] = rowDatas[rowIndexes[j2]].getGroupId();
                            int[] nArray = dataNoSplitColumnIndexes[0];
                            int n = nArray.length;
                            sizeK = 0;
                            while (sizeK < n) {
                                int columnIndex = nArray[sizeK];
                                newDataList[columnIndex] = 0;
                                ++sizeK;
                            }
                            k = 0;
                            while (k < splitDataColumnSize) {
                                Object tmp = orgDataList[splitDataColumnIndexes[1][k]];
                                newDataList[splitDataColumnIndexes[0][k]] = 0;
                                newDataList[beginColumnIndexes[k]] = tmp == null ? Integer.valueOf(0) : tmp;
                                newDataList[endColumnIndexes[k]] = tmp == null ? Integer.valueOf(0) : tmp;
                                ++k;
                            }
                            for (Object periodTmp : afterPeriodList) {
                                int otherPeriod = TypeConvertor.toInteger(periodTmp);
                                if (otherPeriod <= periodValue || otherPeriod >= maxPeriod) continue;
                                int newOtherRowIndex = incrDataTable.append();
                                Object[] newOtherDataList = incrDataTable.getRowByIndex(newOtherRowIndex).getDataList();
                                System.arraycopy(newDataList, 0, newOtherDataList, 0, newDataList.length);
                                newOtherDataList[oidColumnIndex] = context.applyNewOID();
                                newOtherDataList[periodColumnIndex[0]] = otherPeriod;
                            }
                        }
                        ++j2;
                    }
                }
                ++i2;
            }
        }
        IDBManager dbm = context.getDBManager();
        MetaTable incrTable = struct.metaDataObject.getErpMigrationIncrTable();
        dbm.saveDataTable(incrDataTable, struct.getIncrTableName(), incrTable, null);
    }

    private int[][] getGroupColumnIndexForIncrTable(DataTableMetaData incrDataTableMetaData, List<MetaColumn> metaGroupColumns, DataTableMetaData changeDataTableMetaData) {
        int count = 0;
        for (MetaColumn column : metaGroupColumns) {
            if (incrDataTableMetaData.findColumnIndexByKey(column.getKey()) < 0) continue;
            ++count;
        }
        int[][] tmp = new int[2][count];
        int i = 0;
        DataTableMetaData incrMetaData = incrDataTableMetaData;
        DataTableMetaData changeMetaData = changeDataTableMetaData;
        for (MetaColumn metaColumn : metaGroupColumns) {
            String columnName = metaColumn.getBindingDBColumnName();
            int columnIndexByKey = incrMetaData.findColumnIndexByKey(columnName);
            if (columnIndexByKey < 0) continue;
            tmp[0][i] = incrMetaData.findColumnIndexByKey(columnName);
            tmp[1][i] = changeMetaData.findColumnIndexByKey(columnName);
            ++i;
        }
        return tmp;
    }

    private IPeriodProcess getPeriodImpl(DefaultContext context, MetaColumn periodColumn) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String periodImpl = periodColumn.getPeriodImpl();
        Object periodProcess = periodImpl != null && !periodImpl.isEmpty() ? (IPeriodProcess)ReflectHelper.newInstance((VE)context.getVE(), (String)periodImpl) : new PeriodUtil();
        return periodProcess;
    }
}

