/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.migration.period;

import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.connection.DBUtil;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.migration.period.DataTableBatchPsPara;
import com.bokesoft.yes.mid.migration.period.MigrationStruct;
import com.bokesoft.yes.mid.mysqls.group.OneGroupValue;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.migration.IPeriodProcess;
import com.bokesoft.yigo.mid.util.DBManagerUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PeriodMigrationDBIOForErp {
    private MetaDataObject migrationMetaDataObject = null;
    protected ArrayList<MetaColumn> periodGroupFields = new ArrayList();
    protected ArrayList<MetaColumn> dataFields = new ArrayList();
    protected ArrayList<MetaColumn> balanceFields = new ArrayList();
    protected MetaColumn periodField = null;
    private MetaTable mainMetaTable;
    private MetaTable newMetaTable;
    private MetaTable lpMetaTable;
    private ArrayList<Object> periodList;
    private ArrayList<MetaColumn> migrationSYSFields = null;

    public PeriodMigrationDBIOForErp(MetaDataObject migrationMetaDataObject) throws Throwable {
        this.migrationMetaDataObject = migrationMetaDataObject;
        this.mainMetaTable = this.migrationMetaDataObject.getMainTable();
        this.newMetaTable = this.migrationMetaDataObject.getErpMigrationNewTable();
        this.lpMetaTable = this.migrationMetaDataObject.getMigrationLastPointTable();
        this.analyseMigration(this.mainMetaTable);
    }

    private void analyseMigration(MetaTable migrationMainMetaTable) {
        MetaColumn metaColumn2 = null;
        ArrayList<MetaColumn> systemColumn = this.getMigrationSYSField(migrationMainMetaTable);
        for (MetaColumn metaColumn2 : migrationMainMetaTable) {
            if (systemColumn.contains(metaColumn2)) continue;
            if (metaColumn2.isGroup()) {
                if (metaColumn2.getGroupType() == 1) {
                    this.periodField = metaColumn2;
                    continue;
                }
                if (metaColumn2.getGroupType() != 2) continue;
                this.periodGroupFields.add(metaColumn2);
                continue;
            }
            if (metaColumn2.getSplitType() == 0) {
                this.balanceFields.add(metaColumn2);
                continue;
            }
            this.dataFields.add(metaColumn2);
        }
    }

    public void periodRollData(DefaultContext context, Object endPeriod, HashMap<String, MetaColumn> periodGroupFieldsMap, Map<String, Object> group, DataTable periodDataTable, Object minPeriod, IPeriodProcess periodProcess) throws Throwable {
        group = this.getConditionMap(periodGroupFieldsMap, group);
        HashMap<String, Object> periodGroupFieldValue = new HashMap<String, Object>();
        for (MetaColumn column : this.periodGroupFields) {
            periodGroupFieldValue.put(column.getBindingDBColumnName(), periodDataTable.getObject(column.getBindingDBColumnName()));
        }
        Object maxPeriod = endPeriod instanceof Date ? periodProcess.getPeriodValue(context, (Date)endPeriod, this.periodField.getPeriodGranularity().intValue(), periodGroupFieldValue) : periodProcess.getPeriodValue(context, periodProcess.getFirstDateOfPeriod(context, endPeriod, this.periodField.getPeriodGranularity().intValue(), periodGroupFieldValue), this.periodField.getPeriodGranularity().intValue(), periodGroupFieldValue);
        this.periodList = new ArrayList();
        periodProcess.getBetweenPeriod(context, minPeriod, maxPeriod, this.periodField.getPeriodGranularity().intValue(), periodGroupFieldValue, this.periodList);
        IDBManager dbm = context.getDBManager();
        MigrationStruct struct = MigrationStruct.get(this.migrationMetaDataObject.getKey());
        boolean isSplitDB = dbm instanceof MultiDBManager && TableGroupProps.getInstance().getTableGroupProp(struct.getNewTableName()) != null;
        int i = 0;
        int len = this.periodList.size();
        while (i < len - 1) {
            IDBManager dbmOneDBWhenSplitDB = null;
            boolean hasPreviousPeroidDataTmpTable = false;
            if (isSplitDB) {
                String curDSNName;
                String previousDSNName = this.calcDSNName(context, struct, group, i);
                if (!previousDSNName.equals(curDSNName = this.calcDSNName(context, struct, group, i + 1))) {
                    hasPreviousPeroidDataTmpTable = this.copyPreviousNewDataInTmp(context, previousDSNName, curDSNName, struct, group, i);
                }
                MultiDBManager multiDBManager = (MultiDBManager)context.getDBManager();
                dbmOneDBWhenSplitDB = multiDBManager.getDBManagerByDsnName(curDSNName);
                dbmOneDBWhenSplitDB.getCacheDBRequest().stopLocalIsUseCacheDB();
                dbm = dbmOneDBWhenSplitDB;
            }
            this.insertCurrentPeriodGroupValueRecords(context, dbm, group, i, struct, hasPreviousPeroidDataTmpTable);
            this.updateEndPeriodValue(dbm, group, i);
            this.updateBeginPeriodValue(dbm, group, i, struct, hasPreviousPeroidDataTmpTable);
            this.updateSecondEndPeriodValue(dbm, group, i);
            this.deleteZeroValueRecords(dbm, group);
            dbm = context.getDBManager();
            this.updateLastPoint(context, dbm, group, this.periodList.get(i + 1));
            if (hasPreviousPeroidDataTmpTable) {
                this.clearTempData(struct, dbm);
            }
            ++i;
        }
    }

    public void updateLastPoint(DefaultContext context, IDBManager newDbm, Map<String, Object> group, Object targetPeriodValue) throws Throwable {
        SqlString querySql = new SqlString();
        querySql.append(" select count(OID) records from ").append(this.lpMetaTable.getBindingDBTableName());
        boolean firstWhereClause = true;
        for (MetaColumn column : this.periodGroupFields) {
            if (!group.containsKey(column.getBindingDBColumnName())) continue;
            querySql.append(firstWhereClause ? " where " : " and ").append(column.getBindingDBColumnName()).append(" = ");
            firstWhereClause = false;
            querySql.appendPara(group.get(column.getBindingDBColumnName()));
        }
        DataTable queryDt = newDbm.execPrepareQuery(querySql.getSql(), querySql.getParameterList());
        int reconds = queryDt.getInt(0, "records");
        if (reconds > 0) {
            SqlString updateSql = new SqlString();
            updateSql.append(" update ").append(this.lpMetaTable.getBindingDBTableName());
            updateSql.append(" set ").append(this.periodField.getBindingDBColumnName());
            updateSql.append(" = ").appendPara(targetPeriodValue);
            firstWhereClause = true;
            for (MetaColumn column : this.periodGroupFields) {
                if (!group.containsKey(column.getBindingDBColumnName())) continue;
                updateSql.append(firstWhereClause ? " where " : " and ").append(column.getBindingDBColumnName()).append(" = ");
                firstWhereClause = false;
                updateSql.appendPara(group.get(column.getBindingDBColumnName()));
            }
            newDbm.execPrepareUpdate(updateSql.getSql(), updateSql.getParameterList());
        } else {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("insert into ").append(this.lpMetaTable.getBindingDBTableName()).append("(");
            for (MetaColumn metaColumn : this.lpMetaTable) {
                insertSql.append(metaColumn.getBindingDBColumnName()).append(",");
            }
            insertSql.deleteCharAt(insertSql.lastIndexOf(","));
            ArrayList<Object> list = new ArrayList<Object>();
            insertSql.append(") ");
            insertSql.append(" values(");
            for (MetaColumn metaColumn : this.lpMetaTable) {
                if (metaColumn.getBindingDBColumnName().equals("OID")) {
                    insertSql.append(" ? ").append(",");
                    list.add(context.applyNewOID());
                }
                if (metaColumn.getBindingDBColumnName().equals("VERID")) {
                    insertSql.append(" ? ").append(",");
                    list.add(0);
                }
                for (MetaColumn column : this.periodGroupFields) {
                    if (!column.getBindingDBColumnName().equals(metaColumn.getBindingDBColumnName())) continue;
                    if (group.containsKey(metaColumn.getBindingDBColumnName())) {
                        insertSql.append(" ? ").append(",");
                        list.add(group.get(metaColumn.getBindingDBColumnName()));
                        break;
                    }
                    Object value = "";
                    switch (column.getDataType()) {
                        case 1001: {
                            value = 0;
                            break;
                        }
                        case 1010: {
                            value = 0L;
                            break;
                        }
                        case 1005: 
                        case 1006: 
                        case 1007: {
                            value = 0.0;
                            break;
                        }
                    }
                    insertSql.append(" ? ").append(",");
                    list.add(value);
                    break;
                }
                if (!metaColumn.getBindingDBColumnName().equals(this.periodField.getBindingDBColumnName())) continue;
                insertSql.append(" ? ").append(",");
                list.add(targetPeriodValue);
            }
            insertSql.deleteCharAt(insertSql.lastIndexOf(","));
            insertSql.append(") ");
            newDbm.execPrepareUpdate(insertSql.toString(), list);
        }
    }

    private void deleteZeroValueRecords(IDBManager newDbm, Map<String, Object> group) throws Throwable {
        StringBuilder deleteSql = new StringBuilder();
        deleteSql.append(" delete from ").append(this.newMetaTable.getBindingDBTableName());
        boolean firstWhereClause = true;
        ArrayList<Object> list = new ArrayList<Object>();
        for (MetaColumn metaColumn : this.dataFields) {
            if (metaColumn.getBindingDBColumnName().equals("HasData") || metaColumn.getBindingDBColumnName().equals("Slock") || metaColumn.getBindingDBColumnName().equals("MapCount") || metaColumn.getBindingDBColumnName().equals("GroupId")) continue;
            deleteSql.append(firstWhereClause ? " where " : " and ").append(metaColumn.getBindingDBColumnName()).append(" = ? ");
            list.add(0);
            firstWhereClause = false;
        }
        for (MetaColumn column : this.periodGroupFields) {
            if (!group.containsKey(column.getBindingDBColumnName())) continue;
            deleteSql.append(" and ").append(column.getBindingDBColumnName()).append(" = ");
            deleteSql.append(" ? ");
            list.add(group.get(column.getBindingDBColumnName()));
        }
        newDbm.execPrepareUpdate(deleteSql.toString(), list);
    }

    private void updateSecondEndPeriodValue(IDBManager newDbm, Map<String, Object> group, int i) throws Throwable {
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(this.newMetaTable.getBindingDBTableName());
        updateSql.append(" set ");
        ArrayList<Object> list = new ArrayList<Object>();
        for (MetaColumn metaColumn : this.balanceFields) {
            updateSql.append(metaColumn.getBindingDBColumnName());
            updateSql.append("_end");
            updateSql.append(" = ");
            updateSql.append(metaColumn.getBindingDBColumnName());
            updateSql.append("_end");
            updateSql.append(" + ");
            updateSql.append(metaColumn.getBindingDBColumnName());
            updateSql.append("_begin");
            updateSql.append(" ,");
        }
        updateSql.deleteCharAt(updateSql.length() - 1);
        boolean firstWhereClause = true;
        for (MetaColumn column : this.periodGroupFields) {
            if (!group.containsKey(column.getBindingDBColumnName())) continue;
            updateSql.append(firstWhereClause ? " where " : " and ").append(column.getBindingDBColumnName()).append(" = ");
            firstWhereClause = false;
            updateSql.append(" ? ");
            list.add(group.get(column.getBindingDBColumnName()));
        }
        updateSql.append(" and ");
        updateSql.append(this.periodField.getBindingDBColumnName()).append(" = ");
        updateSql.append(" ? ");
        list.add(this.periodList.get(i + 1));
        newDbm.execPrepareUpdate(updateSql.toString(), list);
    }

    private void updateBeginPeriodValue(IDBManager newDbm, Map<String, Object> group, int i, MigrationStruct struct, boolean hasPreviousPeroidDataTmpTable) throws Throwable {
        String balanceNewTableName = this.newMetaTable.getBindingDBTableName();
        ArrayList<Object> list = new ArrayList<Object>();
        StringBuilder updateSql = new StringBuilder();
        int dbType = newDbm.getDBType();
        if (DBManagerUtil.isMySQLLikeDatabase((int)dbType)) {
            updateSql.append("update ").append(balanceNewTableName).append(" t, ");
            updateSql.append(hasPreviousPeroidDataTmpTable ? struct.getPreviousNewTableName() : balanceNewTableName).append(" s ");
            updateSql.append(" set ");
            for (MetaColumn metaColumn : this.balanceFields) {
                updateSql.append("t.");
                updateSql.append(metaColumn.getBindingDBColumnName());
                updateSql.append("_begin");
                updateSql.append(" = ");
                updateSql.append("t.");
                updateSql.append(metaColumn.getBindingDBColumnName());
                updateSql.append("_begin");
                updateSql.append(" + ");
                updateSql.append("s.");
                updateSql.append(metaColumn.getBindingDBColumnName());
                updateSql.append("_end");
                updateSql.append(",");
            }
            updateSql.deleteCharAt(updateSql.length() - 1);
            boolean firstWhereClause = true;
            for (MetaColumn column : this.periodGroupFields) {
                if (!group.containsKey(column.getBindingDBColumnName())) continue;
                updateSql.append(firstWhereClause ? " where " : " and ");
                firstWhereClause = false;
                updateSql.append("t.").append(column.getBindingDBColumnName()).append(" = ");
                updateSql.append(" ? ");
                list.add(group.get(column.getBindingDBColumnName()));
                if (hasPreviousPeroidDataTmpTable) continue;
                updateSql.append(" and s.").append(column.getBindingDBColumnName()).append(" = ");
                updateSql.append(" ? ");
                list.add(group.get(column.getBindingDBColumnName()));
            }
            updateSql.append(" and t.");
            updateSql.append(this.periodField.getBindingDBColumnName()).append(" = ");
            updateSql.append(" ? ");
            list.add(this.periodList.get(i + 1));
            if (!hasPreviousPeroidDataTmpTable) {
                updateSql.append(" and s.");
                updateSql.append(this.periodField.getBindingDBColumnName()).append(" = ");
                updateSql.append(" ? ");
                list.add(this.periodList.get(i));
            }
            updateSql.append(" and t.").append("GroupId");
            updateSql.append(" = ");
            updateSql.append(" s.").append("GroupId");
        } else if (DBManagerUtil.isOracleLikeDatabase((int)dbType) || DBManagerUtil.isSQLServerLikeDatabase((int)dbType)) {
            updateSql.append("update ").append(balanceNewTableName);
            updateSql.append(" set ");
            for (MetaColumn metaColumn : this.balanceFields) {
                updateSql.append(balanceNewTableName).append(".");
                updateSql.append(metaColumn.getBindingDBColumnName());
                updateSql.append("_begin");
                updateSql.append(" = ");
                updateSql.append(balanceNewTableName).append(".");
                updateSql.append(metaColumn.getBindingDBColumnName());
                updateSql.append("_begin");
                updateSql.append(" + ");
                updateSql.append("NVL((select ");
                updateSql.append("s.");
                updateSql.append(metaColumn.getBindingDBColumnName());
                updateSql.append("_end");
                updateSql.append(" from ").append(balanceNewTableName).append(" s ");
                updateSql.append(" where ").append(balanceNewTableName).append(".");
                updateSql.append("GroupId").append(" = ");
                updateSql.append(" s.").append("GroupId");
                updateSql.append(" and s.").append(this.periodField.getBindingDBColumnName()).append(" = ?");
                list.add(this.periodList.get(i));
                updateSql.append("), 0),");
            }
            updateSql.deleteCharAt(updateSql.length() - 1);
            updateSql.append(" where 1 = 1 ");
            for (MetaColumn column : this.periodGroupFields) {
                if (!group.containsKey(column.getBindingDBColumnName())) continue;
                updateSql.append(" and ").append(balanceNewTableName).append(".");
                updateSql.append(column.getBindingDBColumnName()).append(" = ?");
                list.add(group.get(column.getBindingDBColumnName()));
            }
            updateSql.append(" and ").append(balanceNewTableName).append(".");
            updateSql.append(this.periodField.getBindingDBColumnName()).append(" = ?");
            list.add(this.periodList.get(i + 1));
        } else if (DBManagerUtil.isEsgynDBLikeDatabase((int)dbType)) {
            updateSql.append("update ").append(balanceNewTableName);
            updateSql.append(" set ");
            for (MetaColumn metaColumn : this.balanceFields) {
                updateSql.append(metaColumn.getBindingDBColumnName());
                updateSql.append("_begin");
                updateSql.append(" = IFNULL((");
                updateSql.append(metaColumn.getBindingDBColumnName());
                updateSql.append("_begin");
                updateSql.append(",0) + ");
                updateSql.append(" IFNULL((select ");
                updateSql.append("s.");
                updateSql.append(metaColumn.getBindingDBColumnName());
                updateSql.append("_end");
                updateSql.append(" from ").append(balanceNewTableName).append(" s ");
                updateSql.append(" where ").append(balanceNewTableName).append(".");
                updateSql.append("GroupId").append(" = ");
                updateSql.append(" s.").append("GroupId");
                updateSql.append(" and s.").append(this.periodField.getBindingDBColumnName()).append(" = ?");
                list.add(this.periodList.get(i));
                updateSql.append("),0),");
            }
            updateSql.deleteCharAt(updateSql.length() - 1);
            updateSql.append(" where 1 = 1 ");
            for (MetaColumn column : this.periodGroupFields) {
                if (!group.containsKey(column.getBindingDBColumnName())) continue;
                updateSql.append(" and ").append(balanceNewTableName).append(".");
                updateSql.append(column.getBindingDBColumnName()).append(" = ?");
                list.add(group.get(column.getBindingDBColumnName()));
            }
            updateSql.append(" and ").append(balanceNewTableName).append(".");
            updateSql.append(this.periodField.getBindingDBColumnName()).append(" = ?");
            list.add(this.periodList.get(i + 1));
        }
        newDbm.execPrepareUpdate(updateSql.toString(), list);
        if (!DBManagerUtil.isMySQLLikeDatabase((int)dbType) && (DBManagerUtil.isOracleLikeDatabase((int)dbType) || DBManagerUtil.isSQLServerLikeDatabase((int)dbType))) {
            for (MetaColumn metaColumn : this.balanceFields) {
                StringBuilder updateBeginNullToZero = new StringBuilder(512);
                ArrayList<Object> listM = new ArrayList<Object>();
                updateBeginNullToZero.append("update ").append(balanceNewTableName);
                updateBeginNullToZero.append(" set ");
                String beginColumnName = String.valueOf(metaColumn.getBindingDBColumnName()) + "_begin";
                updateBeginNullToZero.append(beginColumnName).append("=? where ").append(beginColumnName).append(" is null");
                listM.add(0);
                for (MetaColumn column : this.periodGroupFields) {
                    String columnName = column.getBindingDBColumnName();
                    if (!group.containsKey(columnName)) continue;
                    updateBeginNullToZero.append(" and ").append(columnName).append("= ?");
                    listM.add(group.get(columnName));
                }
                updateBeginNullToZero.append(" and ").append(this.periodField.getBindingDBColumnName()).append("= ?");
                listM.add(this.periodList.get(i + 1));
                newDbm.execPrepareUpdate(updateBeginNullToZero.toString(), listM);
            }
        }
    }

    private void updateEndPeriodValue(IDBManager newDbm, Map<String, Object> group, int i) throws Throwable {
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(this.newMetaTable.getBindingDBTableName());
        updateSql.append(" set ");
        ArrayList<Object> list = new ArrayList<Object>();
        for (MetaColumn metaColumn : this.balanceFields) {
            updateSql.append(metaColumn.getBindingDBColumnName());
            updateSql.append("_end");
            updateSql.append(" = ");
            updateSql.append(metaColumn.getBindingDBColumnName());
            updateSql.append(", ");
            updateSql.append(metaColumn.getBindingDBColumnName());
            updateSql.append("_begin");
            updateSql.append(" = ?,");
            list.add(0);
        }
        updateSql.deleteCharAt(updateSql.length() - 1);
        boolean firstWhereClause = true;
        for (MetaColumn column : this.periodGroupFields) {
            if (!group.containsKey(column.getBindingDBColumnName())) continue;
            updateSql.append(firstWhereClause ? " where " : " and ").append(column.getBindingDBColumnName()).append(" = ");
            firstWhereClause = false;
            updateSql.append("?");
            list.add(group.get(column.getBindingDBColumnName()));
        }
        updateSql.append(" and ");
        updateSql.append(this.periodField.getBindingDBColumnName()).append(" = ");
        updateSql.append("?");
        list.add(this.periodList.get(i + 1));
        newDbm.execPrepareUpdate(updateSql.toString(), list);
    }

    private void insertCurrentPeriodGroupValueRecords(DefaultContext context, IDBManager newDbm, Map<String, Object> group, int i, MigrationStruct struct, boolean hasPreviousPeroidDataTmpTable) throws Throwable {
        block26: {
            String balanceNewTableName = this.newMetaTable.getBindingDBTableName();
            SqlString periodGroupCondition = new SqlString();
            for (MetaColumn column : this.periodGroupFields) {
                if (!group.containsKey(column.getBindingDBColumnName())) continue;
                periodGroupCondition.append(periodGroupCondition.length() > 0 ? " and " : "");
                periodGroupCondition.append(column.getBindingDBColumnName()).append(" = ");
                periodGroupCondition.appendPara(group.get(column.getBindingDBColumnName()));
            }
            StringBuilder periodCondition = new StringBuilder();
            periodCondition.append(" and ");
            periodCondition.append(this.periodField.getBindingDBColumnName()).append(" = ");
            SqlString endValueNotZeroCondition = new SqlString();
            int count = 0;
            for (MetaColumn metaColumn : this.balanceFields) {
                if (count != 0) {
                    endValueNotZeroCondition.append(" or ");
                }
                endValueNotZeroCondition.append(metaColumn.getBindingDBColumnName());
                endValueNotZeroCondition.append("_end");
                endValueNotZeroCondition.append(" <>  ").appendPara(0);
                ++count;
            }
            SqlString querySql = new SqlString();
            querySql.append(" select distinct ").append("GroupId");
            int j = 0;
            int len = this.periodGroupFields.size();
            while (j < len) {
                if (j == 0) {
                    querySql.append(",");
                }
                querySql.append(this.periodGroupFields.get(j).getBindingDBColumnName());
                if (j != len - 1) {
                    querySql.append(",");
                }
                ++j;
            }
            querySql.append(" from ");
            if (hasPreviousPeroidDataTmpTable) {
                querySql.append(struct.getPreviousNewTableName());
                querySql.append(" where ");
            } else {
                querySql.append(balanceNewTableName);
                querySql.append(" where ");
                querySql.append(periodGroupCondition);
                querySql.append(periodCondition);
                querySql.appendPara(this.periodList.get(i));
                querySql.append(" and ");
            }
            querySql.append("(");
            querySql.append(endValueNotZeroCondition);
            querySql.append(") ");
            querySql.append(" and ").append("GroupId").append(" not in (");
            querySql.append(" select ").append("GroupId");
            querySql.append(" from ").append(balanceNewTableName);
            querySql.append(" where ");
            querySql.append(periodGroupCondition);
            querySql.append(periodCondition);
            querySql.appendPara(this.periodList.get(i + 1));
            querySql.append(") ");
            DataTable groupIdAndPeriodGroupFieldsDataTable = newDbm.execPrepareQuery(querySql.getSql(), querySql.getParameterList());
            if (groupIdAndPeriodGroupFieldsDataTable == null || groupIdAndPeriodGroupFieldsDataTable.isEmpty()) break block26;
            ArrayList<String> insertColumnKeyList = new ArrayList<String>(this.newMetaTable.size());
            ArrayList<MetaColumn> insertColumnList = new ArrayList<MetaColumn>(this.newMetaTable.size());
            for (MetaColumn column : this.newMetaTable) {
                if (!column.isPersist().booleanValue()) continue;
                insertColumnList.add(column);
                insertColumnKeyList.add(column.getKey());
            }
            String insertSQL = DBUtil.getInsertSQL((IDBManager)newDbm, (String)this.newMetaTable.getBindingDBTableName(), insertColumnKeyList);
            BatchPsPara insertBPP = new BatchPsPara(insertSQL);
            int rowIndex = 0;
            int len2 = groupIdAndPeriodGroupFieldsDataTable.size();
            while (rowIndex < len2) {
                long groupId = groupIdAndPeriodGroupFieldsDataTable.getLong(rowIndex, "GroupId");
                PSArgs args = new PSArgs();
                long OID = context.applyNewOID();
                for (MetaColumn column : insertColumnList) {
                    switch (column.getBindingDBColumnName()) {
                        case "OID": {
                            args.addArg(Integer.valueOf(1010), (Object)OID);
                            break;
                        }
                        case "VERID": {
                            args.addArg(Integer.valueOf(1001), (Object)0);
                            break;
                        }
                        case "GroupId": {
                            args.addArg(Integer.valueOf(1010), (Object)groupId);
                            break;
                        }
                        default: {
                            if (column.getBindingDBColumnName().equals(this.periodField.getBindingDBColumnName())) {
                                args.addArg(Integer.valueOf(1001), this.periodList.get(i + 1));
                                break;
                            }
                            if (column.getGroupType() == 2) {
                                args.addArg(column.getDataType(), groupIdAndPeriodGroupFieldsDataTable.getObject(rowIndex, column.getBindingDBColumnName()));
                                break;
                            }
                            args.addArg(column.getDataType(), TypeConvertor.toDataType((int)column.getDataType(), (Object)0));
                        }
                    }
                }
                insertBPP.putArgs(args);
                ++rowIndex;
            }
            newDbm.executeUpdate(insertBPP);
        }
    }

    private Map<String, Object> getConditionMap(HashMap<String, MetaColumn> groupFieldsMap, Map<String, Object> group) {
        if (group == null) {
            return null;
        }
        HashMap<String, Object> conditionMap = new HashMap<String, Object>();
        Set<String> keys = group.keySet();
        for (String key : keys) {
            if (!groupFieldsMap.containsKey(key)) continue;
            MetaColumn col = groupFieldsMap.get(key);
            int dataType = col.getDataType();
            Object value = TypeConvertor.toDataType((int)dataType, (Object)group.get(key));
            conditionMap.put(key, value);
        }
        return conditionMap;
    }

    protected ArrayList<MetaColumn> getMigrationSYSField(MetaTable migrationMainMetaTable) {
        if (this.migrationSYSFields == null) {
            this.migrationSYSFields = new ArrayList();
            this.migrationSYSFields.add(migrationMainMetaTable.getOIDColumn());
            this.migrationSYSFields.add(migrationMainMetaTable.getVERIDColumn());
        }
        return this.migrationSYSFields;
    }

    private String calcDSNName(DefaultContext context, MigrationStruct struct, Map<String, Object> group, int i) throws Throwable {
        Object curPeriodValue = this.periodList.get(i);
        List<MetaColumn> periodGroupColumns = struct.getMetaPeriodGroupColumns();
        OneGroupValue curOneGroupValue = new OneGroupValue();
        for (MetaColumn metaColumn : periodGroupColumns) {
            String columnName = metaColumn.getBindingDBColumnName();
            Object value = group.get(columnName);
            curOneGroupValue.setGroupValue(columnName, value);
        }
        String periodColumnName = struct.getMetaPeriodColumn().getBindingDBColumnName();
        curOneGroupValue.setGroupValue(periodColumnName, curPeriodValue);
        String newTableName = struct.getNewTableName();
        curOneGroupValue.expandValueByRelation(TableGroupProps.getInstance().getTableGroupProp(newTableName));
        String dsnName = TableGroupProps.getInstance().getGroupForMigration(newTableName).getDSNName(newTableName, curOneGroupValue);
        return dsnName;
    }

    private boolean copyPreviousNewDataInTmp(DefaultContext context, String previousDSNName, String curDSNName, MigrationStruct struct, Map<String, Object> group, int i) throws Throwable {
        Object previousPeriodValue = this.periodList.get(i);
        String loadSql = struct.getLoadNewTableSql();
        List<MetaColumn> periodGroupColumns = struct.getMetaPeriodGroupColumns();
        ArrayList<Object> arguments = new ArrayList<Object>(periodGroupColumns.size() + 1);
        for (MetaColumn metaColumn : periodGroupColumns) {
            String columnName = metaColumn.getBindingDBColumnName();
            Object value = group.get(columnName);
            arguments.add(value);
        }
        arguments.add(previousPeriodValue);
        MultiDBManager dbManager = (MultiDBManager)context.getDBManager();
        DataTable newDataTable = dbManager.execPrepareQuery(previousDSNName, loadSql, arguments);
        String loadPreviousKeysData = struct.getLoadKeysDataByPeriodGroupPeriodSql();
        DataTable keysDataTable = dbManager.execPrepareQuery(previousDSNName, loadPreviousKeysData, arguments);
        String newTableName = struct.getNewTableName();
        RefObject newArgumentSize = new RefObject((Object)0);
        String previousNewTableName = struct.getPreviousNewTableName();
        String insertNewSql = struct.getInsertNewSql((RefObject<Integer>)newArgumentSize).replace(newTableName, previousNewTableName);
        DataTableBatchPsPara newBatchPsPara = new DataTableBatchPsPara(insertNewSql, newDataTable, (Integer)newArgumentSize.getValue());
        String keysTableName = struct.getKeysTableName();
        RefObject keysArgumentSize = new RefObject((Object)0);
        String previousKeysTableName = struct.getPreviousKeysTableName();
        String insertKeysSql = struct.getInsertKeysSql((RefObject<Integer>)keysArgumentSize).replace(keysTableName, previousKeysTableName);
        DataTableBatchPsPara keysBatchPsPara = new DataTableBatchPsPara(insertKeysSql, keysDataTable, (Integer)keysArgumentSize.getValue());
        IDBManager dsnDBManager = dbManager.getDBManagerByDsnName(curDSNName);
        dsnDBManager.getCacheDBRequest().stopLocalIsUseCacheDB();
        this.clearTempData(struct, dsnDBManager);
        dsnDBManager.executeUpdate((BatchPsPara)newBatchPsPara);
        dsnDBManager.executeUpdate((BatchPsPara)keysBatchPsPara);
        String insertKeysFromPrevois = struct.getInsertKeysFromPreviousSql();
        dsnDBManager.execPrepareUpdate(insertKeysFromPrevois, new Object[0]);
        return true;
    }

    private void clearTempData(MigrationStruct struct, IDBManager dsnDBManager) throws Throwable {
        String previousNewTableName = struct.getPreviousNewTableName();
        dsnDBManager.execUpdate("delete from " + dsnDBManager.keyWordEscape(previousNewTableName));
        String previousKeysTableName = struct.getPreviousKeysTableName();
        dsnDBManager.execUpdate("delete from " + dsnDBManager.keyWordEscape(previousKeysTableName));
    }
}

