/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.migration.period;

import com.bokesoft.erp.mid.schema.ERPSchemaViewDependSchemaTable;
import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.meta.dataobject.SchemaCreator;
import com.bokesoft.yes.mid.migration.IReMigrateStrategy;
import com.bokesoft.yes.mid.migration.period.DataMigrationStruct;
import com.bokesoft.yes.mid.migration.period.ReMigrateScope;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupField;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceField;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationSourceTree;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.schemamgr.ISchemaCreate;
import com.bokesoft.yigo.mid.schemamgr.SchemaCreateFactory;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.exception.StructException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;

public class MigrationStruct {
    public static final Map<String, MigrationStruct> cache = new ConcurrentHashMap<String, MigrationStruct>();
    public final MetaDataObject metaDataObject;
    private List<MetaSchemaTable> metaSchemaTables;
    private List<String> viewNames;
    private String createNewTableSql;
    private String createKeysTableSql;
    private String createNewPreTableSql;
    private String createKeysPreTableSql;
    private MetaColumn metaPeriodColumn;
    private List<MetaColumn> metaPeriodGroupColumns;
    private List<MetaColumn> metaGroupColumns;
    private List<MetaColumn> metaDataColumns;
    private boolean[] dataColumnIsAssign;
    private List<MetaColumn> metaSplitDataColumns;
    private List<MetaColumn> metaGroupColumnsForGroupID;
    private int[] groupColumnDataTypes;
    private String loadLastPointSql;
    List<MetaDataMigration> metaDataMigrations;
    Map<MetaDataMigration, DataMigrationStruct> dataMigrationStructs;
    private String loadNewDataSql;
    String insertNewSql;
    String insertIncrSql;
    Integer insertNewArgumentSize;
    String updateNewSql;
    String insertFastSql;
    int[] argumentColumnIndexesInIncr;
    IReMigrateStrategy insertFastStrategy;
    private String loadIncrSql;
    private List<String> columnNamesInLoadIncrSql;
    private int[] sumColumnIndexes;
    private String loadGroupIDFromKeysByHashCodeSql;
    private String insertKeysSql;
    private DataTableMetaData keysDataTableMetaData;
    private GroupField[] groupFields;
    private DataTableMetaData incrDataTableMetaData;
    private DataTableMetaData changeDataTableMetaData;
    private int incrOIDColumnIndex = -1;
    private int[] incrPeriodColumnIndex;
    private int[][] incrSplitDataColumnIndexes;
    private int[] incrBeginColumnIndexes;
    private int[] incrEndColumnIndexes;
    private int[][] incrDataNoSplitColumnIndexes;
    private int incrGroupIDColumnIndex = -1;
    private int[][] incrPeriodGroupColumnIndexes;

    public static MigrationStruct get(String migrationDataObjectKey) throws Throwable {
        MigrationStruct result = cache.get(migrationDataObjectKey);
        if (result == null) {
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaDataObject metaDataObject = metaFactory.getDataObject(migrationDataObjectKey);
            result = new MigrationStruct(metaDataObject);
            cache.put(migrationDataObjectKey, result);
        }
        return result;
    }

    public static void remove(String migrationDataObjectKey) throws Throwable {
        cache.remove(migrationDataObjectKey);
    }

    private MigrationStruct(MetaDataObject metaDataObject) {
        this.metaDataObject = metaDataObject;
        if (metaDataObject.getMigrationUpdateStrategy() != 5) {
            throw new RuntimeException("\u76ee\u524d\u53ea\u652f\u6301\u7ec4\u4e3b\u952e\u589e\u91cf\u8fc1\u79fb\u8868\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
        }
    }

    public List<MetaSchemaTable> getMetaSchemaTables() {
        if (this.metaSchemaTables == null) {
            SchemaCreator sc = new SchemaCreator(this.metaDataObject);
            this.metaSchemaTables = sc.getSchemeTableList();
        }
        return this.metaSchemaTables;
    }

    public List<String> getViewNames() {
        if (this.viewNames == null) {
            ERPSchemaViewDependSchemaTable views = new ERPSchemaViewDependSchemaTable(this.metaDataObject);
            this.viewNames = views.getViewNames();
        }
        return this.viewNames;
    }

    public Map<String, String> getCreateViewSqls(IDBManager dbManager) throws Throwable {
        ERPSchemaViewDependSchemaTable views = new ERPSchemaViewDependSchemaTable(this.metaDataObject);
        return views.generateViewSqls(dbManager);
    }

    public String getCreateNewTableSql(IDBManager dbManager) throws Throwable {
        if (this.createNewTableSql == null) {
            for (MetaSchemaTable schemaTable : this.getMetaSchemaTables()) {
                if (!schemaTable.getKey().equalsIgnoreCase(this.getNewTableName())) continue;
                ISchemaCreate schemaCreate = SchemaCreateFactory.getInstance().create();
                this.createNewTableSql = schemaCreate.createTableSql(dbManager, schemaTable);
                break;
            }
        }
        return this.createNewTableSql;
    }

    public String getCreateKeysTableSql(IDBManager dbManager) throws Throwable {
        if (this.createKeysTableSql == null) {
            for (MetaSchemaTable schemaTable : this.getMetaSchemaTables()) {
                if (!schemaTable.getKey().equalsIgnoreCase(this.getKeysTableName())) continue;
                ISchemaCreate schemaCreate = SchemaCreateFactory.getInstance().create();
                this.createKeysTableSql = schemaCreate.createTableSql(dbManager, schemaTable);
                break;
            }
        }
        return this.createKeysTableSql;
    }

    public String getCreateNewPreTableSql(IDBManager dbManager) throws Throwable {
        if (this.createNewPreTableSql == null) {
            for (MetaSchemaTable schemaTable : this.getMetaSchemaTables()) {
                if (!schemaTable.getKey().equalsIgnoreCase(this.getNewTableName())) continue;
                MetaSchemaTable pre = new MetaSchemaTable();
                pre.setKey(this.getPreviousNewTableName());
                for (MetaSchemaColumn schemaColumn : schemaTable.getColumnCollection()) {
                    pre.getColumnCollection().add((KeyPairMetaObject)schemaColumn);
                }
                ISchemaCreate schemaCreate = SchemaCreateFactory.getInstance().create();
                this.createNewPreTableSql = schemaCreate.createTableSql(dbManager, pre);
                break;
            }
        }
        return this.createNewPreTableSql;
    }

    public String getCreateKeysPreTableSql(IDBManager dbManager) throws Throwable {
        if (this.createKeysPreTableSql == null) {
            for (MetaSchemaTable schemaTable : this.getMetaSchemaTables()) {
                if (!schemaTable.getKey().equalsIgnoreCase(this.getKeysTableName())) continue;
                MetaSchemaTable pre = new MetaSchemaTable();
                pre.setKey(this.getPreviousKeysTableName());
                for (MetaSchemaColumn schemaColumn : schemaTable.getColumnCollection()) {
                    pre.getColumnCollection().add((KeyPairMetaObject)schemaColumn);
                }
                ISchemaCreate schemaCreate = SchemaCreateFactory.getInstance().create();
                this.createKeysPreTableSql = schemaCreate.createTableSql(dbManager, pre);
                break;
            }
        }
        return this.createKeysPreTableSql;
    }

    private void initColumns() throws Throwable {
        if (this.metaPeriodGroupColumns == null) {
            ArrayList<MetaColumn> tmp = new ArrayList<MetaColumn>();
            ArrayList<MetaColumn> tmpMetaGroupColumns = new ArrayList<MetaColumn>();
            ArrayList<MetaColumn> tmpMetaDataColumns = new ArrayList<MetaColumn>();
            ArrayList<MetaColumn> tmpMetaSplitDataColumns = new ArrayList<MetaColumn>();
            ArrayList<MetaColumn> tmpMetaGroupColumnsForGroupID = new ArrayList<MetaColumn>();
            block6: for (MetaColumn metaColumn : this.metaDataObject.getMainTable()) {
                if (metaColumn.isAutoGen()) continue;
                switch (metaColumn.getGroupType()) {
                    case 1: {
                        this.metaPeriodColumn = metaColumn;
                        break;
                    }
                    case 2: {
                        tmp.add(metaColumn);
                        tmpMetaGroupColumnsForGroupID.add(metaColumn);
                        break;
                    }
                    case 0: {
                        tmpMetaGroupColumns.add(metaColumn);
                        tmpMetaGroupColumnsForGroupID.add(metaColumn);
                        break;
                    }
                    case -1: {
                        if (metaColumn.getSplitType() == -1) {
                            String key = metaColumn.getKey();
                            if (key.equalsIgnoreCase("OID") || key.equalsIgnoreCase("Slock") || key.equalsIgnoreCase("VERID") || key.equalsIgnoreCase("MapCount")) continue block6;
                            tmpMetaDataColumns.add(metaColumn);
                            break;
                        }
                        tmpMetaSplitDataColumns.add(metaColumn);
                    }
                }
            }
            this.metaGroupColumns = tmpMetaGroupColumns;
            this.metaDataColumns = tmpMetaDataColumns;
            this.metaSplitDataColumns = tmpMetaSplitDataColumns;
            this.metaGroupColumnsForGroupID = tmpMetaGroupColumnsForGroupID;
            int dataSize = tmpMetaDataColumns.size();
            this.dataColumnIsAssign = new boolean[dataSize];
            int i = 0;
            while (i < dataSize) {
                MetaColumn dataColumn = (MetaColumn)tmpMetaDataColumns.get(i);
                Boolean isAssignResult = null;
                for (MetaDataMigration metaDataMigration : this.getMetaDataMigrations()) {
                    boolean isAssign;
                    DataMigrationStruct dataMigrationStruct = this.getDataMigrationStruct(metaDataMigration);
                    MetaDMSourceField metaDMSourceField = dataMigrationStruct.getTgtColumnToDMSourceField().get(dataColumn);
                    if (metaDMSourceField == null) continue;
                    boolean bl = isAssign = metaDMSourceField.getOpSign() == 2;
                    if (isAssignResult == null) {
                        isAssignResult = isAssign;
                        continue;
                    }
                    if (isAssignResult == isAssign) continue;
                    throw new RuntimeException("\u8fc1\u79fb\u8868" + this.metaDataObject.getKey() + "\u7684\u5b57\u6bb5" + dataColumn.getKey() + "\u7684\u8fc1\u79fb\u5c5e\u6027\u5728\u591a\u4e2a\u8fc1\u79fb\u5173\u7cfb\u4e2d\u4e0d\u4e00\u81f4\uff0c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
                }
                this.dataColumnIsAssign[i] = isAssignResult == null ? true : isAssignResult;
                ++i;
            }
            this.metaPeriodGroupColumns = tmp;
        }
    }

    public MetaColumn getMetaPeriodColumn() throws Throwable {
        this.initColumns();
        return this.metaPeriodColumn;
    }

    public List<MetaColumn> getMetaPeriodGroupColumns() throws Throwable {
        this.initColumns();
        return this.metaPeriodGroupColumns;
    }

    public List<MetaColumn> getMetaGroupColumns() throws Throwable {
        this.initColumns();
        return this.metaGroupColumns;
    }

    public List<MetaColumn> getMetaDataColumns() throws Throwable {
        this.initColumns();
        return this.metaDataColumns;
    }

    public boolean[] getDataColumnIsAssign() throws Throwable {
        this.initColumns();
        return this.dataColumnIsAssign;
    }

    public List<MetaColumn> getMetaSplitDataColumns() throws Throwable {
        this.initColumns();
        return this.metaSplitDataColumns;
    }

    public List<MetaColumn> getMetaGroupColumnsForGroupID() throws Throwable {
        this.initColumns();
        return this.metaGroupColumnsForGroupID;
    }

    public int[] getGroupColumnDataTypesForGroupID() throws Throwable {
        if (this.groupColumnDataTypes == null) {
            List<MetaColumn> metaGroupColumnsForGroupID = this.getMetaGroupColumnsForGroupID();
            int columnSize = metaGroupColumnsForGroupID.size();
            int[] dataTypes = new int[columnSize];
            int i = 0;
            while (i < columnSize) {
                MetaColumn metaColumn = metaGroupColumnsForGroupID.get(i);
                dataTypes[i] = metaColumn.getDataType();
                ++i;
            }
            this.groupColumnDataTypes = dataTypes;
        }
        return this.groupColumnDataTypes;
    }

    public String[] getPeriodAndGroupIDColumnNames() throws Throwable {
        if (this.getMetaPeriodColumn() != null) {
            return new String[]{this.getMetaPeriodColumn().getBindingDBColumnName(), "GroupId"};
        }
        return new String[]{"GroupId"};
    }

    public String getNewTableName() {
        return this.metaDataObject.getErpMigrationNewTable().getKey();
    }

    public String getPreviousNewTableName() {
        return String.valueOf(this.getNewTableName()) + "PRE";
    }

    public String getKeysTableName() {
        return this.metaDataObject.getErpMigrationKeysTable().getKey();
    }

    public String getIncrTableName() {
        return this.metaDataObject.getErpMigrationIncrTable().getKey();
    }

    public String getPreviousKeysTableName() {
        return String.valueOf(this.getKeysTableName()) + "PRE";
    }

    public String getLastPointTableName() throws Throwable {
        if (this.getMetaPeriodColumn() == null) {
            return null;
        }
        MetaTable lastPointTable = this.metaDataObject.getMigrationLastPointTable();
        return lastPointTable.getKey();
    }

    public String getLoadLastPointSql() throws Throwable {
        if (this.loadLastPointSql == null) {
            StringBuilder sb = new StringBuilder(512).append("SELECT ");
            sb.append(this.getMetaPeriodColumn().getBindingDBColumnName());
            sb.append(" FROM ").append(this.getLastPointTableName());
            List<MetaColumn> periodGroupColumns = this.getMetaPeriodGroupColumns();
            if (periodGroupColumns != null && periodGroupColumns.size() > 0) {
                sb.append(" WHERE ").append(periodGroupColumns.get(0).getBindingDBColumnName()).append(" = ?");
                int i = 1;
                int size = periodGroupColumns.size();
                while (i < size) {
                    sb.append(" AND ").append(periodGroupColumns.get(i).getBindingDBColumnName()).append(" = ?");
                    ++i;
                }
            }
            this.loadLastPointSql = sb.toString();
        }
        return this.loadLastPointSql;
    }

    public List<MetaDataMigration> getMetaDataMigrations() throws Throwable {
        if (this.metaDataMigrations == null) {
            ArrayList<MetaDataMigration> tmp = new ArrayList<MetaDataMigration>();
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaDataMigrationSourceTree tree = metaFactory.getDataMigrationList().getTgtTree(this.metaDataObject.getKey());
            if (tree != null) {
                for (MetaDataMigrationProfile mp : tree) {
                    tmp.add(mp.getDataMigration());
                }
            }
            this.metaDataMigrations = tmp;
        }
        return this.metaDataMigrations;
    }

    private DataMigrationStruct getDataMigrationStruct(MetaDataMigration metaDataMigration) {
        DataMigrationStruct result;
        if (this.dataMigrationStructs == null) {
            this.dataMigrationStructs = new HashMap<MetaDataMigration, DataMigrationStruct>();
        }
        if ((result = this.dataMigrationStructs.get(metaDataMigration)) == null) {
            result = new DataMigrationStruct(this, metaDataMigration);
            this.dataMigrationStructs.put(metaDataMigration, result);
        }
        return result;
    }

    public SqlString getDistinctPeriodGroupAndPeriodValueSql(MetaDataMigration metaDataMigration, ReMigrateScope reMigrateScope) throws Throwable {
        DataMigrationStruct dataMigrationStruct = this.getDataMigrationStruct(metaDataMigration);
        return dataMigrationStruct.getDistinctPeriodGroupAndPeriodValueSql(reMigrateScope);
    }

    public String getSumFactDataAsNewSql(MetaDataMigration metaDataMigration) throws Throwable {
        DataMigrationStruct dataMigrationStruct = this.getDataMigrationStruct(metaDataMigration);
        return dataMigrationStruct.getSumFactDataAsNewSql();
    }

    public String getLoadNewTableSql() throws Throwable {
        if (this.loadNewDataSql == null) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("select OID, VerID, GroupID");
            MetaColumn metaPeriodColumn = this.getMetaPeriodColumn();
            if (metaPeriodColumn != null) {
                for (MetaColumn metaColumn : this.getMetaPeriodGroupColumns()) {
                    sb.append(",").append(metaColumn.getBindingDBColumnName());
                }
                sb.append(",").append(metaPeriodColumn.getBindingDBColumnName());
            }
            for (MetaColumn metaColumn : this.getMetaDataColumns()) {
                sb.append(",").append(metaColumn.getBindingDBColumnName());
            }
            for (MetaColumn metaColumn : this.getMetaSplitDataColumns()) {
                sb.append(",").append(metaColumn.getBindingDBColumnName());
                sb.append(",").append(MigrationStruct.getBeginColumnName(metaColumn));
                sb.append(",").append(MigrationStruct.getEndColumnName(metaColumn));
            }
            sb.append(" from ").append(this.getNewTableName());
            if (metaPeriodColumn != null) {
                sb.append(" where ");
                for (MetaColumn metaColumn : this.getMetaPeriodGroupColumns()) {
                    sb.append(metaColumn.getBindingDBColumnName()).append("=? and ");
                }
                sb.append(metaPeriodColumn.getBindingDBColumnName()).append("=?");
            }
            this.loadNewDataSql = sb.toString();
        }
        return this.loadNewDataSql;
    }

    public String getInsertNewSql(RefObject<Integer> refArgumentSize) throws Throwable {
        if (this.insertNewSql == null) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("insert into ").append(this.getNewTableName()).append("(OID,VerID,GroupID");
            int argumentSize = 3;
            MetaColumn metaPeriodColumn = this.getMetaPeriodColumn();
            if (metaPeriodColumn != null) {
                for (MetaColumn metaColumn : this.getMetaPeriodGroupColumns()) {
                    sb.append(",").append(metaColumn.getBindingDBColumnName());
                    ++argumentSize;
                }
                sb.append(",").append(metaPeriodColumn.getBindingDBColumnName());
                ++argumentSize;
            }
            for (MetaColumn metaColumn : this.getMetaDataColumns()) {
                sb.append(",").append(metaColumn.getBindingDBColumnName());
                ++argumentSize;
            }
            for (MetaColumn metaColumn : this.getMetaSplitDataColumns()) {
                sb.append(",").append(metaColumn.getBindingDBColumnName());
                sb.append(",").append(MigrationStruct.getBeginColumnName(metaColumn));
                sb.append(",").append(MigrationStruct.getEndColumnName(metaColumn));
                argumentSize += 3;
            }
            for (MetaColumn metaColumn : this.getMetaGroupColumns()) {
                int columnIndexByKey = this.getIncrDataTableMetaData().findColumnIndexByKey(metaColumn.getKey());
                if (columnIndexByKey < 0) continue;
                sb.append(",").append(metaColumn.getBindingDBColumnName());
                ++argumentSize;
            }
            sb.append(")").append(" VALUES ").append("(?");
            int i = 1;
            while (i < argumentSize) {
                sb.append(",?");
                ++i;
            }
            sb.append(")");
            this.insertNewSql = sb.toString();
            this.insertNewArgumentSize = argumentSize;
        }
        refArgumentSize.setValue((Object)this.insertNewArgumentSize);
        return this.insertNewSql;
    }

    public String getInsertIncrSql(RefObject<Integer> refArgumentSize) throws Throwable {
        if (this.insertIncrSql == null) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("insert into ").append(this.getIncrTableName()).append("(OID,VerID,GroupID");
            int argumentSize = 3;
            MetaColumn metaPeriodColumn = this.getMetaPeriodColumn();
            if (metaPeriodColumn != null) {
                for (MetaColumn metaColumn : this.getMetaPeriodGroupColumns()) {
                    sb.append(",").append(metaColumn.getBindingDBColumnName());
                    ++argumentSize;
                }
                sb.append(",").append(metaPeriodColumn.getBindingDBColumnName());
                ++argumentSize;
            }
            for (MetaColumn metaColumn : this.getMetaDataColumns()) {
                sb.append(",").append(metaColumn.getBindingDBColumnName());
                ++argumentSize;
            }
            for (MetaColumn metaColumn : this.getMetaSplitDataColumns()) {
                sb.append(",").append(metaColumn.getBindingDBColumnName());
                sb.append(",").append(MigrationStruct.getBeginColumnName(metaColumn));
                sb.append(",").append(MigrationStruct.getEndColumnName(metaColumn));
                argumentSize += 3;
            }
            for (MetaColumn metaColumn : this.getMetaGroupColumns()) {
                int columnIndexByKey = this.getIncrDataTableMetaData().findColumnIndexByKey(metaColumn.getKey());
                if (columnIndexByKey < 0) continue;
                sb.append(",").append(metaColumn.getBindingDBColumnName());
                ++argumentSize;
            }
            sb.append(")").append(" VALUES ").append("(?");
            int i = 1;
            while (i < argumentSize) {
                sb.append(",?");
                ++i;
            }
            sb.append(")");
            this.insertIncrSql = sb.toString();
            this.insertNewArgumentSize = argumentSize;
        }
        refArgumentSize.setValue((Object)this.insertNewArgumentSize);
        return this.insertIncrSql;
    }

    public IReMigrateStrategy getInsertFastStrategy() {
        return this.insertFastStrategy;
    }

    public void setInsertFastStrategy(IReMigrateStrategy insertFastStrategy) {
        this.insertFastStrategy = insertFastStrategy;
    }

    public String getUpateNewSqlFromIncr(RefObject<int[]> refArgumentColumnIndexInIncr) throws Throwable {
        if (this.updateNewSql == null) {
            String columnName;
            this.getLoadIncrSql();
            StringBuilder sb = new StringBuilder(1024);
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            sb.append("update ").append(this.getNewTableName()).append(" set ");
            List<MetaColumn> dataColumns = this.getMetaDataColumns();
            int i = 0;
            int size = dataColumns.size();
            while (i < size) {
                MetaColumn metaColumn = dataColumns.get(i);
                columnName = metaColumn.getBindingDBColumnName();
                sb.append(columnName).append("=");
                if (this.getDataColumnIsAssign()[i]) {
                    sb.append("?,");
                } else {
                    sb.append(columnName).append("+?,");
                }
                tmp.add(this.columnNamesInLoadIncrSql.indexOf(columnName));
                ++i;
            }
            for (MetaColumn metaColumn : this.getMetaSplitDataColumns()) {
                String columnName2 = metaColumn.getBindingDBColumnName();
                sb.append(columnName2).append("=").append(columnName2).append("+?,");
                tmp.add(this.columnNamesInLoadIncrSql.indexOf(columnName2));
                columnName2 = MigrationStruct.getBeginColumnName(metaColumn);
                sb.append(columnName2).append("=").append(columnName2).append("+?,");
                tmp.add(this.columnNamesInLoadIncrSql.indexOf(columnName2));
                columnName2 = MigrationStruct.getEndColumnName(metaColumn);
                sb.append(columnName2).append("=").append(columnName2).append("+?,");
                tmp.add(this.columnNamesInLoadIncrSql.indexOf(columnName2));
            }
            for (MetaColumn metaColumn : this.getMetaGroupColumns()) {
                int columnIndexByKey = this.getIncrDataTableMetaData().findColumnIndexByKey(metaColumn.getKey());
                if (columnIndexByKey < 0) continue;
                columnName = metaColumn.getBindingDBColumnName();
                sb.append(columnName).append("=");
                sb.append("?,");
                tmp.add(this.columnNamesInLoadIncrSql.indexOf(columnName));
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append(" where ");
            MetaColumn metaPeriodColumn = this.getMetaPeriodColumn();
            if (metaPeriodColumn != null) {
                String columnName3 = metaPeriodColumn.getBindingDBColumnName();
                sb.append(columnName3).append("=? and ");
                tmp.add(this.columnNamesInLoadIncrSql.indexOf(columnName3));
            }
            sb.append("GroupId").append("=?");
            tmp.add(this.columnNamesInLoadIncrSql.indexOf("GroupId"));
            this.updateNewSql = sb.toString();
            this.argumentColumnIndexesInIncr = ArrayUtils.toPrimitive((Integer[])tmp.toArray(new Integer[tmp.size()]));
        }
        refArgumentColumnIndexInIncr.setValue((Object)this.argumentColumnIndexesInIncr);
        return this.updateNewSql;
    }

    public String getInsertFastSql() throws Throwable {
        if (this.insertFastSql == null) {
            String columnName;
            StringBuilder sb = new StringBuilder(1024);
            List<MetaColumn> dataColumns = this.getMetaDataColumns();
            int i = 0;
            int size = dataColumns.size();
            while (i < size) {
                MetaColumn metaColumn = dataColumns.get(i);
                columnName = metaColumn.getBindingDBColumnName();
                sb.append(columnName).append("=");
                if (this.getDataColumnIsAssign()[i]) {
                    sb.append("?,");
                } else {
                    sb.append(columnName).append("+?,");
                }
                ++i;
            }
            for (MetaColumn metaColumn : this.getMetaSplitDataColumns()) {
                String columnName2 = metaColumn.getBindingDBColumnName();
                sb.append(columnName2).append("=").append(columnName2).append("+?,");
                columnName2 = MigrationStruct.getBeginColumnName(metaColumn);
                sb.append(columnName2).append("=").append(columnName2).append("+?,");
                columnName2 = MigrationStruct.getEndColumnName(metaColumn);
                sb.append(columnName2).append("=").append(columnName2).append("+?,");
            }
            for (MetaColumn metaColumn : this.getMetaGroupColumns()) {
                int columnIndexByKey = this.getIncrDataTableMetaData().findColumnIndexByKey(metaColumn.getKey());
                if (columnIndexByKey < 0) continue;
                columnName = metaColumn.getBindingDBColumnName();
                sb.append(columnName).append("=");
                sb.append("?,");
            }
            sb.delete(sb.length() - 1, sb.length());
            this.insertFastSql = sb.toString();
        }
        return this.insertFastSql;
    }

    public static String getBeginColumnName(MetaColumn column) {
        return String.valueOf(column.getBindingDBColumnName()) + "_begin";
    }

    public static String getEndColumnName(MetaColumn column) {
        return String.valueOf(column.getBindingDBColumnName()) + "_end";
    }

    public String getLoadIncrSql() throws Throwable {
        if (this.loadIncrSql == null) {
            String columnName;
            StringBuilder sb = new StringBuilder(1024);
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add("OID");
            tmp.add("VERID");
            tmp.add("GroupId");
            sb.append("select OID, VerID, GroupID");
            MetaColumn metaPeriodColumn = this.getMetaPeriodColumn();
            if (metaPeriodColumn != null) {
                for (MetaColumn metaColumn : this.getMetaPeriodGroupColumns()) {
                    columnName = metaColumn.getBindingDBColumnName();
                    sb.append(",").append(columnName);
                    tmp.add(columnName);
                }
                String columnName2 = metaPeriodColumn.getBindingDBColumnName();
                sb.append(",").append(columnName2);
                tmp.add(columnName2);
            }
            for (MetaColumn metaColumn : this.getMetaDataColumns()) {
                columnName = metaColumn.getBindingDBColumnName();
                sb.append(",").append(columnName);
                tmp.add(columnName);
            }
            for (MetaColumn metaColumn : this.getMetaSplitDataColumns()) {
                columnName = metaColumn.getBindingDBColumnName();
                sb.append(",").append(metaColumn.getBindingDBColumnName());
                tmp.add(columnName);
                columnName = MigrationStruct.getBeginColumnName(metaColumn);
                sb.append(",").append(columnName);
                tmp.add(columnName);
                columnName = MigrationStruct.getEndColumnName(metaColumn);
                sb.append(",").append(columnName);
                tmp.add(columnName);
            }
            for (MetaColumn metaColumn : this.getMetaGroupColumns()) {
                int columnIndexByKey = this.getIncrDataTableMetaData().findColumnIndexByKey(metaColumn.getKey());
                if (columnIndexByKey < 0) continue;
                String columnName3 = metaColumn.getBindingDBColumnName();
                sb.append(",").append(metaColumn.getBindingDBColumnName());
                tmp.add(columnName3);
            }
            sb.append(" from ").append(this.getIncrTableName());
            this.loadIncrSql = sb.toString();
            this.columnNamesInLoadIncrSql = tmp;
        }
        return this.loadIncrSql;
    }

    public String getDeleteIncrSql(int length) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("delete from ").append(this.getIncrTableName()).append(" where OID in (?");
        int i = 1;
        while (i < length) {
            sb.append(",?");
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public int[] getIncrSumColumnIndexes() throws Throwable {
        if (this.sumColumnIndexes == null) {
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            int columnIndex = 3;
            MetaColumn metaPeriodColumn = this.getMetaPeriodColumn();
            if (metaPeriodColumn != null) {
                for (MetaColumn metaColumn : this.getMetaPeriodGroupColumns()) {
                    ++columnIndex;
                }
                ++columnIndex;
            }
            boolean[] blArray = this.getDataColumnIsAssign();
            int n = blArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean dataColumnIsAssign = blArray[n2];
                if (!dataColumnIsAssign) {
                    tmp.add(columnIndex);
                }
                ++columnIndex;
                ++n2;
            }
            for (MetaColumn metaColumn : this.getMetaSplitDataColumns()) {
                tmp.add(columnIndex++);
                tmp.add(columnIndex++);
                tmp.add(columnIndex++);
            }
            this.sumColumnIndexes = ArrayUtils.toPrimitive((Integer[])tmp.toArray(new Integer[tmp.size()]));
        }
        return this.sumColumnIndexes;
    }

    public String getLoadGroupIDFromKeysByHashCodeSql(int hashCodeCount) throws Throwable {
        StringBuilder sb;
        if (this.loadGroupIDFromKeysByHashCodeSql == null) {
            sb = new StringBuilder(1024).append("select ");
            List<MetaColumn> metaGroupColumnsForGroupID = this.getMetaGroupColumnsForGroupID();
            metaGroupColumnsForGroupID.stream().forEach(q -> {
                StringBuilder stringBuilder2 = sb.append(q.getKey()).append(",");
            });
            if (metaGroupColumnsForGroupID.size() > 16) {
                sb.append("GroupCountField").append(",");
            }
            sb.append("OID, 0 VERID,HashCode");
            sb.append(" from ").append(this.getKeysTableName());
            sb.append(" where ").append("HashCode").append(" in (");
            this.loadGroupIDFromKeysByHashCodeSql = sb.toString();
        }
        sb = new StringBuilder(1024).append(this.loadGroupIDFromKeysByHashCodeSql);
        sb.append("?");
        int i = 1;
        while (i < hashCodeCount) {
            sb.append(",?");
            ++i;
        }
        sb.append(") order by HashCode");
        return sb.toString();
    }

    public String getInsertKeysSql(RefObject<Integer> argumentSize) throws Throwable {
        List<MetaColumn> metaGroupColumnsForGroupID = this.getMetaGroupColumnsForGroupID();
        int size = metaGroupColumnsForGroupID.size();
        this.insertKeysSql = null;
        int reservedLength = 3;
        if (this.insertKeysSql == null) {
            StringBuilder insertSQL = new StringBuilder(1024).append("insert into ").append(this.getKeysTableName()).append("(");
            metaGroupColumnsForGroupID.stream().forEach(q -> {
                StringBuilder stringBuilder2 = insertSQL.append(q.getKey()).append(",");
            });
            if (size > 16) {
                insertSQL.append("GroupCountField").append(",");
            }
            insertSQL.append("OID,");
            insertSQL.append("VERID,");
            insertSQL.append("HashCode)");
            insertSQL.append(" VALUES (");
            metaGroupColumnsForGroupID.stream().forEach(q -> {
                StringBuilder stringBuilder2 = insertSQL.append("?,");
            });
            if (size > 16) {
                insertSQL.append("?,");
                ++reservedLength;
            }
            insertSQL.append("?,?,?)");
            this.insertKeysSql = insertSQL.toString();
        }
        argumentSize.setValue((Object)(size + reservedLength));
        return this.insertKeysSql;
    }

    public DataTableMetaData getKeysDataTableMetaData() throws StructException, Throwable {
        if (this.keysDataTableMetaData == null) {
            DataTableMetaData tmp = new DataTableMetaData();
            List<MetaColumn> metaGroupColumnsForGroupID = this.getMetaGroupColumnsForGroupID();
            for (MetaColumn metaColumn : metaGroupColumnsForGroupID) {
                ColumnInfo column = new ColumnInfo(metaColumn.getKey(), metaColumn.getDataType().intValue());
                tmp.addColumn(column);
            }
            if (metaGroupColumnsForGroupID.size() > 16) {
                tmp.addColumn(new ColumnInfo("GroupCountField", 1002));
            }
            tmp.addColumn(new ColumnInfo("OID", 1010));
            tmp.addColumn(new ColumnInfo("VERID", 1001));
            tmp.addColumn(new ColumnInfo("HashCode", 1010));
            this.keysDataTableMetaData = tmp;
        }
        return this.keysDataTableMetaData;
    }

    public String getLoadKeysDataByPeriodGroupPeriodSql() throws Throwable {
        StringBuilder sb = new StringBuilder(1024).append("select ");
        this.getMetaGroupColumnsForGroupID().stream().forEach(q -> {
            StringBuilder stringBuilder2 = sb.append(q.getKey()).append(",");
        });
        sb.append("OID, 0 VERID,HashCode");
        sb.append(" from ").append(this.getKeysTableName());
        sb.append(" where ").append("OID").append(" in (select GroupId from ").append(this.getNewTableName()).append(" where ");
        boolean firstWhereClause = true;
        for (MetaColumn metaColumn : this.getMetaPeriodGroupColumns()) {
            if (firstWhereClause) {
                firstWhereClause = false;
            } else {
                sb.append(" and ");
            }
            sb.append(metaColumn.getBindingDBColumnName()).append("=?");
        }
        sb.append(" and ").append(this.getMetaPeriodColumn().getBindingDBColumnName()).append("=?)");
        return sb.toString();
    }

    public String getInsertKeysFromPreviousSql() throws Throwable {
        StringBuilder sb = new StringBuilder(1024).append("insert into ").append(this.getKeysTableName()).append(" (OID,VERID,HashCode");
        List<MetaColumn> metaGroupColumnsForGroupID = this.getMetaGroupColumnsForGroupID();
        metaGroupColumnsForGroupID.stream().forEach(q -> {
            StringBuilder stringBuilder2 = sb.append(",").append(q.getKey());
        });
        if (metaGroupColumnsForGroupID.size() > 16) {
            sb.append("GroupCountField").append(",");
        }
        sb.append(") select OID,VERID,HashCode");
        metaGroupColumnsForGroupID.stream().forEach(q -> {
            StringBuilder stringBuilder2 = sb.append(",").append(q.getKey());
        });
        if (metaGroupColumnsForGroupID.size() > 16) {
            sb.append("GroupCountField").append(",");
        }
        sb.append(" from ").append(this.getPreviousKeysTableName()).append(" where ").append("OID").append(" not in (select OID from ").append(this.getKeysTableName()).append(")");
        return sb.toString();
    }

    public String toString() {
        return String.valueOf(super.toString()) + ":" + this.metaDataObject.getKey();
    }

    public GroupField[] getGroupFields(Group group) {
        if (this.groupFields == null) {
            List<GroupField> allGroupFields = group.getGroupFields();
            ArrayList<GroupField> groupFieldList = new ArrayList<GroupField>(allGroupFields.size());
            String newTableName = this.getNewTableName();
            for (GroupField groupField : allGroupFields) {
                String columnName = group.getColumnNameInTable(groupField, newTableName);
                if (columnName == null || columnName.equalsIgnoreCase("null")) continue;
                groupFieldList.add(groupField);
            }
            this.groupFields = groupFieldList.toArray(new GroupField[groupFieldList.size()]);
        }
        return this.groupFields;
    }

    public DataTableMetaData getIncrDataTableMetaData() throws Throwable {
        if (this.incrDataTableMetaData == null) {
            this.incrDataTableMetaData = MetaTableCache.newEmptyDataTable(MetaTableCache.getFullMetaTable(this.getIncrTableName())).getMetaData();
        }
        return this.incrDataTableMetaData;
    }

    private DataTableMetaData getChangeDataTableMetaData() throws Throwable {
        if (this.changeDataTableMetaData == null) {
            this.changeDataTableMetaData = MetaTableCache.newEmptyDataTable((MetaTable)this.metaDataObject.getTableCollection().get(0)).getMetaData();
        }
        return this.changeDataTableMetaData;
    }

    public int getIncrOIDColumnIndex() throws Throwable {
        if (this.incrOIDColumnIndex == -1) {
            this.incrOIDColumnIndex = this.getIncrDataTableMetaData().findColumnIndexByKey("OID");
        }
        return this.incrOIDColumnIndex;
    }

    public int[] getIncrPeriodColumnIndex() throws Throwable {
        if (this.incrPeriodColumnIndex == null) {
            MetaColumn periodColumn = this.getMetaPeriodColumn();
            if (periodColumn != null) {
                int[] tmp = new int[2];
                String columnName = periodColumn.getBindingDBColumnName();
                tmp[0] = this.getIncrDataTableMetaData().findColumnIndexByKey(columnName);
                tmp[1] = this.getChangeDataTableMetaData().findColumnIndexByKey(columnName);
                this.incrPeriodColumnIndex = tmp;
            } else {
                this.incrPeriodColumnIndex = new int[]{-1, -1};
            }
        }
        return this.incrPeriodColumnIndex;
    }

    public int[][] getIncrSplitDataColumnIndexes() throws Throwable {
        if (this.incrSplitDataColumnIndexes == null) {
            List<MetaColumn> metaSplitDataColumns = this.getMetaSplitDataColumns();
            int size = metaSplitDataColumns.size();
            int[][] tmp = new int[2][size];
            DataTableMetaData incrMetaData = this.getIncrDataTableMetaData();
            DataTableMetaData changeMetaData = this.getChangeDataTableMetaData();
            int i = 0;
            while (i < size) {
                MetaColumn metaColumn = metaSplitDataColumns.get(i);
                String columnName = metaColumn.getBindingDBColumnName();
                tmp[0][i] = incrMetaData.findColumnIndexByKey(columnName);
                tmp[1][i] = changeMetaData.findColumnIndexByKey(columnName);
                ++i;
            }
            this.incrSplitDataColumnIndexes = tmp;
        }
        return this.incrSplitDataColumnIndexes;
    }

    public int[] getIncrBeginColumnIndexes() throws Throwable {
        if (this.incrBeginColumnIndexes == null) {
            List<MetaColumn> metaSplitDataColumns = this.getMetaSplitDataColumns();
            int size = metaSplitDataColumns.size();
            int[] tmp = new int[size];
            int i = 0;
            while (i < size) {
                MetaColumn metaColumn = metaSplitDataColumns.get(i);
                tmp[i] = this.getIncrDataTableMetaData().findColumnIndexByKey(MigrationStruct.getBeginColumnName(metaColumn));
                ++i;
            }
            this.incrBeginColumnIndexes = tmp;
        }
        return this.incrBeginColumnIndexes;
    }

    public int[] getIncrEndColumnIndexes() throws Throwable {
        if (this.incrEndColumnIndexes == null) {
            List<MetaColumn> metaSplitDataColumns = this.getMetaSplitDataColumns();
            int size = metaSplitDataColumns.size();
            int[] tmp = new int[size];
            int i = 0;
            while (i < size) {
                MetaColumn metaColumn = metaSplitDataColumns.get(i);
                tmp[i] = this.getIncrDataTableMetaData().findColumnIndexByKey(MigrationStruct.getEndColumnName(metaColumn));
                ++i;
            }
            this.incrEndColumnIndexes = tmp;
        }
        return this.incrEndColumnIndexes;
    }

    public int[][] getIncrDataNoSplitColumnIndexes() throws Throwable {
        if (this.incrDataNoSplitColumnIndexes == null) {
            List<MetaColumn> metaDataColumns = this.getMetaDataColumns();
            int[][] tmp = new int[2][metaDataColumns.size()];
            int i = 0;
            DataTableMetaData incrMetaData = this.getIncrDataTableMetaData();
            DataTableMetaData changeMetaData = this.getChangeDataTableMetaData();
            for (MetaColumn metaColumn : metaDataColumns) {
                String columnName = metaColumn.getBindingDBColumnName();
                tmp[0][i] = incrMetaData.findColumnIndexByKey(columnName);
                tmp[1][i] = changeMetaData.findColumnIndexByKey(columnName);
                ++i;
            }
            this.incrDataNoSplitColumnIndexes = tmp;
        }
        return this.incrDataNoSplitColumnIndexes;
    }

    public int getIncrGroupIDColumnIndex() throws Throwable {
        if (this.incrGroupIDColumnIndex == -1) {
            this.incrGroupIDColumnIndex = this.getIncrDataTableMetaData().findColumnIndexByKey("GroupId");
        }
        return this.incrGroupIDColumnIndex;
    }

    public int[][] getIncrPeriodGroupColumnIndexes() throws Throwable {
        if (this.incrPeriodGroupColumnIndexes == null) {
            List<MetaColumn> metaPeriodGroupColumns = this.getMetaPeriodGroupColumns();
            int[][] tmp = new int[2][metaPeriodGroupColumns.size()];
            int i = 0;
            DataTableMetaData incrMetaData = this.getIncrDataTableMetaData();
            DataTableMetaData changeMetaData = this.getChangeDataTableMetaData();
            for (MetaColumn metaColumn : metaPeriodGroupColumns) {
                String columnName = metaColumn.getBindingDBColumnName();
                tmp[0][i] = incrMetaData.findColumnIndexByKey(columnName);
                tmp[1][i] = changeMetaData.findColumnIndexByKey(columnName);
                ++i;
            }
            this.incrPeriodGroupColumnIndexes = tmp;
        }
        return this.incrPeriodGroupColumnIndexes;
    }
}

