/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbmanager.interceptor.stage;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.connection.dbmanager.ListQueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.dbmanager.interceptor.ISqlExecuteInterceptor;
import com.bokesoft.yes.mid.dbmanager.interceptor.stage.ISqlProcessStage;
import com.bokesoft.yes.mid.dbmanager.interceptor.stage.visitor.BaseExpressionVisitor;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.JSQLParserException;
import net.boke.jsqlparser.expression.DateValue;
import net.boke.jsqlparser.expression.DoubleValue;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.TimeValue;
import net.boke.jsqlparser.expression.TimestampValue;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.delete.Delete;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SubSelect;

public class LargeInToSubSelectStage<T>
extends BaseExpressionVisitor
implements ISqlProcessStage<T> {
    private static final String T_SYS_DBTEMP = "sys_dbtemp";
    private static final String C_TEMPID = "tempid";
    private static final String C_VTAG = "vtag";
    private static final String C_VSTR = "vstr";
    private static final String C_VNUM = "vnum";
    private static final String S_TEMP_INSQL_VSTR = "select vstr from sys_dbtemp where tempid=?";
    private static final String S_TEMP_INSQL_VNUM = "select vnum from sys_dbtemp where tempid=?";
    private static final String S_TEMP_DELETESQL = "delete from sys_dbtemp where tempid=%?";
    private ArrayList<SqlString> preSqls = null;
    private ArrayList<SqlString> postSqls = null;
    private boolean bReplaced = false;
    private QueryArguments curOrgArgs = null;
    private ArrayList<Object> newArgs = new ArrayList();
    private int parameterIndex = -1;
    private int dbType = -1;
    private int limitInSize = 950;

    public LargeInToSubSelectStage(int dbType, int limitInSize) {
        this.dbType = dbType;
        this.limitInSize = limitInSize;
    }

    private void init(QueryArguments args) {
        this.bReplaced = false;
        this.curOrgArgs = args;
        this.newArgs.clear();
        this.preSqls = null;
        this.postSqls = null;
        this.parameterIndex = -1;
    }

    @Override
    public T execute(PreparedStatement ps, String sql, QueryArguments args, ISqlExecuteInterceptor<T> sqlExecInterceptor) throws Throwable {
        if ((args == null || args.size() < this.limitInSize) && sql.length() < this.limitInSize) {
            return sqlExecInterceptor.execute(ps, sql, args, true);
        }
        this.init(args);
        Statement statement = null;
        try {
            statement = SqlInfos.instance.parseSql(sql);
        }
        catch (JSQLParserException e) {
            return sqlExecInterceptor.execute(ps, sql, args, true);
        }
        if (statement instanceof Select) {
            Select selectStatement = (Select)statement;
            selectStatement.getSelectBody().accept(this);
        } else if (statement instanceof Delete) {
            ((Delete)statement).getWhere().accept(this);
        }
        if (this.bReplaced) {
            return this.execLargeInSql(sql, statement, sqlExecInterceptor);
        }
        return sqlExecInterceptor.execute(ps, sql, args, true);
    }

    private T execLargeInSql(String sql, Statement statement, ISqlExecuteInterceptor<T> sqlExecInterceptor) throws Throwable {
        if (this.preSqls != null) {
            for (SqlString preSql : this.preSqls) {
                sqlExecInterceptor.update(preSql.getSql(), preSql.getParameterListNotNull());
            }
        }
        T result = null;
        SqlInfos.instance.remove(sql);
        String newSql = statement.toString();
        PreparedStatement newPS = sqlExecInterceptor.prepareStatement(newSql);
        ListQueryArguments newArgs = new ListQueryArguments(null, this.newArgs);
        result = sqlExecInterceptor.execute(newPS, newSql, (QueryArguments)newArgs, true);
        if (this.postSqls != null) {
            for (SqlString postSql : this.postSqls) {
                sqlExecInterceptor.update(postSql.getSql(), postSql.getParameterListNotNull());
            }
        }
        return result;
    }

    @Override
    public void visit(InExpression inExpression) {
        if (inExpression.getItemsList() instanceof ExpressionList) {
            List expressionList = ((ExpressionList)inExpression.getItemsList()).getExpressions();
            int count = expressionList.size();
            if (count > this.limitInSize) {
                long tempid = System.currentTimeMillis();
                SqlString insertSql = this.prepareTempInsertSQL();
                boolean isNumParaValue = false;
                int j = 0;
                while (j < count) {
                    Object tmp = expressionList.get(j);
                    Object value = null;
                    if (tmp instanceof JdbcParameter) {
                        ++this.parameterIndex;
                        value = this.curOrgArgs.get(this.parameterIndex);
                    } else {
                        value = LargeInToSubSelectStage.getExpressionValue((Expression)tmp);
                    }
                    isNumParaValue = StringUtil.isNumeric((Object)value);
                    if (this.dbType == 4 || this.dbType == 1 || this.dbType == 8) {
                        this.addRowsBlock(insertSql, tempid, "", value, isNumParaValue);
                        if (insertSql.getParameterListNotNull().size() > 2000) {
                            this.ensurePreSqls().add(insertSql);
                            insertSql = this.prepareTempInsertSQL();
                        }
                    } else {
                        this.addOneRowBlock(insertSql, tempid, "", value, isNumParaValue);
                        this.ensurePreSqls().add(insertSql);
                        insertSql = this.prepareTempInsertSQL();
                    }
                    ++j;
                }
                if (insertSql.getParameterListNotNull().size() > 0) {
                    this.ensurePreSqls().add(insertSql);
                }
                this.ensurePostSqls().add(this.createTempDeleteSQL(tempid));
                this.replaceTempInSql(tempid, inExpression, isNumParaValue);
                this.bReplaced = true;
            } else {
                inExpression.getItemsList().accept(this);
            }
        } else {
            inExpression.getItemsList().accept(this);
        }
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        ++this.parameterIndex;
        this.newArgs.add(this.curOrgArgs.get(this.parameterIndex));
    }

    private void replaceTempInSql(long tempID, InExpression inExpression, boolean isNumPara) {
        try {
            Select select = (Select)SqlInfos.instance.parseSql(isNumPara ? S_TEMP_INSQL_VNUM : S_TEMP_INSQL_VSTR);
            PlainSelect selectBody = (PlainSelect)select.getSelectBody();
            SubSelect sub = new SubSelect();
            sub.setSelectBody(selectBody);
            inExpression.setItemsList(sub);
            this.newArgs.add(tempID);
        }
        catch (JSQLParserException e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
        }
    }

    private SqlString prepareTempInsertSQL() {
        return SqlString.format("insert into %s (%s,%s,%s,%s) values ", T_SYS_DBTEMP, C_TEMPID, C_VTAG, C_VNUM, C_VSTR);
    }

    private void addRowsBlock(SqlString insertSql, long tempid, String vtag, Object value, boolean isNumParaValue) {
        if (insertSql.getParameterListNotNull().size() > 0) {
            insertSql.append(",");
        }
        this.addOneRowBlock(insertSql, tempid, vtag, value, isNumParaValue);
    }

    private void addOneRowBlock(SqlString insertSql, long tempid, String vtag, Object value, boolean isNumParaValue) {
        insertSql.append("(");
        insertSql.appendPara(tempid);
        insertSql.append(",");
        insertSql.appendPara(vtag);
        insertSql.append(",");
        if (isNumParaValue) {
            insertSql.appendPara(value);
            insertSql.append(",");
            insertSql.appendPara("");
        } else {
            insertSql.appendPara(-1);
            insertSql.append(",");
            insertSql.appendPara(value);
        }
        insertSql.append(")");
    }

    private SqlString createTempDeleteSQL(long tempid) {
        return SqlString.format(S_TEMP_DELETESQL, tempid);
    }

    private ArrayList<SqlString> ensurePreSqls() {
        if (this.preSqls == null) {
            this.preSqls = new ArrayList();
        }
        return this.preSqls;
    }

    private ArrayList<SqlString> ensurePostSqls() {
        if (this.postSqls == null) {
            this.postSqls = new ArrayList();
        }
        return this.postSqls;
    }

    private static Object getExpressionValue(Expression exp) {
        if (exp instanceof LongValue) {
            return ((LongValue)exp).getValue();
        }
        if (exp instanceof DoubleValue) {
            return ((DoubleValue)exp).getValue();
        }
        if (exp instanceof StringValue) {
            return ((StringValue)exp).getValue();
        }
        if (exp instanceof DateValue) {
            return ((DateValue)exp).getValue();
        }
        if (exp instanceof TimestampValue) {
            return ((TimestampValue)exp).getValue();
        }
        if (exp instanceof TimeValue) {
            return ((TimeValue)exp).getValue();
        }
        return exp.toString();
    }

    public static <T> LargeInToSubSelectStage<T> newInstance(int dbType, int limitInSize) {
        return new LargeInToSubSelectStage<T>(dbType, limitInSize);
    }

    public static <T> LargeInToSubSelectStage<T> newInstance(int dbType) {
        return new LargeInToSubSelectStage<T>(dbType, 950);
    }
}

