/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbmanager.interceptor;

import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.dbmanager.interceptor.ISqlExecuteInterceptor;
import com.bokesoft.yes.mid.dbmanager.interceptor.stage.ISqlProcessStage;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class AbstractExecuteInterceptor<T>
implements ISqlExecuteInterceptor<T> {
    private List<ISqlProcessStage<T>> handlers;
    private Stack<ISqlProcessStage<T>> stackTempStage = new Stack();
    private final Object executeLock = new Object();
    private boolean bIntercepting = false;

    @SafeVarargs
    public AbstractExecuteInterceptor(ISqlProcessStage<T> ... processStages) {
        this.handlers = new ArrayList<ISqlProcessStage<T>>();
        ISqlProcessStage<T>[] iSqlProcessStageArray = processStages;
        int n = processStages.length;
        int n2 = 0;
        while (n2 < n) {
            ISqlProcessStage<T> stage = iSqlProcessStageArray[n2];
            this.handlers.add(stage);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T execute(PreparedStatement ps, String sql, QueryArguments args, boolean callByStage) throws Throwable {
        T result = null;
        Object object = this.executeLock;
        synchronized (object) {
            if (!callByStage) {
                this.bIntercepting = true;
                this.prepareProcessStage();
            }
            if (this.stackTempStage.isEmpty()) {
                result = this.runExecute(ps, sql, args);
            }
            while (!this.stackTempStage.isEmpty()) {
                ISqlProcessStage<T> stage = this.stackTempStage.pop();
                result = stage.execute(ps, sql, args, this);
            }
            if (!callByStage) {
                this.bIntercepting = false;
            }
        }
        return result;
    }

    @Override
    public boolean isIntercepting() {
        return this.bIntercepting;
    }

    private void prepareProcessStage() {
        this.stackTempStage.clear();
        for (ISqlProcessStage<T> stage : this.handlers) {
            this.stackTempStage.push(stage);
        }
    }

    protected abstract T runExecute(PreparedStatement var1, String var2, QueryArguments var3) throws Throwable;
}

