/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.preload;

import com.bokesoft.yes.mid.base.MidVEUtil;
import com.bokesoft.yes.mid.dbcache.parsedsql.LongOrLongArray;
import com.bokesoft.yes.mid.dbcache.preload.PreLoadSetting;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PreLoadData {
    private static final String STR_PreLoadDatas = "PreLoadDatas";

    public static void registerData(String tableKey, DataTable dataTable) {
        if (dataTable == null || dataTable.size() == 1) {
            return;
        }
        Map threadLocalDatas = MidVEUtil.getThreadLocalData();
        HashMap<String, DataTable> preLoadDatas = (HashMap<String, DataTable>)threadLocalDatas.get(STR_PreLoadDatas);
        if (preLoadDatas == null) {
            preLoadDatas = new HashMap<String, DataTable>();
            threadLocalDatas.put(STR_PreLoadDatas, preLoadDatas);
        }
        preLoadDatas.put(tableKey, dataTable);
    }

    public static Long[] getPreLoadOID(String tableKey, Long startLoadOID) throws Throwable {
        String[][] oidSource = PreLoadSetting.getOIDSource(tableKey);
        if (oidSource != null) {
            HashSet<Long> result = new HashSet<Long>();
            Map threadLocalDatas = MidVEUtil.getThreadLocalData();
            if (threadLocalDatas.isEmpty()) {
                return null;
            }
            Map map = (Map)threadLocalDatas.get(STR_PreLoadDatas);
            String[][] stringArray = oidSource;
            int n = oidSource.length;
            int n2 = 0;
            while (n2 < n) {
                DataTable dt;
                String[] tableColumn = stringArray[n2];
                String tableName = tableColumn[0];
                if (map != null && (dt = (DataTable)map.get(tableName)) != null) {
                    PreLoadData.getPreLoadOID(dt, tableColumn[1], result);
                }
                ++n2;
            }
            if (result != null && result.size() > 1 && result.contains(startLoadOID)) {
                return result.toArray(new Long[result.size()]);
            }
        }
        return null;
    }

    public static Long[] getPreLoadOID(String tableKey, LongOrLongArray startLoadOIDs) throws Throwable {
        String[][] oidSource = PreLoadSetting.getOIDSource(tableKey);
        if (oidSource != null) {
            HashSet<Long> result = new HashSet<Long>();
            Map threadLocalDatas = MidVEUtil.getThreadLocalData();
            if (threadLocalDatas.isEmpty()) {
                return null;
            }
            Map map = (Map)threadLocalDatas.get(STR_PreLoadDatas);
            String[][] stringArray = oidSource;
            int n = oidSource.length;
            int n2 = 0;
            while (n2 < n) {
                DataTable dt;
                String[] tableColumn = stringArray[n2];
                String tableName = tableColumn[0];
                if (map != null && (dt = (DataTable)map.get(tableName)) != null) {
                    PreLoadData.getPreLoadOID(dt, tableColumn[1], result);
                }
                ++n2;
            }
            if (result != null && result.size() > 1 && LongOrLongArray.isSetContains(result, startLoadOIDs)) {
                return result.toArray(new Long[result.size()]);
            }
        }
        return null;
    }

    private static void getPreLoadOID(DataTable dataTable, String columnName, Set<Long> result) throws Throwable {
        int columnIndex = dataTable.getMetaData().findColumnIndexByKey(columnName);
        if (columnIndex >= 0) {
            int rowIndex = 0;
            int size = dataTable.size();
            while (rowIndex < size) {
                Long value = dataTable.getLong(rowIndex, columnIndex);
                result.add(value);
                ++rowIndex;
            }
        }
    }

    public static Map<Long, Set<Long>> getPreLoadSecondFieldSOID(String tableKey, Long startLoadSecondFieldID, Long startLoadSOID) throws Throwable {
        String[][] soidSource = PreLoadSetting.getSOIDUniqueIndexSecondField(tableKey);
        if (soidSource != null) {
            HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>();
            Map threadLocalDatas = MidVEUtil.getThreadLocalData();
            if (threadLocalDatas.isEmpty()) {
                return null;
            }
            Map map = (Map)threadLocalDatas.get(STR_PreLoadDatas);
            String[][] stringArray = soidSource;
            int n = soidSource.length;
            int n2 = 0;
            while (n2 < n) {
                DataTable dt;
                String[] tableColumn = stringArray[n2];
                String tableName = tableColumn[0];
                if (map != null && (dt = (DataTable)map.get(tableName)) != null) {
                    int secondFieldColumnIndex = dt.getMetaData().findColumnIndexByKey(tableColumn[2]);
                    int soidColumnIndex = dt.getMetaData().findColumnIndexByKey(tableColumn[1]);
                    if (secondFieldColumnIndex >= 0 && soidColumnIndex >= 0) {
                        int rowIndex = 0;
                        int size = dt.size();
                        while (rowIndex < size) {
                            Long secondFieldID = dt.getLong(rowIndex, secondFieldColumnIndex);
                            Long soid = dt.getLong(rowIndex, soidColumnIndex);
                            HashSet<Long> tmp = (HashSet<Long>)result.get(secondFieldID);
                            if (tmp == null) {
                                tmp = new HashSet<Long>();
                                result.put(secondFieldID, tmp);
                            }
                            tmp.add(soid);
                            ++rowIndex;
                        }
                    }
                }
                ++n2;
            }
            if (result == null || !result.containsKey(startLoadSecondFieldID) || !((Set)result.get(startLoadSecondFieldID)).contains(startLoadSOID)) {
                return null;
            }
            return result;
        }
        return null;
    }
}

