/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.datatable;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil;
import com.bokesoft.yes.mid.dbcache.structure.OrderBy;
import com.bokesoft.yes.mid.mysqls.resultset.JoinResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetAndPos;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class OrderByUtil {
    public static Object orderBy(List<Integer> validRowIndexes, final List<OrderBy> orderByObjects, final DataTable dataTable) {
        validRowIndexes.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer rowIndex1, Integer rowIndex2) {
                int result = 0;
                try {
                    Row row1 = DataTableExUtil.getRowByIndex(dataTable, rowIndex1);
                    Row row2 = DataTableExUtil.getRowByIndex(dataTable, rowIndex2);
                    for (OrderBy orderByObject : orderByObjects) {
                        Integer columnIndex = orderByObject.getColumnIndex();
                        Boolean asc = orderByObject.getAsc();
                        Object value1 = row1.getObject(columnIndex.intValue());
                        Object value2 = row2.getObject(columnIndex.intValue());
                        int tempResult = OrderByUtil.compareObject(asc, value1, value2);
                        result = tempResult;
                        if (result == 0) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("\u6392\u5e8f\u51fa\u9519\uff01", throwable);
                }
                return result;
            }
        });
        return true;
    }

    public static void orderBy(final JoinResultSet joinResultSet, final List<OrderBy> orderByObjects) {
        int rowCount = joinResultSet.getRowCount();
        if (rowCount <= 1) {
            return;
        }
        List<int[]> posList = joinResultSet.getPosList();
        posList.sort(new Comparator<int[]>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int compare(int[] o1, int[] o2) {
                int result = 0;
                try {
                    Object value2;
                    Object value1;
                    Boolean asc;
                    int tempResult;
                    Iterator iterator = orderByObjects.iterator();
                    do {
                        if (!iterator.hasNext()) {
                            return result;
                        }
                        OrderBy orderByObject = (OrderBy)iterator.next();
                        String columnName = orderByObject.getColumnName();
                        if (columnName == null) {
                            return 0;
                        }
                        asc = orderByObject.getAsc();
                        value1 = joinResultSet.getObject(o1, columnName);
                        value2 = joinResultSet.getObject(o2, columnName);
                    } while ((result = (tempResult = OrderByUtil.compareObject(asc, value1, value2))) == 0);
                    return result;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("\u6392\u5e8f\u51fa\u9519\uff01", throwable);
                }
            }
        });
        LogSvr.getInstance().info(String.valueOf(rowCount));
    }

    public static Object orderBy(List<ResultSetAndPos> rows, final List<OrderBy> orderByObjects) {
        rows.sort(new Comparator<ResultSetAndPos>(){

            @Override
            public int compare(ResultSetAndPos row1, ResultSetAndPos row2) {
                if (row1 == null) {
                    return -1;
                }
                if (row2 == null) {
                    return 1;
                }
                int result = 0;
                try {
                    for (OrderBy orderByObject : orderByObjects) {
                        String columnName = orderByObject.getColumnName();
                        Boolean asc = orderByObject.getAsc();
                        Object value1 = row1.resultSet.getObject(row1.pos, columnName);
                        Object value2 = row2.resultSet.getObject(row2.pos, columnName);
                        int tempResult = OrderByUtil.compareObject(asc, value1, value2);
                        result = tempResult;
                        if (result == 0) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("\u6392\u5e8f\u51fa\u9519\uff01", throwable);
                }
                return result;
            }
        });
        return true;
    }

    private static int compareObject(boolean isAsc, Object value1, Object value2) throws Exception {
        if (value1 == null && value2 != null) {
            return -1;
        }
        if (value1 != null && value2 == null) {
            return 1;
        }
        if (value1 == null && value2 == null) {
            return 0;
        }
        int result = 0;
        if (value1 instanceof String) {
            String para1 = (String)value1;
            String para2 = (String)value2;
            result = para1.compareTo(para2);
        } else if (value1 instanceof Integer) {
            Integer para1 = (Integer)value1;
            Integer para2 = (Integer)value2;
            result = para1.compareTo(para2);
        } else if (value1 instanceof Long) {
            Long para1 = (Long)value1;
            Long para2 = (Long)value2;
            result = para1.compareTo(para2);
        } else if (value1 instanceof Date) {
            Date para1 = (Date)value1;
            Date para2 = (Date)value2;
            result = para1.compareTo(para2);
        } else if (value1 instanceof BigDecimal) {
            result = ((BigDecimal)value1).compareTo((BigDecimal)value2);
        }
        if (!isAsc) {
            result = Math.negateExact(result);
        }
        return result;
    }
}

